/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_11.dsl.internal;

import io.fabric8.kubernetes.api.model.v5_11.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_11.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v5_11.Config;
import io.fabric8.kubernetes.clnt.v5_11.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_11.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_11.utils.ApiVersionUtil;
import io.fabric8.kubernetes.clnt.v5_11.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v5_11.utils.Utils;
import io.fabric8.openshift.clnt.v5_11.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_11.OpenShiftConfigBuilder;
import java.net.MalformedURLException;
import java.net.URL;

public class OpenShiftOperation<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
extends HasMetadataOperation<T, L, R> {
    public static final String OPENSHIFT_APIGROUP_SUFFIX = "openshift.io";

    public OpenShiftOperation(OperationContext ctx, Class<T> type, Class<L> listType) {
        super(OpenShiftOperation.wrap(ctx), type, listType);
        this.updateApiVersion();
    }

    static OperationContext wrap(OperationContext context) {
        OpenShiftConfig config = OpenShiftConfig.wrap(context.getConfig());
        String oapiVersion = config.getOapiVersion();
        if (Utils.isNotNullOrEmpty(context.getApiGroupName())) {
            return OpenShiftOperation.getOperationContextWithApiGroupName(config, context, oapiVersion);
        }
        String apiGroupUrl = URLUtils.join(config.getMasterUrl(), "oapi", oapiVersion);
        return context.withConfig(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupVersion(oapiVersion);
    }

    static OperationContext getOperationContextWithApiGroupName(OpenShiftConfig config, OperationContext context, String oapiVersion) {
        String apiGroupVersionFromConfig = Utils.isNotNullOrEmpty(context.getApiGroupVersion()) ? context.getApiGroupVersion() : oapiVersion;
        return OpenShiftOperation.getOperationContextWithApiGroupVersion(config, context, apiGroupVersionFromConfig);
    }

    private static OperationContext getOperationContextWithApiGroupVersion(OpenShiftConfig config, OperationContext context, String version) {
        String apiGroupUrl = URLUtils.join(config.getMasterUrl(), "apis", context.getApiGroupName(), version);
        String apiGroupVersion = URLUtils.join(context.getApiGroupName(), version);
        return context.withConfig(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupName(context.getApiGroupName()).withApiGroupVersion(apiGroupVersion);
    }

    @Override
    public OpenShiftConfig getConfig() {
        return OpenShiftConfig.wrap(super.getConfig());
    }

    @Override
    public URL getRootUrl() {
        if (Utils.isNullOrEmpty(this.context.getApiGroupName())) {
            try {
                return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
            }
            catch (MalformedURLException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }
        return super.getRootUrl();
    }

    private void updateApiVersion() {
        this.apiVersion = ApiVersionUtil.joinApiGroupAndVersion(this.apiGroupName, this.apiGroupVersion);
    }

    @Override
    protected Class<? extends Config> getConfigType() {
        return OpenShiftConfig.class;
    }
}

