/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_11.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.openshift.api.model.v5_11.machineconfig.v1.MachineConfigSpec;
import io.fabric8.openshift.api.model.v5_11.machineconfig.v1.MachineConfigSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MachineConfigSpecFluentImpl<A extends MachineConfigSpecFluent<A>>
extends BaseFluent<A>
implements MachineConfigSpecFluent<A> {
    private Map<String, Object> config;
    private List<String> extensions = new ArrayList<String>();
    private Boolean fips;
    private List<String> kernelArguments = new ArrayList<String>();
    private String kernelType;
    private String osImageURL;
    private Map<String, Object> additionalProperties;

    public MachineConfigSpecFluentImpl() {
    }

    public MachineConfigSpecFluentImpl(MachineConfigSpec instance) {
        this.withConfig(instance.getConfig());
        this.withExtensions(instance.getExtensions());
        this.withFips(instance.getFips());
        this.withKernelArguments(instance.getKernelArguments());
        this.withKernelType(instance.getKernelType());
        this.withOsImageURL(instance.getOsImageURL());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToConfig(String key, Object value) {
        if (this.config == null && key != null && value != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.config.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToConfig(Map<String, Object> map) {
        if (this.config == null && map != null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.config.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(String key) {
        if (this.config == null) {
            return (A)this;
        }
        if (key != null && this.config != null) {
            this.config.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfig(Map<String, Object> map) {
        if (this.config == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.config == null) continue;
                this.config.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Override
    public <K, V> A withConfig(Map<String, Object> config) {
        this.config = config == null ? null : new LinkedHashMap<String, Object>(config);
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.config != null;
    }

    @Override
    public A addToExtensions(Integer index, String item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<String>();
        }
        this.extensions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToExtensions(Integer index, String item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<String>();
        }
        this.extensions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToExtensions(String ... items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<String>();
        }
        for (String item : items) {
            this.extensions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToExtensions(Collection<String> items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<String>();
        }
        for (String item : items) {
            this.extensions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtensions(String ... items) {
        for (String item : items) {
            if (this.extensions == null) continue;
            this.extensions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExtensions(Collection<String> items) {
        for (String item : items) {
            if (this.extensions == null) continue;
            this.extensions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public String getExtension(Integer index) {
        return this.extensions.get(index);
    }

    @Override
    public String getFirstExtension() {
        return this.extensions.get(0);
    }

    @Override
    public String getLastExtension() {
        return this.extensions.get(this.extensions.size() - 1);
    }

    @Override
    public String getMatchingExtension(Predicate<String> predicate) {
        for (String item : this.extensions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExtension(Predicate<String> predicate) {
        for (String item : this.extensions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExtensions(List<String> extensions) {
        if (extensions != null) {
            this.extensions = new ArrayList<String>();
            for (String item : extensions) {
                this.addToExtensions(item);
            }
        } else {
            this.extensions = null;
        }
        return (A)this;
    }

    @Override
    public A withExtensions(String ... extensions) {
        if (this.extensions != null) {
            this.extensions.clear();
        }
        if (extensions != null) {
            for (String item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public A addNewExtension(String arg0) {
        return this.addToExtensions(new String(arg0));
    }

    @Override
    public Boolean getFips() {
        return this.fips;
    }

    @Override
    public A withFips(Boolean fips) {
        this.fips = fips;
        return (A)this;
    }

    @Override
    public Boolean hasFips() {
        return this.fips != null;
    }

    @Override
    public A addToKernelArguments(Integer index, String item) {
        if (this.kernelArguments == null) {
            this.kernelArguments = new ArrayList<String>();
        }
        this.kernelArguments.add(index, item);
        return (A)this;
    }

    @Override
    public A setToKernelArguments(Integer index, String item) {
        if (this.kernelArguments == null) {
            this.kernelArguments = new ArrayList<String>();
        }
        this.kernelArguments.set(index, item);
        return (A)this;
    }

    @Override
    public A addToKernelArguments(String ... items) {
        if (this.kernelArguments == null) {
            this.kernelArguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.kernelArguments.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToKernelArguments(Collection<String> items) {
        if (this.kernelArguments == null) {
            this.kernelArguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.kernelArguments.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromKernelArguments(String ... items) {
        for (String item : items) {
            if (this.kernelArguments == null) continue;
            this.kernelArguments.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromKernelArguments(Collection<String> items) {
        for (String item : items) {
            if (this.kernelArguments == null) continue;
            this.kernelArguments.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getKernelArguments() {
        return this.kernelArguments;
    }

    @Override
    public String getKernelArgument(Integer index) {
        return this.kernelArguments.get(index);
    }

    @Override
    public String getFirstKernelArgument() {
        return this.kernelArguments.get(0);
    }

    @Override
    public String getLastKernelArgument() {
        return this.kernelArguments.get(this.kernelArguments.size() - 1);
    }

    @Override
    public String getMatchingKernelArgument(Predicate<String> predicate) {
        for (String item : this.kernelArguments) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingKernelArgument(Predicate<String> predicate) {
        for (String item : this.kernelArguments) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withKernelArguments(List<String> kernelArguments) {
        if (kernelArguments != null) {
            this.kernelArguments = new ArrayList<String>();
            for (String item : kernelArguments) {
                this.addToKernelArguments(item);
            }
        } else {
            this.kernelArguments = null;
        }
        return (A)this;
    }

    @Override
    public A withKernelArguments(String ... kernelArguments) {
        if (this.kernelArguments != null) {
            this.kernelArguments.clear();
        }
        if (kernelArguments != null) {
            for (String item : kernelArguments) {
                this.addToKernelArguments(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasKernelArguments() {
        return this.kernelArguments != null && !this.kernelArguments.isEmpty();
    }

    @Override
    public A addNewKernelArgument(String arg0) {
        return this.addToKernelArguments(new String(arg0));
    }

    @Override
    public String getKernelType() {
        return this.kernelType;
    }

    @Override
    public A withKernelType(String kernelType) {
        this.kernelType = kernelType;
        return (A)this;
    }

    @Override
    public Boolean hasKernelType() {
        return this.kernelType != null;
    }

    @Override
    @Deprecated
    public A withNewKernelType(String arg0) {
        return this.withKernelType(new String(arg0));
    }

    @Override
    public String getOsImageURL() {
        return this.osImageURL;
    }

    @Override
    public A withOsImageURL(String osImageURL) {
        this.osImageURL = osImageURL;
        return (A)this;
    }

    @Override
    public Boolean hasOsImageURL() {
        return this.osImageURL != null;
    }

    @Override
    @Deprecated
    public A withNewOsImageURL(String arg0) {
        return this.withOsImageURL(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachineConfigSpecFluentImpl that = (MachineConfigSpecFluentImpl)o;
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        if (this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null) {
            return false;
        }
        if (this.fips != null ? !this.fips.equals(that.fips) : that.fips != null) {
            return false;
        }
        if (this.kernelArguments != null ? !this.kernelArguments.equals(that.kernelArguments) : that.kernelArguments != null) {
            return false;
        }
        if (this.kernelType != null ? !this.kernelType.equals(that.kernelType) : that.kernelType != null) {
            return false;
        }
        if (this.osImageURL != null ? !this.osImageURL.equals(that.osImageURL) : that.osImageURL != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.extensions, this.fips, this.kernelArguments, this.kernelType, this.osImageURL, this.additionalProperties, super.hashCode());
    }
}

