/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_11;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.openshift.api.model.v5_11.SecretLocalReference;
import io.fabric8.openshift.api.model.v5_11.SecretLocalReferenceBuilder;
import io.fabric8.openshift.api.model.v5_11.SecretLocalReferenceFluentImpl;
import io.fabric8.openshift.api.model.v5_11.WebHookTrigger;
import io.fabric8.openshift.api.model.v5_11.WebHookTriggerFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class WebHookTriggerFluentImpl<A extends WebHookTriggerFluent<A>>
extends BaseFluent<A>
implements WebHookTriggerFluent<A> {
    private Boolean allowEnv;
    private String secret;
    private SecretLocalReferenceBuilder secretReference;
    private Map<String, Object> additionalProperties;

    public WebHookTriggerFluentImpl() {
    }

    public WebHookTriggerFluentImpl(WebHookTrigger instance) {
        this.withAllowEnv(instance.getAllowEnv());
        this.withSecret(instance.getSecret());
        this.withSecretReference(instance.getSecretReference());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Boolean getAllowEnv() {
        return this.allowEnv;
    }

    @Override
    public A withAllowEnv(Boolean allowEnv) {
        this.allowEnv = allowEnv;
        return (A)this;
    }

    @Override
    public Boolean hasAllowEnv() {
        return this.allowEnv != null;
    }

    @Override
    public String getSecret() {
        return this.secret;
    }

    @Override
    public A withSecret(String secret) {
        this.secret = secret;
        return (A)this;
    }

    @Override
    public Boolean hasSecret() {
        return this.secret != null;
    }

    @Override
    @Deprecated
    public A withNewSecret(String arg0) {
        return this.withSecret(new String(arg0));
    }

    @Override
    @Deprecated
    public SecretLocalReference getSecretReference() {
        return this.secretReference != null ? this.secretReference.build() : null;
    }

    @Override
    public SecretLocalReference buildSecretReference() {
        return this.secretReference != null ? this.secretReference.build() : null;
    }

    @Override
    public A withSecretReference(SecretLocalReference secretReference) {
        this._visitables.get("secretReference").remove(this.secretReference);
        if (secretReference != null) {
            this.secretReference = new SecretLocalReferenceBuilder(secretReference);
            this._visitables.get("secretReference").add(this.secretReference);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretReference() {
        return this.secretReference != null;
    }

    @Override
    public A withNewSecretReference(String name) {
        return this.withSecretReference(new SecretLocalReference(name));
    }

    @Override
    public WebHookTriggerFluent.SecretReferenceNested<A> withNewSecretReference() {
        return new SecretReferenceNestedImpl();
    }

    @Override
    public WebHookTriggerFluent.SecretReferenceNested<A> withNewSecretReferenceLike(SecretLocalReference item) {
        return new SecretReferenceNestedImpl(item);
    }

    @Override
    public WebHookTriggerFluent.SecretReferenceNested<A> editSecretReference() {
        return this.withNewSecretReferenceLike(this.getSecretReference());
    }

    @Override
    public WebHookTriggerFluent.SecretReferenceNested<A> editOrNewSecretReference() {
        return this.withNewSecretReferenceLike(this.getSecretReference() != null ? this.getSecretReference() : new SecretLocalReferenceBuilder().build());
    }

    @Override
    public WebHookTriggerFluent.SecretReferenceNested<A> editOrNewSecretReferenceLike(SecretLocalReference item) {
        return this.withNewSecretReferenceLike(this.getSecretReference() != null ? this.getSecretReference() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebHookTriggerFluentImpl that = (WebHookTriggerFluentImpl)o;
        if (this.allowEnv != null ? !this.allowEnv.equals(that.allowEnv) : that.allowEnv != null) {
            return false;
        }
        if (this.secret != null ? !this.secret.equals(that.secret) : that.secret != null) {
            return false;
        }
        if (this.secretReference != null ? !this.secretReference.equals(that.secretReference) : that.secretReference != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.allowEnv, this.secret, this.secretReference, this.additionalProperties, super.hashCode());
    }

    public class SecretReferenceNestedImpl<N>
    extends SecretLocalReferenceFluentImpl<WebHookTriggerFluent.SecretReferenceNested<N>>
    implements WebHookTriggerFluent.SecretReferenceNested<N>,
    Nested<N> {
        SecretLocalReferenceBuilder builder;

        SecretReferenceNestedImpl(SecretLocalReference item) {
            this.builder = new SecretLocalReferenceBuilder(this, item);
        }

        SecretReferenceNestedImpl() {
            this.builder = new SecretLocalReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)WebHookTriggerFluentImpl.this.withSecretReference(this.builder.build());
        }

        @Override
        public N endSecretReference() {
            return this.and();
        }
    }
}

