/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_11;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.openshift.api.model.v5_11.AWSPlatformStatus;
import io.fabric8.openshift.api.model.v5_11.AWSPlatformStatusFluent;
import io.fabric8.openshift.api.model.v5_11.AWSResourceTag;
import io.fabric8.openshift.api.model.v5_11.AWSResourceTagBuilder;
import io.fabric8.openshift.api.model.v5_11.AWSResourceTagFluentImpl;
import io.fabric8.openshift.api.model.v5_11.AWSServiceEndpoint;
import io.fabric8.openshift.api.model.v5_11.AWSServiceEndpointBuilder;
import io.fabric8.openshift.api.model.v5_11.AWSServiceEndpointFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AWSPlatformStatusFluentImpl<A extends AWSPlatformStatusFluent<A>>
extends BaseFluent<A>
implements AWSPlatformStatusFluent<A> {
    private String region;
    private List<AWSResourceTagBuilder> resourceTags = new ArrayList<AWSResourceTagBuilder>();
    private List<AWSServiceEndpointBuilder> serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();
    private Map<String, Object> additionalProperties;

    public AWSPlatformStatusFluentImpl() {
    }

    public AWSPlatformStatusFluentImpl(AWSPlatformStatus instance) {
        this.withRegion(instance.getRegion());
        this.withResourceTags(instance.getResourceTags());
        this.withServiceEndpoints(instance.getServiceEndpoints());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    @Override
    public Boolean hasRegion() {
        return this.region != null;
    }

    @Override
    @Deprecated
    public A withNewRegion(String arg0) {
        return this.withRegion(new String(arg0));
    }

    @Override
    public A addToResourceTags(Integer index, AWSResourceTag item) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList<AWSResourceTagBuilder>();
        }
        AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
        this._visitables.get("resourceTags").add(index >= 0 ? index.intValue() : this._visitables.get("resourceTags").size(), builder);
        this.resourceTags.add(index >= 0 ? index.intValue() : this.resourceTags.size(), builder);
        return (A)this;
    }

    @Override
    public A setToResourceTags(Integer index, AWSResourceTag item) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList<AWSResourceTagBuilder>();
        }
        AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
        if (index < 0 || index >= this._visitables.get("resourceTags").size()) {
            this._visitables.get("resourceTags").add(builder);
        } else {
            this._visitables.get("resourceTags").set(index, builder);
        }
        if (index < 0 || index >= this.resourceTags.size()) {
            this.resourceTags.add(builder);
        } else {
            this.resourceTags.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResourceTags(AWSResourceTag ... items) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList<AWSResourceTagBuilder>();
        }
        for (AWSResourceTag item : items) {
            AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
            this._visitables.get("resourceTags").add(builder);
            this.resourceTags.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResourceTags(Collection<AWSResourceTag> items) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList<AWSResourceTagBuilder>();
        }
        for (AWSResourceTag item : items) {
            AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
            this._visitables.get("resourceTags").add(builder);
            this.resourceTags.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResourceTags(AWSResourceTag ... items) {
        for (AWSResourceTag item : items) {
            AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
            this._visitables.get("resourceTags").remove(builder);
            if (this.resourceTags == null) continue;
            this.resourceTags.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResourceTags(Collection<AWSResourceTag> items) {
        for (AWSResourceTag item : items) {
            AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
            this._visitables.get("resourceTags").remove(builder);
            if (this.resourceTags == null) continue;
            this.resourceTags.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromResourceTags(Predicate<AWSResourceTagBuilder> predicate) {
        if (this.resourceTags == null) {
            return (A)this;
        }
        Iterator<AWSResourceTagBuilder> each = this.resourceTags.iterator();
        Object visitables = this._visitables.get("resourceTags");
        while (each.hasNext()) {
            AWSResourceTagBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<AWSResourceTag> getResourceTags() {
        return AWSPlatformStatusFluentImpl.build(this.resourceTags);
    }

    @Override
    public List<AWSResourceTag> buildResourceTags() {
        return AWSPlatformStatusFluentImpl.build(this.resourceTags);
    }

    @Override
    public AWSResourceTag buildResourceTag(Integer index) {
        return this.resourceTags.get(index).build();
    }

    @Override
    public AWSResourceTag buildFirstResourceTag() {
        return this.resourceTags.get(0).build();
    }

    @Override
    public AWSResourceTag buildLastResourceTag() {
        return this.resourceTags.get(this.resourceTags.size() - 1).build();
    }

    @Override
    public AWSResourceTag buildMatchingResourceTag(Predicate<AWSResourceTagBuilder> predicate) {
        for (AWSResourceTagBuilder item : this.resourceTags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResourceTag(Predicate<AWSResourceTagBuilder> predicate) {
        for (AWSResourceTagBuilder item : this.resourceTags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResourceTags(List<AWSResourceTag> resourceTags) {
        if (this.resourceTags != null) {
            this._visitables.get("resourceTags").removeAll(this.resourceTags);
        }
        if (resourceTags != null) {
            this.resourceTags = new ArrayList<AWSResourceTagBuilder>();
            for (AWSResourceTag item : resourceTags) {
                this.addToResourceTags(item);
            }
        } else {
            this.resourceTags = null;
        }
        return (A)this;
    }

    @Override
    public A withResourceTags(AWSResourceTag ... resourceTags) {
        if (this.resourceTags != null) {
            this.resourceTags.clear();
        }
        if (resourceTags != null) {
            for (AWSResourceTag item : resourceTags) {
                this.addToResourceTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResourceTags() {
        return this.resourceTags != null && !this.resourceTags.isEmpty();
    }

    @Override
    public A addNewResourceTag(String key, String value) {
        return this.addToResourceTags(new AWSResourceTag(key, value));
    }

    @Override
    public AWSPlatformStatusFluent.ResourceTagsNested<A> addNewResourceTag() {
        return new ResourceTagsNestedImpl();
    }

    @Override
    public AWSPlatformStatusFluent.ResourceTagsNested<A> addNewResourceTagLike(AWSResourceTag item) {
        return new ResourceTagsNestedImpl(-1, item);
    }

    @Override
    public AWSPlatformStatusFluent.ResourceTagsNested<A> setNewResourceTagLike(Integer index, AWSResourceTag item) {
        return new ResourceTagsNestedImpl(index, item);
    }

    @Override
    public AWSPlatformStatusFluent.ResourceTagsNested<A> editResourceTag(Integer index) {
        if (this.resourceTags.size() <= index) {
            throw new RuntimeException("Can't edit resourceTags. Index exceeds size.");
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    @Override
    public AWSPlatformStatusFluent.ResourceTagsNested<A> editFirstResourceTag() {
        if (this.resourceTags.size() == 0) {
            throw new RuntimeException("Can't edit first resourceTags. The list is empty.");
        }
        return this.setNewResourceTagLike(0, this.buildResourceTag(0));
    }

    @Override
    public AWSPlatformStatusFluent.ResourceTagsNested<A> editLastResourceTag() {
        int index = this.resourceTags.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceTags. The list is empty.");
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    @Override
    public AWSPlatformStatusFluent.ResourceTagsNested<A> editMatchingResourceTag(Predicate<AWSResourceTagBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceTags.size(); ++i) {
            if (!predicate.test(this.resourceTags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceTags. No match found.");
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    @Override
    public A addToServiceEndpoints(Integer index, AWSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();
        }
        AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
        this._visitables.get("serviceEndpoints").add(index >= 0 ? index.intValue() : this._visitables.get("serviceEndpoints").size(), builder);
        this.serviceEndpoints.add(index >= 0 ? index.intValue() : this.serviceEndpoints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToServiceEndpoints(Integer index, AWSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();
        }
        AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
        if (index < 0 || index >= this._visitables.get("serviceEndpoints").size()) {
            this._visitables.get("serviceEndpoints").add(builder);
        } else {
            this._visitables.get("serviceEndpoints").set(index, builder);
        }
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this.serviceEndpoints.add(builder);
        } else {
            this.serviceEndpoints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToServiceEndpoints(AWSServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();
        }
        for (AWSServiceEndpoint item : items) {
            AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToServiceEndpoints(Collection<AWSServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();
        }
        for (AWSServiceEndpoint item : items) {
            AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromServiceEndpoints(AWSServiceEndpoint ... items) {
        for (AWSServiceEndpoint item : items) {
            AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").remove(builder);
            if (this.serviceEndpoints == null) continue;
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServiceEndpoints(Collection<AWSServiceEndpoint> items) {
        for (AWSServiceEndpoint item : items) {
            AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").remove(builder);
            if (this.serviceEndpoints == null) continue;
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromServiceEndpoints(Predicate<AWSServiceEndpointBuilder> predicate) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        Iterator<AWSServiceEndpointBuilder> each = this.serviceEndpoints.iterator();
        Object visitables = this._visitables.get("serviceEndpoints");
        while (each.hasNext()) {
            AWSServiceEndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<AWSServiceEndpoint> getServiceEndpoints() {
        return AWSPlatformStatusFluentImpl.build(this.serviceEndpoints);
    }

    @Override
    public List<AWSServiceEndpoint> buildServiceEndpoints() {
        return AWSPlatformStatusFluentImpl.build(this.serviceEndpoints);
    }

    @Override
    public AWSServiceEndpoint buildServiceEndpoint(Integer index) {
        return this.serviceEndpoints.get(index).build();
    }

    @Override
    public AWSServiceEndpoint buildFirstServiceEndpoint() {
        return this.serviceEndpoints.get(0).build();
    }

    @Override
    public AWSServiceEndpoint buildLastServiceEndpoint() {
        return this.serviceEndpoints.get(this.serviceEndpoints.size() - 1).build();
    }

    @Override
    public AWSServiceEndpoint buildMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
        for (AWSServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
        for (AWSServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServiceEndpoints(List<AWSServiceEndpoint> serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this._visitables.get("serviceEndpoints").removeAll(this.serviceEndpoints);
        }
        if (serviceEndpoints != null) {
            this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();
            for (AWSServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        } else {
            this.serviceEndpoints = null;
        }
        return (A)this;
    }

    @Override
    public A withServiceEndpoints(AWSServiceEndpoint ... serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this.serviceEndpoints.clear();
        }
        if (serviceEndpoints != null) {
            for (AWSServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServiceEndpoints() {
        return this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty();
    }

    @Override
    public A addNewServiceEndpoint(String name, String url) {
        return this.addToServiceEndpoints(new AWSServiceEndpoint(name, url));
    }

    @Override
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> addNewServiceEndpoint() {
        return new ServiceEndpointsNestedImpl();
    }

    @Override
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> addNewServiceEndpointLike(AWSServiceEndpoint item) {
        return new ServiceEndpointsNestedImpl(-1, item);
    }

    @Override
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> setNewServiceEndpointLike(Integer index, AWSServiceEndpoint item) {
        return new ServiceEndpointsNestedImpl(index, item);
    }

    @Override
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> editServiceEndpoint(Integer index) {
        if (this.serviceEndpoints.size() <= index) {
            throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    @Override
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> editFirstServiceEndpoint() {
        if (this.serviceEndpoints.size() == 0) {
            throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(0, this.buildServiceEndpoint(0));
    }

    @Override
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> editLastServiceEndpoint() {
        int index = this.serviceEndpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    @Override
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serviceEndpoints.size(); ++i) {
            if (!predicate.test(this.serviceEndpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSPlatformStatusFluentImpl that = (AWSPlatformStatusFluentImpl)o;
        if (this.region != null ? !this.region.equals(that.region) : that.region != null) {
            return false;
        }
        if (this.resourceTags != null ? !this.resourceTags.equals(that.resourceTags) : that.resourceTags != null) {
            return false;
        }
        if (this.serviceEndpoints != null ? !this.serviceEndpoints.equals(that.serviceEndpoints) : that.serviceEndpoints != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.region, this.resourceTags, this.serviceEndpoints, this.additionalProperties, super.hashCode());
    }

    public class ServiceEndpointsNestedImpl<N>
    extends AWSServiceEndpointFluentImpl<AWSPlatformStatusFluent.ServiceEndpointsNested<N>>
    implements AWSPlatformStatusFluent.ServiceEndpointsNested<N>,
    Nested<N> {
        AWSServiceEndpointBuilder builder;
        Integer index;

        ServiceEndpointsNestedImpl(Integer index, AWSServiceEndpoint item) {
            this.index = index;
            this.builder = new AWSServiceEndpointBuilder(this, item);
        }

        ServiceEndpointsNestedImpl() {
            this.index = -1;
            this.builder = new AWSServiceEndpointBuilder(this);
        }

        @Override
        public N and() {
            return (N)AWSPlatformStatusFluentImpl.this.setToServiceEndpoints(this.index, this.builder.build());
        }

        @Override
        public N endServiceEndpoint() {
            return this.and();
        }
    }

    public class ResourceTagsNestedImpl<N>
    extends AWSResourceTagFluentImpl<AWSPlatformStatusFluent.ResourceTagsNested<N>>
    implements AWSPlatformStatusFluent.ResourceTagsNested<N>,
    Nested<N> {
        AWSResourceTagBuilder builder;
        Integer index;

        ResourceTagsNestedImpl(Integer index, AWSResourceTag item) {
            this.index = index;
            this.builder = new AWSResourceTagBuilder(this, item);
        }

        ResourceTagsNestedImpl() {
            this.index = -1;
            this.builder = new AWSResourceTagBuilder(this);
        }

        @Override
        public N and() {
            return (N)AWSPlatformStatusFluentImpl.this.setToResourceTags(this.index, this.builder.build());
        }

        @Override
        public N endResourceTag() {
            return this.and();
        }
    }
}

