/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_11.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.builder.v5_11.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_11.EnvVar;
import io.fabric8.kubernetes.api.model.v5_11.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.v5_11.Event;
import io.fabric8.kubernetes.api.model.v5_11.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_11.KubernetesList;
import io.fabric8.kubernetes.api.model.v5_11.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_11.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_11.OwnerReference;
import io.fabric8.kubernetes.api.model.v5_11.Secret;
import io.fabric8.kubernetes.api.model.v5_11.SecretBuilder;
import io.fabric8.kubernetes.api.model.v5_11.SecretFluent;
import io.fabric8.kubernetes.clnt.v5_11.CustomResourceList;
import io.fabric8.kubernetes.clnt.v5_11.internal.readiness.Readiness;
import io.fabric8.kubernetes.clnt.v5_11.utils.Serialization;
import io.fabric8.kubernetes.clnt.v5_11.utils.Utils;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class KubernetesResourceUtil {
    public static final Pattern KUBERNETES_DNS1123_LABEL_REGEX = Pattern.compile("[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])?");
    private static final Pattern INVALID_LABEL_CHARS_PATTERN = Pattern.compile("[^-A-Za-z0-9]+");

    private KubernetesResourceUtil() {
    }

    public static String getResourceVersion(HasMetadata entity) {
        String resourceVersion;
        ObjectMeta metadata;
        if (entity != null && (metadata = entity.getMetadata()) != null && !Utils.isNullOrEmpty(resourceVersion = metadata.getResourceVersion())) {
            return resourceVersion;
        }
        return null;
    }

    public static void setResourceVersion(HasMetadata entity, String resourceVersion) {
        ObjectMeta metadata;
        if (entity != null && (metadata = entity.getMetadata()) != null) {
            metadata.setResourceVersion(resourceVersion);
        }
    }

    public static String getKind(HasMetadata entity) {
        if (entity != null) {
            if (entity instanceof KubernetesList) {
                return "List";
            }
            return entity.getClass().getSimpleName();
        }
        return null;
    }

    public static String getQualifiedName(HasMetadata entity) {
        if (entity != null) {
            return "" + KubernetesResourceUtil.getNamespace(entity) + "/" + KubernetesResourceUtil.getName(entity);
        }
        return null;
    }

    public static String getName(HasMetadata entity) {
        if (entity != null) {
            return KubernetesResourceUtil.getName(entity.getMetadata());
        }
        return null;
    }

    public static boolean hasResourceVersion(HasMetadata entity) {
        return KubernetesResourceUtil.getResourceVersion(entity) != null;
    }

    public static String getName(ObjectMeta entity) {
        if (entity != null) {
            return Utils.coalesce(entity.getName(), KubernetesResourceUtil.getAdditionalPropertyText(entity.getAdditionalProperties(), "id"), entity.getUid());
        }
        return null;
    }

    protected static String getAdditionalPropertyText(Map<String, Object> additionalProperties, String name) {
        Object value;
        if (additionalProperties != null && (value = additionalProperties.get(name)) != null) {
            return value.toString();
        }
        return null;
    }

    public static String getNamespace(ObjectMeta entity) {
        if (entity != null) {
            return entity.getNamespace();
        }
        return null;
    }

    public static String getNamespace(HasMetadata entity) {
        if (entity != null) {
            return KubernetesResourceUtil.getNamespace(entity.getMetadata());
        }
        return null;
    }

    public static Map<String, String> getOrCreateAnnotations(HasMetadata entity) {
        ObjectMeta metadata = KubernetesResourceUtil.getOrCreateMetadata(entity);
        Map<String, String> answer = metadata.getAnnotations();
        if (answer == null) {
            answer = new LinkedHashMap<String, String>();
            metadata.setAnnotations(answer);
        }
        return answer;
    }

    public static String sanitizeName(String name) {
        if (name != null) {
            int lastChar;
            if (!Character.isLetterOrDigit((name = INVALID_LABEL_CHARS_PATTERN.matcher(name).replaceAll("-")).charAt(0))) {
                name = "a" + name;
            }
            if (name.length() > 63) {
                name = name.substring(0, 63);
            }
            if (!Character.isLetterOrDigit((name = name.toLowerCase()).charAt(lastChar = name.length() - 1))) {
                name = name.substring(0, lastChar - 1) + "a";
            }
            return name;
        }
        return null;
    }

    public static Map<String, String> getOrCreateLabels(HasMetadata entity) {
        ObjectMeta metadata = KubernetesResourceUtil.getOrCreateMetadata(entity);
        Map<String, String> answer = metadata.getLabels();
        if (answer == null) {
            answer = new LinkedHashMap<String, String>();
            metadata.setLabels(answer);
        }
        return answer;
    }

    public static Map<String, String> getLabels(ObjectMeta metadata) {
        Map<String, String> labels;
        if (metadata != null && (labels = metadata.getLabels()) != null) {
            return labels;
        }
        return Collections.emptyMap();
    }

    public static ObjectMeta getOrCreateMetadata(HasMetadata entity) {
        ObjectMeta metadata = entity.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMeta();
            entity.setMetadata(metadata);
        }
        return metadata;
    }

    public static boolean isValidName(String name) {
        return Utils.isNotNullOrEmpty(name) && KUBERNETES_DNS1123_LABEL_REGEX.matcher(name).matches();
    }

    public static boolean isValidLabelOrAnnotation(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (KubernetesResourceUtil.isValidName(entry.getKey()) && KubernetesResourceUtil.isValidName(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean hasController(HasMetadata resource) {
        return KubernetesResourceUtil.getControllerUid(resource) != null;
    }

    public static OwnerReference getControllerUid(HasMetadata resource) {
        if (resource.getMetadata() != null) {
            List<OwnerReference> ownerReferenceList = resource.getMetadata().getOwnerReferences();
            for (OwnerReference ownerReference : ownerReferenceList) {
                if (!Boolean.TRUE.equals(ownerReference.getController())) continue;
                return ownerReference;
            }
        }
        return null;
    }

    public static void sortEventListBasedOnTimestamp(List<Event> eventList) {
        if (eventList != null) {
            eventList.sort(Comparator.comparing(Event::getLastTimestamp, Comparator.nullsFirst(Comparator.comparing(Instant::parse).reversed())));
        }
    }

    public static List<EnvVar> convertMapToEnvVarList(Map<String, String> envVarMap) {
        ArrayList<EnvVar> envVars = new ArrayList<EnvVar>();
        for (Map.Entry<String, String> entry : envVarMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            envVars.add(((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName(entry.getKey())).withValue(entry.getValue())).build());
        }
        return envVars;
    }

    public static boolean isResourceReady(HasMetadata item) {
        return Readiness.getInstance().isReady(item);
    }

    public static Duration getAge(HasMetadata kubernetesResource) {
        Instant instant = Instant.parse(kubernetesResource.getMetadata().getCreationTimestamp());
        return Duration.between(instant, Instant.now()).abs();
    }

    public static <T extends HasMetadata> Class<? extends KubernetesResourceList> inferListType(Class<T> type) {
        return KubernetesResourceUtil.loadRelated(type, "List", CustomResourceList.class);
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> Class<V> inferBuilderType(Class<T> type) {
        return KubernetesResourceUtil.loadRelated(type, "Builder", null);
    }

    private static Class<?> loadRelated(Class<?> type, String suffix, Class<?> defaultClass) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(type.getName() + suffix);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            try {
                return type.getClassLoader().loadClass(type.getName() + suffix);
            }
            catch (ClassCastException | ClassNotFoundException ex) {
                return defaultClass;
            }
        }
    }

    public static Secret createDockerRegistrySecret(String dockerServer, String username, String password) throws JsonProcessingException {
        HashMap dockerConfigMap = new HashMap();
        HashMap auths = new HashMap();
        HashMap<String, String> credentials = new HashMap<String, String>();
        credentials.put("username", username);
        credentials.put("password", password);
        String usernameAndPasswordAuth = username + ":" + password;
        credentials.put("auth", Base64.getEncoder().encodeToString(usernameAndPasswordAuth.getBytes(StandardCharsets.UTF_8)));
        auths.put(dockerServer, credentials);
        dockerConfigMap.put("auths", auths);
        String dockerConfigAsStr = Serialization.jsonMapper().writeValueAsString(dockerConfigMap);
        return ((SecretBuilder)((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withName("harbor-secret")).endMetadata()).withType("kubernetes.io/dockerconfigjson")).addToData(".dockerconfigjson", Base64.getEncoder().encodeToString(dockerConfigAsStr.getBytes(StandardCharsets.UTF_8)))).build();
    }
}

