/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_11.informers.cache;

import io.fabric8.kubernetes.api.model.v5_11.HasMetadata;
import io.fabric8.kubernetes.clnt.v5_11.informers.cache.Cache;
import io.fabric8.kubernetes.clnt.v5_11.informers.cache.ProcessorListener;
import io.fabric8.kubernetes.clnt.v5_11.informers.cache.SharedProcessor;
import io.fabric8.kubernetes.clnt.v5_11.informers.cache.SyncableStore;
import io.fabric8.kubernetes.clnt.v5_11.utils.KubernetesResourceUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProcessorStore<T extends HasMetadata>
implements SyncableStore<T> {
    private Cache<T> cache;
    private SharedProcessor<T> processor;

    public ProcessorStore(Cache<T> cache, SharedProcessor<T> processor) {
        this.cache = cache;
        this.processor = processor;
    }

    @Override
    public void add(T obj) {
        this.update(obj);
    }

    @Override
    public void update(T obj) {
        HasMetadata oldObj = (HasMetadata)this.cache.put(obj);
        if (oldObj != null) {
            this.processor.distribute(new ProcessorListener.UpdateNotification<HasMetadata>(oldObj, (HasMetadata)obj), false);
        } else {
            this.processor.distribute(new ProcessorListener.AddNotification<T>(obj), false);
        }
    }

    @Override
    public void delete(T obj) {
        T oldObj = this.cache.remove(obj);
        if (oldObj != null) {
            this.processor.distribute(new ProcessorListener.DeleteNotification<T>(obj, false), false);
        }
    }

    @Override
    public List<T> list() {
        return this.cache.list();
    }

    @Override
    public List<String> listKeys() {
        return this.cache.listKeys();
    }

    @Override
    public T get(T object) {
        return (T)((HasMetadata)this.cache.get(object));
    }

    @Override
    public T getByKey(String key) {
        return (T)((HasMetadata)this.cache.getByKey(key));
    }

    @Override
    public void replace(List<T> list) {
        Map<String, T> oldState = this.cache.replace(list);
        if (list.isEmpty() && oldState.isEmpty()) {
            this.processor.distribute(l -> l.getHandler().onNothing(), false);
        }
        for (HasMetadata newValue : list) {
            HasMetadata old2 = (HasMetadata)oldState.remove(this.cache.getKey(newValue));
            if (old2 == null) {
                this.processor.distribute(new ProcessorListener.AddNotification<HasMetadata>(newValue), false);
                continue;
            }
            boolean same = Objects.equals(KubernetesResourceUtil.getResourceVersion(old2), KubernetesResourceUtil.getResourceVersion(newValue));
            this.processor.distribute(new ProcessorListener.UpdateNotification<HasMetadata>(old2, newValue), same);
        }
        oldState.values().forEach(old -> this.processor.distribute(new ProcessorListener.DeleteNotification<HasMetadata>((HasMetadata)old, true), false));
    }

    @Override
    public void resync() {
        this.cache.list().forEach(i -> this.processor.distribute(new ProcessorListener.UpdateNotification<HasMetadata>((HasMetadata)i, (HasMetadata)i), true));
    }
}

