/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_11.dsl.internal;

import io.fabric8.kubernetes.api.model.v5_11.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_11.KubernetesList;
import io.fabric8.kubernetes.api.model.v5_11.KubernetesListBuilder;
import io.fabric8.kubernetes.clnt.v5_11.ClientContext;
import io.fabric8.kubernetes.clnt.v5_11.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_11.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Createable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.KubernetesListNonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.KubernetesListOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Loadable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.RecreateFromServerGettable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_11.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_11.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_11.dsl.internal.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl;
import io.fabric8.kubernetes.clnt.v5_11.utils.Serialization;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class KubernetesListOperationsImpl
implements KubernetesListOperation,
KubernetesListMixedOperation,
Loadable<RecreateFromServerGettable<KubernetesList>>,
RecreateFromServerGettable<KubernetesList> {
    private final boolean deletingExisting;
    private final OperationContext context;

    public KubernetesListOperationsImpl(ClientContext clientContext) {
        this.context = HasMetadataOperationsImpl.defaultContext(clientContext);
        this.deletingExisting = false;
    }

    public KubernetesListOperationsImpl(OperationContext context, boolean deletingExisting) {
        this.context = context;
        this.deletingExisting = deletingExisting;
    }

    @Override
    public KubernetesListNonNamespaceOperation inNamespace(String namespace) {
        return new KubernetesListOperationsImpl(this.context.withNamespace(namespace), this.deletingExisting);
    }

    @Override
    public KubernetesList create(KubernetesList ... items) {
        ArrayList<HasMetadata> createdItems = new ArrayList<HasMetadata>();
        if (items.length == 0) {
            items = new KubernetesList[]{this.get()};
        }
        for (KubernetesList i : items) {
            createdItems.addAll(this.createItemsInKubernetesList(i));
        }
        KubernetesList createdList = new KubernetesList();
        createdList.setItems(createdItems);
        return createdList;
    }

    @Override
    public KubernetesList create(KubernetesList list) {
        return this.create(new KubernetesList[]{list});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RecreateFromServerGettable<KubernetesList> load(URL url) {
        try (InputStream inputStream = url.openStream();){
            Object object = this.load(inputStream);
            return object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RecreateFromServerGettable<KubernetesList> load(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            Object object = this.load(fis);
            return object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public RecreateFromServerGettable<KubernetesList> load(String path) {
        return this.load(new File(path));
    }

    @Override
    public RecreateFromServerGettable<KubernetesList> load(InputStream is) {
        return new KubernetesListOperationsImpl(this.context.withItem(Serialization.unmarshal(is, KubernetesList.class)), this.deletingExisting);
    }

    @Override
    public KubernetesList get() {
        KubernetesList list = (KubernetesList)this.context.getItem();
        if (list == null) {
            return null;
        }
        return ((KubernetesListBuilder)new KubernetesListBuilder(list).withItems(list.getItems().stream().map(meta -> (HasMetadata)this.getResource((HasMetadata)meta).get()).collect(Collectors.toList()))).build();
    }

    private Resource<HasMetadata> getResource(HasMetadata resource) {
        ResourceHandler handler = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(resource, this.context);
        return handler.operation(this.context, null).newInstance(this.context.withItem(resource));
    }

    public Boolean delete(KubernetesList ... lists) {
        return this.delete(Arrays.asList(lists));
    }

    @Override
    public Boolean delete(List<KubernetesList> lists) {
        for (KubernetesList list : lists) {
            for (HasMetadata item : list.getItems()) {
                if (this.getResource(item).delete().booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Gettable<KubernetesList> fromServer() {
        return new KubernetesListOperationsImpl(this.context.withReloadingFromServer(true), this.deletingExisting);
    }

    @Override
    public Createable<KubernetesList> deletingExisting() {
        return new KubernetesListOperationsImpl(this.context, true);
    }

    private List<HasMetadata> createItemsInKubernetesList(KubernetesList list) {
        ArrayList<HasMetadata> createdItems = new ArrayList<HasMetadata>();
        for (HasMetadata r : list.getItems()) {
            HasMetadata created = (HasMetadata)this.getResource(r).create(r);
            createdItems.add(created);
        }
        return createdItems;
    }
}

