/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_11.authorization.v1beta1;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.kubernetes.api.model.v5_11.authorization.v1beta1.NonResourceRule;
import io.fabric8.kubernetes.api.model.v5_11.authorization.v1beta1.NonResourceRuleBuilder;
import io.fabric8.kubernetes.api.model.v5_11.authorization.v1beta1.NonResourceRuleFluentImpl;
import io.fabric8.kubernetes.api.model.v5_11.authorization.v1beta1.ResourceRule;
import io.fabric8.kubernetes.api.model.v5_11.authorization.v1beta1.ResourceRuleBuilder;
import io.fabric8.kubernetes.api.model.v5_11.authorization.v1beta1.ResourceRuleFluentImpl;
import io.fabric8.kubernetes.api.model.v5_11.authorization.v1beta1.SubjectRulesReviewStatus;
import io.fabric8.kubernetes.api.model.v5_11.authorization.v1beta1.SubjectRulesReviewStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SubjectRulesReviewStatusFluentImpl<A extends SubjectRulesReviewStatusFluent<A>>
extends BaseFluent<A>
implements SubjectRulesReviewStatusFluent<A> {
    private String evaluationError;
    private Boolean incomplete;
    private List<NonResourceRuleBuilder> nonResourceRules = new ArrayList<NonResourceRuleBuilder>();
    private List<ResourceRuleBuilder> resourceRules = new ArrayList<ResourceRuleBuilder>();
    private Map<String, Object> additionalProperties;

    public SubjectRulesReviewStatusFluentImpl() {
    }

    public SubjectRulesReviewStatusFluentImpl(SubjectRulesReviewStatus instance) {
        this.withEvaluationError(instance.getEvaluationError());
        this.withIncomplete(instance.getIncomplete());
        this.withNonResourceRules(instance.getNonResourceRules());
        this.withResourceRules(instance.getResourceRules());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getEvaluationError() {
        return this.evaluationError;
    }

    @Override
    public A withEvaluationError(String evaluationError) {
        this.evaluationError = evaluationError;
        return (A)this;
    }

    @Override
    public Boolean hasEvaluationError() {
        return this.evaluationError != null;
    }

    @Override
    @Deprecated
    public A withNewEvaluationError(String arg0) {
        return this.withEvaluationError(new String(arg0));
    }

    @Override
    public Boolean getIncomplete() {
        return this.incomplete;
    }

    @Override
    public A withIncomplete(Boolean incomplete) {
        this.incomplete = incomplete;
        return (A)this;
    }

    @Override
    public Boolean hasIncomplete() {
        return this.incomplete != null;
    }

    @Override
    public A addToNonResourceRules(Integer index, NonResourceRule item) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList<NonResourceRuleBuilder>();
        }
        NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);
        this._visitables.get("nonResourceRules").add(index >= 0 ? index.intValue() : this._visitables.get("nonResourceRules").size(), builder);
        this.nonResourceRules.add(index >= 0 ? index.intValue() : this.nonResourceRules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToNonResourceRules(Integer index, NonResourceRule item) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList<NonResourceRuleBuilder>();
        }
        NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get("nonResourceRules").size()) {
            this._visitables.get("nonResourceRules").add(builder);
        } else {
            this._visitables.get("nonResourceRules").set(index, builder);
        }
        if (index < 0 || index >= this.nonResourceRules.size()) {
            this.nonResourceRules.add(builder);
        } else {
            this.nonResourceRules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToNonResourceRules(NonResourceRule ... items) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList<NonResourceRuleBuilder>();
        }
        for (NonResourceRule item : items) {
            NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToNonResourceRules(Collection<NonResourceRule> items) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList<NonResourceRuleBuilder>();
        }
        for (NonResourceRule item : items) {
            NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromNonResourceRules(NonResourceRule ... items) {
        for (NonResourceRule item : items) {
            NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);
            this._visitables.get("nonResourceRules").remove(builder);
            if (this.nonResourceRules == null) continue;
            this.nonResourceRules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNonResourceRules(Collection<NonResourceRule> items) {
        for (NonResourceRule item : items) {
            NonResourceRuleBuilder builder = new NonResourceRuleBuilder(item);
            this._visitables.get("nonResourceRules").remove(builder);
            if (this.nonResourceRules == null) continue;
            this.nonResourceRules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromNonResourceRules(Predicate<NonResourceRuleBuilder> predicate) {
        if (this.nonResourceRules == null) {
            return (A)this;
        }
        Iterator<NonResourceRuleBuilder> each = this.nonResourceRules.iterator();
        Object visitables = this._visitables.get("nonResourceRules");
        while (each.hasNext()) {
            NonResourceRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NonResourceRule> getNonResourceRules() {
        return SubjectRulesReviewStatusFluentImpl.build(this.nonResourceRules);
    }

    @Override
    public List<NonResourceRule> buildNonResourceRules() {
        return SubjectRulesReviewStatusFluentImpl.build(this.nonResourceRules);
    }

    @Override
    public NonResourceRule buildNonResourceRule(Integer index) {
        return this.nonResourceRules.get(index).build();
    }

    @Override
    public NonResourceRule buildFirstNonResourceRule() {
        return this.nonResourceRules.get(0).build();
    }

    @Override
    public NonResourceRule buildLastNonResourceRule() {
        return this.nonResourceRules.get(this.nonResourceRules.size() - 1).build();
    }

    @Override
    public NonResourceRule buildMatchingNonResourceRule(Predicate<NonResourceRuleBuilder> predicate) {
        for (NonResourceRuleBuilder item : this.nonResourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNonResourceRule(Predicate<NonResourceRuleBuilder> predicate) {
        for (NonResourceRuleBuilder item : this.nonResourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNonResourceRules(List<NonResourceRule> nonResourceRules) {
        if (this.nonResourceRules != null) {
            this._visitables.get("nonResourceRules").removeAll(this.nonResourceRules);
        }
        if (nonResourceRules != null) {
            this.nonResourceRules = new ArrayList<NonResourceRuleBuilder>();
            for (NonResourceRule item : nonResourceRules) {
                this.addToNonResourceRules(item);
            }
        } else {
            this.nonResourceRules = null;
        }
        return (A)this;
    }

    @Override
    public A withNonResourceRules(NonResourceRule ... nonResourceRules) {
        if (this.nonResourceRules != null) {
            this.nonResourceRules.clear();
        }
        if (nonResourceRules != null) {
            for (NonResourceRule item : nonResourceRules) {
                this.addToNonResourceRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNonResourceRules() {
        return this.nonResourceRules != null && !this.nonResourceRules.isEmpty();
    }

    @Override
    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> addNewNonResourceRule() {
        return new NonResourceRulesNestedImpl();
    }

    @Override
    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> addNewNonResourceRuleLike(NonResourceRule item) {
        return new NonResourceRulesNestedImpl(-1, item);
    }

    @Override
    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> setNewNonResourceRuleLike(Integer index, NonResourceRule item) {
        return new NonResourceRulesNestedImpl(index, item);
    }

    @Override
    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editNonResourceRule(Integer index) {
        if (this.nonResourceRules.size() <= index) {
            throw new RuntimeException("Can't edit nonResourceRules. Index exceeds size.");
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    @Override
    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editFirstNonResourceRule() {
        if (this.nonResourceRules.size() == 0) {
            throw new RuntimeException("Can't edit first nonResourceRules. The list is empty.");
        }
        return this.setNewNonResourceRuleLike(0, this.buildNonResourceRule(0));
    }

    @Override
    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editLastNonResourceRule() {
        int index = this.nonResourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last nonResourceRules. The list is empty.");
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    @Override
    public SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editMatchingNonResourceRule(Predicate<NonResourceRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.nonResourceRules.size(); ++i) {
            if (!predicate.test(this.nonResourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching nonResourceRules. No match found.");
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    @Override
    public A addToResourceRules(Integer index, ResourceRule item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList<ResourceRuleBuilder>();
        }
        ResourceRuleBuilder builder = new ResourceRuleBuilder(item);
        this._visitables.get("resourceRules").add(index >= 0 ? index.intValue() : this._visitables.get("resourceRules").size(), builder);
        this.resourceRules.add(index >= 0 ? index.intValue() : this.resourceRules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToResourceRules(Integer index, ResourceRule item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList<ResourceRuleBuilder>();
        }
        ResourceRuleBuilder builder = new ResourceRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get("resourceRules").size()) {
            this._visitables.get("resourceRules").add(builder);
        } else {
            this._visitables.get("resourceRules").set(index, builder);
        }
        if (index < 0 || index >= this.resourceRules.size()) {
            this.resourceRules.add(builder);
        } else {
            this.resourceRules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResourceRules(ResourceRule ... items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList<ResourceRuleBuilder>();
        }
        for (ResourceRule item : items) {
            ResourceRuleBuilder builder = new ResourceRuleBuilder(item);
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResourceRules(Collection<ResourceRule> items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList<ResourceRuleBuilder>();
        }
        for (ResourceRule item : items) {
            ResourceRuleBuilder builder = new ResourceRuleBuilder(item);
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResourceRules(ResourceRule ... items) {
        for (ResourceRule item : items) {
            ResourceRuleBuilder builder = new ResourceRuleBuilder(item);
            this._visitables.get("resourceRules").remove(builder);
            if (this.resourceRules == null) continue;
            this.resourceRules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResourceRules(Collection<ResourceRule> items) {
        for (ResourceRule item : items) {
            ResourceRuleBuilder builder = new ResourceRuleBuilder(item);
            this._visitables.get("resourceRules").remove(builder);
            if (this.resourceRules == null) continue;
            this.resourceRules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromResourceRules(Predicate<ResourceRuleBuilder> predicate) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        Iterator<ResourceRuleBuilder> each = this.resourceRules.iterator();
        Object visitables = this._visitables.get("resourceRules");
        while (each.hasNext()) {
            ResourceRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ResourceRule> getResourceRules() {
        return SubjectRulesReviewStatusFluentImpl.build(this.resourceRules);
    }

    @Override
    public List<ResourceRule> buildResourceRules() {
        return SubjectRulesReviewStatusFluentImpl.build(this.resourceRules);
    }

    @Override
    public ResourceRule buildResourceRule(Integer index) {
        return this.resourceRules.get(index).build();
    }

    @Override
    public ResourceRule buildFirstResourceRule() {
        return this.resourceRules.get(0).build();
    }

    @Override
    public ResourceRule buildLastResourceRule() {
        return this.resourceRules.get(this.resourceRules.size() - 1).build();
    }

    @Override
    public ResourceRule buildMatchingResourceRule(Predicate<ResourceRuleBuilder> predicate) {
        for (ResourceRuleBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResourceRule(Predicate<ResourceRuleBuilder> predicate) {
        for (ResourceRuleBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResourceRules(List<ResourceRule> resourceRules) {
        if (this.resourceRules != null) {
            this._visitables.get("resourceRules").removeAll(this.resourceRules);
        }
        if (resourceRules != null) {
            this.resourceRules = new ArrayList<ResourceRuleBuilder>();
            for (ResourceRule item : resourceRules) {
                this.addToResourceRules(item);
            }
        } else {
            this.resourceRules = null;
        }
        return (A)this;
    }

    @Override
    public A withResourceRules(ResourceRule ... resourceRules) {
        if (this.resourceRules != null) {
            this.resourceRules.clear();
        }
        if (resourceRules != null) {
            for (ResourceRule item : resourceRules) {
                this.addToResourceRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResourceRules() {
        return this.resourceRules != null && !this.resourceRules.isEmpty();
    }

    @Override
    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> addNewResourceRule() {
        return new ResourceRulesNestedImpl();
    }

    @Override
    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> addNewResourceRuleLike(ResourceRule item) {
        return new ResourceRulesNestedImpl(-1, item);
    }

    @Override
    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> setNewResourceRuleLike(Integer index, ResourceRule item) {
        return new ResourceRulesNestedImpl(index, item);
    }

    @Override
    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editResourceRule(Integer index) {
        if (this.resourceRules.size() <= index) {
            throw new RuntimeException("Can't edit resourceRules. Index exceeds size.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    @Override
    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editFirstResourceRule() {
        if (this.resourceRules.size() == 0) {
            throw new RuntimeException("Can't edit first resourceRules. The list is empty.");
        }
        return this.setNewResourceRuleLike(0, this.buildResourceRule(0));
    }

    @Override
    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editLastResourceRule() {
        int index = this.resourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceRules. The list is empty.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    @Override
    public SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editMatchingResourceRule(Predicate<ResourceRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceRules.size(); ++i) {
            if (!predicate.test(this.resourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceRules. No match found.");
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubjectRulesReviewStatusFluentImpl that = (SubjectRulesReviewStatusFluentImpl)o;
        if (this.evaluationError != null ? !this.evaluationError.equals(that.evaluationError) : that.evaluationError != null) {
            return false;
        }
        if (this.incomplete != null ? !this.incomplete.equals(that.incomplete) : that.incomplete != null) {
            return false;
        }
        if (this.nonResourceRules != null ? !this.nonResourceRules.equals(that.nonResourceRules) : that.nonResourceRules != null) {
            return false;
        }
        if (this.resourceRules != null ? !this.resourceRules.equals(that.resourceRules) : that.resourceRules != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.evaluationError, this.incomplete, this.nonResourceRules, this.resourceRules, this.additionalProperties, super.hashCode());
    }

    public class ResourceRulesNestedImpl<N>
    extends ResourceRuleFluentImpl<SubjectRulesReviewStatusFluent.ResourceRulesNested<N>>
    implements SubjectRulesReviewStatusFluent.ResourceRulesNested<N>,
    Nested<N> {
        ResourceRuleBuilder builder;
        Integer index;

        ResourceRulesNestedImpl(Integer index, ResourceRule item) {
            this.index = index;
            this.builder = new ResourceRuleBuilder(this, item);
        }

        ResourceRulesNestedImpl() {
            this.index = -1;
            this.builder = new ResourceRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)SubjectRulesReviewStatusFluentImpl.this.setToResourceRules(this.index, this.builder.build());
        }

        @Override
        public N endResourceRule() {
            return this.and();
        }
    }

    public class NonResourceRulesNestedImpl<N>
    extends NonResourceRuleFluentImpl<SubjectRulesReviewStatusFluent.NonResourceRulesNested<N>>
    implements SubjectRulesReviewStatusFluent.NonResourceRulesNested<N>,
    Nested<N> {
        NonResourceRuleBuilder builder;
        Integer index;

        NonResourceRulesNestedImpl(Integer index, NonResourceRule item) {
            this.index = index;
            this.builder = new NonResourceRuleBuilder(this, item);
        }

        NonResourceRulesNestedImpl() {
            this.index = -1;
            this.builder = new NonResourceRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)SubjectRulesReviewStatusFluentImpl.this.setToNonResourceRules(this.index, this.builder.build());
        }

        @Override
        public N endNonResourceRule() {
            return this.and();
        }
    }
}

