/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_11.authentication;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.kubernetes.api.model.v5_11.authentication.TokenReviewStatus;
import io.fabric8.kubernetes.api.model.v5_11.authentication.TokenReviewStatusFluent;
import io.fabric8.kubernetes.api.model.v5_11.authentication.UserInfo;
import io.fabric8.kubernetes.api.model.v5_11.authentication.UserInfoBuilder;
import io.fabric8.kubernetes.api.model.v5_11.authentication.UserInfoFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TokenReviewStatusFluentImpl<A extends TokenReviewStatusFluent<A>>
extends BaseFluent<A>
implements TokenReviewStatusFluent<A> {
    private List<String> audiences = new ArrayList<String>();
    private Boolean authenticated;
    private String error;
    private UserInfoBuilder user;
    private Map<String, Object> additionalProperties;

    public TokenReviewStatusFluentImpl() {
    }

    public TokenReviewStatusFluentImpl(TokenReviewStatus instance) {
        this.withAudiences(instance.getAudiences());
        this.withAuthenticated(instance.getAuthenticated());
        this.withError(instance.getError());
        this.withUser(instance.getUser());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToAudiences(Integer index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAudiences(Integer index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAudiences(String ... items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAudiences(Collection<String> items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAudiences(String ... items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAudiences(Collection<String> items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAudiences() {
        return this.audiences;
    }

    @Override
    public String getAudience(Integer index) {
        return this.audiences.get(index);
    }

    @Override
    public String getFirstAudience() {
        return this.audiences.get(0);
    }

    @Override
    public String getLastAudience() {
        return this.audiences.get(this.audiences.size() - 1);
    }

    @Override
    public String getMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAudiences(List<String> audiences) {
        if (audiences != null) {
            this.audiences = new ArrayList<String>();
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        } else {
            this.audiences = null;
        }
        return (A)this;
    }

    @Override
    public A withAudiences(String ... audiences) {
        if (this.audiences != null) {
            this.audiences.clear();
        }
        if (audiences != null) {
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAudiences() {
        return this.audiences != null && !this.audiences.isEmpty();
    }

    @Override
    public A addNewAudience(String arg0) {
        return this.addToAudiences(new String(arg0));
    }

    @Override
    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    @Override
    public A withAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
        return (A)this;
    }

    @Override
    public Boolean hasAuthenticated() {
        return this.authenticated != null;
    }

    @Override
    public String getError() {
        return this.error;
    }

    @Override
    public A withError(String error) {
        this.error = error;
        return (A)this;
    }

    @Override
    public Boolean hasError() {
        return this.error != null;
    }

    @Override
    @Deprecated
    public A withNewError(String arg0) {
        return this.withError(new String(arg0));
    }

    @Override
    @Deprecated
    public UserInfo getUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public UserInfo buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public A withUser(UserInfo user) {
        this._visitables.get("user").remove(this.user);
        if (user != null) {
            this.user = new UserInfoBuilder(user);
            this._visitables.get("user").add(this.user);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    public TokenReviewStatusFluent.UserNested<A> withNewUser() {
        return new UserNestedImpl();
    }

    @Override
    public TokenReviewStatusFluent.UserNested<A> withNewUserLike(UserInfo item) {
        return new UserNestedImpl(item);
    }

    @Override
    public TokenReviewStatusFluent.UserNested<A> editUser() {
        return this.withNewUserLike(this.getUser());
    }

    @Override
    public TokenReviewStatusFluent.UserNested<A> editOrNewUser() {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : new UserInfoBuilder().build());
    }

    @Override
    public TokenReviewStatusFluent.UserNested<A> editOrNewUserLike(UserInfo item) {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenReviewStatusFluentImpl that = (TokenReviewStatusFluentImpl)o;
        if (this.audiences != null ? !this.audiences.equals(that.audiences) : that.audiences != null) {
            return false;
        }
        if (this.authenticated != null ? !this.authenticated.equals(that.authenticated) : that.authenticated != null) {
            return false;
        }
        if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.audiences, this.authenticated, this.error, this.user, this.additionalProperties, super.hashCode());
    }

    public class UserNestedImpl<N>
    extends UserInfoFluentImpl<TokenReviewStatusFluent.UserNested<N>>
    implements TokenReviewStatusFluent.UserNested<N>,
    Nested<N> {
        UserInfoBuilder builder;

        UserNestedImpl(UserInfo item) {
            this.builder = new UserInfoBuilder(this, item);
        }

        UserNestedImpl() {
            this.builder = new UserInfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)TokenReviewStatusFluentImpl.this.withUser(this.builder.build());
        }

        @Override
        public N endUser() {
            return this.and();
        }
    }
}

