/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_11;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.kubernetes.api.model.v5_11.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v5_11.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v5_11.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v5_11.StorageOSVolumeSource;
import io.fabric8.kubernetes.api.model.v5_11.StorageOSVolumeSourceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class StorageOSVolumeSourceFluentImpl<A extends StorageOSVolumeSourceFluent<A>>
extends BaseFluent<A>
implements StorageOSVolumeSourceFluent<A> {
    private String fsType;
    private Boolean readOnly;
    private LocalObjectReferenceBuilder secretRef;
    private String volumeName;
    private String volumeNamespace;
    private Map<String, Object> additionalProperties;

    public StorageOSVolumeSourceFluentImpl() {
    }

    public StorageOSVolumeSourceFluentImpl(StorageOSVolumeSource instance) {
        this.withFsType(instance.getFsType());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withVolumeName(instance.getVolumeName());
        this.withVolumeNamespace(instance.getVolumeNamespace());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    @Deprecated
    public A withNewFsType(String arg0) {
        return this.withFsType(new String(arg0));
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(LocalObjectReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name) {
        return this.withSecretRef(new LocalObjectReference(name));
    }

    @Override
    public StorageOSVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public StorageOSVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public StorageOSVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public StorageOSVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public StorageOSVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    @Override
    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeName() {
        return this.volumeName != null;
    }

    @Override
    @Deprecated
    public A withNewVolumeName(String arg0) {
        return this.withVolumeName(new String(arg0));
    }

    @Override
    public String getVolumeNamespace() {
        return this.volumeNamespace;
    }

    @Override
    public A withVolumeNamespace(String volumeNamespace) {
        this.volumeNamespace = volumeNamespace;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeNamespace() {
        return this.volumeNamespace != null;
    }

    @Override
    @Deprecated
    public A withNewVolumeNamespace(String arg0) {
        return this.withVolumeNamespace(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageOSVolumeSourceFluentImpl that = (StorageOSVolumeSourceFluentImpl)o;
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        if (this.volumeName != null ? !this.volumeName.equals(that.volumeName) : that.volumeName != null) {
            return false;
        }
        if (this.volumeNamespace != null ? !this.volumeNamespace.equals(that.volumeNamespace) : that.volumeNamespace != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.readOnly, this.secretRef, this.volumeName, this.volumeNamespace, this.additionalProperties, super.hashCode());
    }

    public class SecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<StorageOSVolumeSourceFluent.SecretRefNested<N>>
    implements StorageOSVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        SecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)StorageOSVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

