/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_11;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.kubernetes.api.model.v5_11.ServicePort;
import io.fabric8.kubernetes.api.model.v5_11.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.v5_11.ServicePortFluentImpl;
import io.fabric8.kubernetes.api.model.v5_11.ServiceSpec;
import io.fabric8.kubernetes.api.model.v5_11.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.v5_11.SessionAffinityConfig;
import io.fabric8.kubernetes.api.model.v5_11.SessionAffinityConfigBuilder;
import io.fabric8.kubernetes.api.model.v5_11.SessionAffinityConfigFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ServiceSpecFluentImpl<A extends ServiceSpecFluent<A>>
extends BaseFluent<A>
implements ServiceSpecFluent<A> {
    private Boolean allocateLoadBalancerNodePorts;
    private String clusterIP;
    private List<String> clusterIPs = new ArrayList<String>();
    private List<String> externalIPs = new ArrayList<String>();
    private String externalName;
    private String externalTrafficPolicy;
    private Integer healthCheckNodePort;
    private String internalTrafficPolicy;
    private List<String> ipFamilies = new ArrayList<String>();
    private String ipFamilyPolicy;
    private String loadBalancerClass;
    private String loadBalancerIP;
    private List<String> loadBalancerSourceRanges = new ArrayList<String>();
    private List<ServicePortBuilder> ports = new ArrayList<ServicePortBuilder>();
    private Boolean publishNotReadyAddresses;
    private Map<String, String> selector;
    private String sessionAffinity;
    private SessionAffinityConfigBuilder sessionAffinityConfig;
    private String type;
    private Map<String, Object> additionalProperties;

    public ServiceSpecFluentImpl() {
    }

    public ServiceSpecFluentImpl(ServiceSpec instance) {
        this.withAllocateLoadBalancerNodePorts(instance.getAllocateLoadBalancerNodePorts());
        this.withClusterIP(instance.getClusterIP());
        this.withClusterIPs(instance.getClusterIPs());
        this.withExternalIPs(instance.getExternalIPs());
        this.withExternalName(instance.getExternalName());
        this.withExternalTrafficPolicy(instance.getExternalTrafficPolicy());
        this.withHealthCheckNodePort(instance.getHealthCheckNodePort());
        this.withInternalTrafficPolicy(instance.getInternalTrafficPolicy());
        this.withIpFamilies(instance.getIpFamilies());
        this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
        this.withLoadBalancerClass(instance.getLoadBalancerClass());
        this.withLoadBalancerIP(instance.getLoadBalancerIP());
        this.withLoadBalancerSourceRanges(instance.getLoadBalancerSourceRanges());
        this.withPorts(instance.getPorts());
        this.withPublishNotReadyAddresses(instance.getPublishNotReadyAddresses());
        this.withSelector(instance.getSelector());
        this.withSessionAffinity(instance.getSessionAffinity());
        this.withSessionAffinityConfig(instance.getSessionAffinityConfig());
        this.withType(instance.getType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Boolean getAllocateLoadBalancerNodePorts() {
        return this.allocateLoadBalancerNodePorts;
    }

    @Override
    public A withAllocateLoadBalancerNodePorts(Boolean allocateLoadBalancerNodePorts) {
        this.allocateLoadBalancerNodePorts = allocateLoadBalancerNodePorts;
        return (A)this;
    }

    @Override
    public Boolean hasAllocateLoadBalancerNodePorts() {
        return this.allocateLoadBalancerNodePorts != null;
    }

    @Override
    public String getClusterIP() {
        return this.clusterIP;
    }

    @Override
    public A withClusterIP(String clusterIP) {
        this.clusterIP = clusterIP;
        return (A)this;
    }

    @Override
    public Boolean hasClusterIP() {
        return this.clusterIP != null;
    }

    @Override
    @Deprecated
    public A withNewClusterIP(String arg0) {
        return this.withClusterIP(new String(arg0));
    }

    @Override
    public A addToClusterIPs(Integer index, String item) {
        if (this.clusterIPs == null) {
            this.clusterIPs = new ArrayList<String>();
        }
        this.clusterIPs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToClusterIPs(Integer index, String item) {
        if (this.clusterIPs == null) {
            this.clusterIPs = new ArrayList<String>();
        }
        this.clusterIPs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToClusterIPs(String ... items) {
        if (this.clusterIPs == null) {
            this.clusterIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.clusterIPs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToClusterIPs(Collection<String> items) {
        if (this.clusterIPs == null) {
            this.clusterIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.clusterIPs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromClusterIPs(String ... items) {
        for (String item : items) {
            if (this.clusterIPs == null) continue;
            this.clusterIPs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromClusterIPs(Collection<String> items) {
        for (String item : items) {
            if (this.clusterIPs == null) continue;
            this.clusterIPs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getClusterIPs() {
        return this.clusterIPs;
    }

    @Override
    public String getClusterIP(Integer index) {
        return this.clusterIPs.get(index);
    }

    @Override
    public String getFirstClusterIP() {
        return this.clusterIPs.get(0);
    }

    @Override
    public String getLastClusterIP() {
        return this.clusterIPs.get(this.clusterIPs.size() - 1);
    }

    @Override
    public String getMatchingClusterIP(Predicate<String> predicate) {
        for (String item : this.clusterIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingClusterIP(Predicate<String> predicate) {
        for (String item : this.clusterIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withClusterIPs(List<String> clusterIPs) {
        if (clusterIPs != null) {
            this.clusterIPs = new ArrayList<String>();
            for (String item : clusterIPs) {
                this.addToClusterIPs(item);
            }
        } else {
            this.clusterIPs = null;
        }
        return (A)this;
    }

    @Override
    public A withClusterIPs(String ... clusterIPs) {
        if (this.clusterIPs != null) {
            this.clusterIPs.clear();
        }
        if (clusterIPs != null) {
            for (String item : clusterIPs) {
                this.addToClusterIPs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusterIPs() {
        return this.clusterIPs != null && !this.clusterIPs.isEmpty();
    }

    @Override
    public A addNewClusterIP(String arg0) {
        return this.addToClusterIPs(new String(arg0));
    }

    @Override
    public A addToExternalIPs(Integer index, String item) {
        if (this.externalIPs == null) {
            this.externalIPs = new ArrayList<String>();
        }
        this.externalIPs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToExternalIPs(Integer index, String item) {
        if (this.externalIPs == null) {
            this.externalIPs = new ArrayList<String>();
        }
        this.externalIPs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToExternalIPs(String ... items) {
        if (this.externalIPs == null) {
            this.externalIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.externalIPs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToExternalIPs(Collection<String> items) {
        if (this.externalIPs == null) {
            this.externalIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.externalIPs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromExternalIPs(String ... items) {
        for (String item : items) {
            if (this.externalIPs == null) continue;
            this.externalIPs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExternalIPs(Collection<String> items) {
        for (String item : items) {
            if (this.externalIPs == null) continue;
            this.externalIPs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getExternalIPs() {
        return this.externalIPs;
    }

    @Override
    public String getExternalIP(Integer index) {
        return this.externalIPs.get(index);
    }

    @Override
    public String getFirstExternalIP() {
        return this.externalIPs.get(0);
    }

    @Override
    public String getLastExternalIP() {
        return this.externalIPs.get(this.externalIPs.size() - 1);
    }

    @Override
    public String getMatchingExternalIP(Predicate<String> predicate) {
        for (String item : this.externalIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExternalIP(Predicate<String> predicate) {
        for (String item : this.externalIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExternalIPs(List<String> externalIPs) {
        if (externalIPs != null) {
            this.externalIPs = new ArrayList<String>();
            for (String item : externalIPs) {
                this.addToExternalIPs(item);
            }
        } else {
            this.externalIPs = null;
        }
        return (A)this;
    }

    @Override
    public A withExternalIPs(String ... externalIPs) {
        if (this.externalIPs != null) {
            this.externalIPs.clear();
        }
        if (externalIPs != null) {
            for (String item : externalIPs) {
                this.addToExternalIPs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExternalIPs() {
        return this.externalIPs != null && !this.externalIPs.isEmpty();
    }

    @Override
    public A addNewExternalIP(String arg0) {
        return this.addToExternalIPs(new String(arg0));
    }

    @Override
    public String getExternalName() {
        return this.externalName;
    }

    @Override
    public A withExternalName(String externalName) {
        this.externalName = externalName;
        return (A)this;
    }

    @Override
    public Boolean hasExternalName() {
        return this.externalName != null;
    }

    @Override
    @Deprecated
    public A withNewExternalName(String arg0) {
        return this.withExternalName(new String(arg0));
    }

    @Override
    public String getExternalTrafficPolicy() {
        return this.externalTrafficPolicy;
    }

    @Override
    public A withExternalTrafficPolicy(String externalTrafficPolicy) {
        this.externalTrafficPolicy = externalTrafficPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasExternalTrafficPolicy() {
        return this.externalTrafficPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewExternalTrafficPolicy(String arg0) {
        return this.withExternalTrafficPolicy(new String(arg0));
    }

    @Override
    public Integer getHealthCheckNodePort() {
        return this.healthCheckNodePort;
    }

    @Override
    public A withHealthCheckNodePort(Integer healthCheckNodePort) {
        this.healthCheckNodePort = healthCheckNodePort;
        return (A)this;
    }

    @Override
    public Boolean hasHealthCheckNodePort() {
        return this.healthCheckNodePort != null;
    }

    @Override
    public String getInternalTrafficPolicy() {
        return this.internalTrafficPolicy;
    }

    @Override
    public A withInternalTrafficPolicy(String internalTrafficPolicy) {
        this.internalTrafficPolicy = internalTrafficPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasInternalTrafficPolicy() {
        return this.internalTrafficPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewInternalTrafficPolicy(String arg0) {
        return this.withInternalTrafficPolicy(new String(arg0));
    }

    @Override
    public A addToIpFamilies(Integer index, String item) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<String>();
        }
        this.ipFamilies.add(index, item);
        return (A)this;
    }

    @Override
    public A setToIpFamilies(Integer index, String item) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<String>();
        }
        this.ipFamilies.set(index, item);
        return (A)this;
    }

    @Override
    public A addToIpFamilies(String ... items) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipFamilies.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToIpFamilies(Collection<String> items) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipFamilies.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromIpFamilies(String ... items) {
        for (String item : items) {
            if (this.ipFamilies == null) continue;
            this.ipFamilies.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIpFamilies(Collection<String> items) {
        for (String item : items) {
            if (this.ipFamilies == null) continue;
            this.ipFamilies.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getIpFamilies() {
        return this.ipFamilies;
    }

    @Override
    public String getIpFamily(Integer index) {
        return this.ipFamilies.get(index);
    }

    @Override
    public String getFirstIpFamily() {
        return this.ipFamilies.get(0);
    }

    @Override
    public String getLastIpFamily() {
        return this.ipFamilies.get(this.ipFamilies.size() - 1);
    }

    @Override
    public String getMatchingIpFamily(Predicate<String> predicate) {
        for (String item : this.ipFamilies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIpFamily(Predicate<String> predicate) {
        for (String item : this.ipFamilies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIpFamilies(List<String> ipFamilies) {
        if (ipFamilies != null) {
            this.ipFamilies = new ArrayList<String>();
            for (String item : ipFamilies) {
                this.addToIpFamilies(item);
            }
        } else {
            this.ipFamilies = null;
        }
        return (A)this;
    }

    @Override
    public A withIpFamilies(String ... ipFamilies) {
        if (this.ipFamilies != null) {
            this.ipFamilies.clear();
        }
        if (ipFamilies != null) {
            for (String item : ipFamilies) {
                this.addToIpFamilies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIpFamilies() {
        return this.ipFamilies != null && !this.ipFamilies.isEmpty();
    }

    @Override
    public A addNewIpFamily(String arg0) {
        return this.addToIpFamilies(new String(arg0));
    }

    @Override
    public String getIpFamilyPolicy() {
        return this.ipFamilyPolicy;
    }

    @Override
    public A withIpFamilyPolicy(String ipFamilyPolicy) {
        this.ipFamilyPolicy = ipFamilyPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasIpFamilyPolicy() {
        return this.ipFamilyPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewIpFamilyPolicy(String arg0) {
        return this.withIpFamilyPolicy(new String(arg0));
    }

    @Override
    public String getLoadBalancerClass() {
        return this.loadBalancerClass;
    }

    @Override
    public A withLoadBalancerClass(String loadBalancerClass) {
        this.loadBalancerClass = loadBalancerClass;
        return (A)this;
    }

    @Override
    public Boolean hasLoadBalancerClass() {
        return this.loadBalancerClass != null;
    }

    @Override
    @Deprecated
    public A withNewLoadBalancerClass(String arg0) {
        return this.withLoadBalancerClass(new String(arg0));
    }

    @Override
    public String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    @Override
    public A withLoadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP = loadBalancerIP;
        return (A)this;
    }

    @Override
    public Boolean hasLoadBalancerIP() {
        return this.loadBalancerIP != null;
    }

    @Override
    @Deprecated
    public A withNewLoadBalancerIP(String arg0) {
        return this.withLoadBalancerIP(new String(arg0));
    }

    @Override
    public A addToLoadBalancerSourceRanges(Integer index, String item) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        this.loadBalancerSourceRanges.add(index, item);
        return (A)this;
    }

    @Override
    public A setToLoadBalancerSourceRanges(Integer index, String item) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        this.loadBalancerSourceRanges.set(index, item);
        return (A)this;
    }

    @Override
    public A addToLoadBalancerSourceRanges(String ... items) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        for (String item : items) {
            this.loadBalancerSourceRanges.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToLoadBalancerSourceRanges(Collection<String> items) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        for (String item : items) {
            this.loadBalancerSourceRanges.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromLoadBalancerSourceRanges(String ... items) {
        for (String item : items) {
            if (this.loadBalancerSourceRanges == null) continue;
            this.loadBalancerSourceRanges.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLoadBalancerSourceRanges(Collection<String> items) {
        for (String item : items) {
            if (this.loadBalancerSourceRanges == null) continue;
            this.loadBalancerSourceRanges.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges;
    }

    @Override
    public String getLoadBalancerSourceRange(Integer index) {
        return this.loadBalancerSourceRanges.get(index);
    }

    @Override
    public String getFirstLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(0);
    }

    @Override
    public String getLastLoadBalancerSourceRange() {
        return this.loadBalancerSourceRanges.get(this.loadBalancerSourceRanges.size() - 1);
    }

    @Override
    public String getMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
        for (String item : this.loadBalancerSourceRanges) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLoadBalancerSourceRange(Predicate<String> predicate) {
        for (String item : this.loadBalancerSourceRanges) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
        if (loadBalancerSourceRanges != null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
            for (String item : loadBalancerSourceRanges) {
                this.addToLoadBalancerSourceRanges(item);
            }
        } else {
            this.loadBalancerSourceRanges = null;
        }
        return (A)this;
    }

    @Override
    public A withLoadBalancerSourceRanges(String ... loadBalancerSourceRanges) {
        if (this.loadBalancerSourceRanges != null) {
            this.loadBalancerSourceRanges.clear();
        }
        if (loadBalancerSourceRanges != null) {
            for (String item : loadBalancerSourceRanges) {
                this.addToLoadBalancerSourceRanges(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges != null && !this.loadBalancerSourceRanges.isEmpty();
    }

    @Override
    public A addNewLoadBalancerSourceRange(String arg0) {
        return this.addToLoadBalancerSourceRanges(new String(arg0));
    }

    @Override
    public A addToPorts(Integer index, ServicePort item) {
        if (this.ports == null) {
            this.ports = new ArrayList<ServicePortBuilder>();
        }
        ServicePortBuilder builder = new ServicePortBuilder(item);
        this._visitables.get("ports").add(index >= 0 ? index.intValue() : this._visitables.get("ports").size(), builder);
        this.ports.add(index >= 0 ? index.intValue() : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(Integer index, ServicePort item) {
        if (this.ports == null) {
            this.ports = new ArrayList<ServicePortBuilder>();
        }
        ServicePortBuilder builder = new ServicePortBuilder(item);
        if (index < 0 || index >= this._visitables.get("ports").size()) {
            this._visitables.get("ports").add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(ServicePort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList<ServicePortBuilder>();
        }
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<ServicePort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList<ServicePortBuilder>();
        }
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(ServicePort ... items) {
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<ServicePort> items) {
        for (ServicePort item : items) {
            ServicePortBuilder builder = new ServicePortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<ServicePortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<ServicePortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            ServicePortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ServicePort> getPorts() {
        return ServiceSpecFluentImpl.build(this.ports);
    }

    @Override
    public List<ServicePort> buildPorts() {
        return ServiceSpecFluentImpl.build(this.ports);
    }

    @Override
    public ServicePort buildPort(Integer index) {
        return this.ports.get(index).build();
    }

    @Override
    public ServicePort buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public ServicePort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public ServicePort buildMatchingPort(Predicate<ServicePortBuilder> predicate) {
        for (ServicePortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<ServicePortBuilder> predicate) {
        for (ServicePortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<ServicePort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList<ServicePortBuilder>();
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(ServicePort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (ServicePort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> addNewPortLike(ServicePort item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> setNewPortLike(Integer index, ServicePort item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> editPort(Integer index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ServiceSpecFluent.PortsNested<A> editMatchingPort(Predicate<ServicePortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public Boolean getPublishNotReadyAddresses() {
        return this.publishNotReadyAddresses;
    }

    @Override
    public A withPublishNotReadyAddresses(Boolean publishNotReadyAddresses) {
        this.publishNotReadyAddresses = publishNotReadyAddresses;
        return (A)this;
    }

    @Override
    public Boolean hasPublishNotReadyAddresses() {
        return this.publishNotReadyAddresses != null;
    }

    @Override
    public A addToSelector(String key, String value) {
        if (this.selector == null && key != null && value != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSelector(Map<String, String> map) {
        if (this.selector == null && map != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(String key) {
        if (this.selector == null) {
            return (A)this;
        }
        if (key != null && this.selector != null) {
            this.selector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(Map<String, String> map) {
        if (this.selector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.selector == null) continue;
                this.selector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @Override
    public <K, V> A withSelector(Map<String, String> selector) {
        this.selector = selector == null ? null : new LinkedHashMap<String, String>(selector);
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public String getSessionAffinity() {
        return this.sessionAffinity;
    }

    @Override
    public A withSessionAffinity(String sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
        return (A)this;
    }

    @Override
    public Boolean hasSessionAffinity() {
        return this.sessionAffinity != null;
    }

    @Override
    @Deprecated
    public A withNewSessionAffinity(String arg0) {
        return this.withSessionAffinity(new String(arg0));
    }

    @Override
    @Deprecated
    public SessionAffinityConfig getSessionAffinityConfig() {
        return this.sessionAffinityConfig != null ? this.sessionAffinityConfig.build() : null;
    }

    @Override
    public SessionAffinityConfig buildSessionAffinityConfig() {
        return this.sessionAffinityConfig != null ? this.sessionAffinityConfig.build() : null;
    }

    @Override
    public A withSessionAffinityConfig(SessionAffinityConfig sessionAffinityConfig) {
        this._visitables.get("sessionAffinityConfig").remove(this.sessionAffinityConfig);
        if (sessionAffinityConfig != null) {
            this.sessionAffinityConfig = new SessionAffinityConfigBuilder(sessionAffinityConfig);
            this._visitables.get("sessionAffinityConfig").add(this.sessionAffinityConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSessionAffinityConfig() {
        return this.sessionAffinityConfig != null;
    }

    @Override
    public ServiceSpecFluent.SessionAffinityConfigNested<A> withNewSessionAffinityConfig() {
        return new SessionAffinityConfigNestedImpl();
    }

    @Override
    public ServiceSpecFluent.SessionAffinityConfigNested<A> withNewSessionAffinityConfigLike(SessionAffinityConfig item) {
        return new SessionAffinityConfigNestedImpl(item);
    }

    @Override
    public ServiceSpecFluent.SessionAffinityConfigNested<A> editSessionAffinityConfig() {
        return this.withNewSessionAffinityConfigLike(this.getSessionAffinityConfig());
    }

    @Override
    public ServiceSpecFluent.SessionAffinityConfigNested<A> editOrNewSessionAffinityConfig() {
        return this.withNewSessionAffinityConfigLike(this.getSessionAffinityConfig() != null ? this.getSessionAffinityConfig() : new SessionAffinityConfigBuilder().build());
    }

    @Override
    public ServiceSpecFluent.SessionAffinityConfigNested<A> editOrNewSessionAffinityConfigLike(SessionAffinityConfig item) {
        return this.withNewSessionAffinityConfigLike(this.getSessionAffinityConfig() != null ? this.getSessionAffinityConfig() : item);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    @Deprecated
    public A withNewType(String arg0) {
        return this.withType(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSpecFluentImpl that = (ServiceSpecFluentImpl)o;
        if (this.allocateLoadBalancerNodePorts != null ? !this.allocateLoadBalancerNodePorts.equals(that.allocateLoadBalancerNodePorts) : that.allocateLoadBalancerNodePorts != null) {
            return false;
        }
        if (this.clusterIP != null ? !this.clusterIP.equals(that.clusterIP) : that.clusterIP != null) {
            return false;
        }
        if (this.clusterIPs != null ? !this.clusterIPs.equals(that.clusterIPs) : that.clusterIPs != null) {
            return false;
        }
        if (this.externalIPs != null ? !this.externalIPs.equals(that.externalIPs) : that.externalIPs != null) {
            return false;
        }
        if (this.externalName != null ? !this.externalName.equals(that.externalName) : that.externalName != null) {
            return false;
        }
        if (this.externalTrafficPolicy != null ? !this.externalTrafficPolicy.equals(that.externalTrafficPolicy) : that.externalTrafficPolicy != null) {
            return false;
        }
        if (this.healthCheckNodePort != null ? !this.healthCheckNodePort.equals(that.healthCheckNodePort) : that.healthCheckNodePort != null) {
            return false;
        }
        if (this.internalTrafficPolicy != null ? !this.internalTrafficPolicy.equals(that.internalTrafficPolicy) : that.internalTrafficPolicy != null) {
            return false;
        }
        if (this.ipFamilies != null ? !this.ipFamilies.equals(that.ipFamilies) : that.ipFamilies != null) {
            return false;
        }
        if (this.ipFamilyPolicy != null ? !this.ipFamilyPolicy.equals(that.ipFamilyPolicy) : that.ipFamilyPolicy != null) {
            return false;
        }
        if (this.loadBalancerClass != null ? !this.loadBalancerClass.equals(that.loadBalancerClass) : that.loadBalancerClass != null) {
            return false;
        }
        if (this.loadBalancerIP != null ? !this.loadBalancerIP.equals(that.loadBalancerIP) : that.loadBalancerIP != null) {
            return false;
        }
        if (this.loadBalancerSourceRanges != null ? !this.loadBalancerSourceRanges.equals(that.loadBalancerSourceRanges) : that.loadBalancerSourceRanges != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.publishNotReadyAddresses != null ? !this.publishNotReadyAddresses.equals(that.publishNotReadyAddresses) : that.publishNotReadyAddresses != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.sessionAffinity != null ? !this.sessionAffinity.equals(that.sessionAffinity) : that.sessionAffinity != null) {
            return false;
        }
        if (this.sessionAffinityConfig != null ? !this.sessionAffinityConfig.equals(that.sessionAffinityConfig) : that.sessionAffinityConfig != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.allocateLoadBalancerNodePorts, this.clusterIP, this.clusterIPs, this.externalIPs, this.externalName, this.externalTrafficPolicy, this.healthCheckNodePort, this.internalTrafficPolicy, this.ipFamilies, this.ipFamilyPolicy, this.loadBalancerClass, this.loadBalancerIP, this.loadBalancerSourceRanges, this.ports, this.publishNotReadyAddresses, this.selector, this.sessionAffinity, this.sessionAffinityConfig, this.type, this.additionalProperties, super.hashCode());
    }

    public class SessionAffinityConfigNestedImpl<N>
    extends SessionAffinityConfigFluentImpl<ServiceSpecFluent.SessionAffinityConfigNested<N>>
    implements ServiceSpecFluent.SessionAffinityConfigNested<N>,
    Nested<N> {
        SessionAffinityConfigBuilder builder;

        SessionAffinityConfigNestedImpl(SessionAffinityConfig item) {
            this.builder = new SessionAffinityConfigBuilder(this, item);
        }

        SessionAffinityConfigNestedImpl() {
            this.builder = new SessionAffinityConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceSpecFluentImpl.this.withSessionAffinityConfig(this.builder.build());
        }

        @Override
        public N endSessionAffinityConfig() {
            return this.and();
        }
    }

    public class PortsNestedImpl<N>
    extends ServicePortFluentImpl<ServiceSpecFluent.PortsNested<N>>
    implements ServiceSpecFluent.PortsNested<N>,
    Nested<N> {
        ServicePortBuilder builder;
        Integer index;

        PortsNestedImpl(Integer index, ServicePort item) {
            this.index = index;
            this.builder = new ServicePortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new ServicePortBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceSpecFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

