/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_11;

import io.fabric8.kubernetes.api.builder.v5_11.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_11.ExecAction;
import io.fabric8.kubernetes.api.model.v5_11.ExecActionFluent;
import io.fabric8.kubernetes.api.model.v5_11.ExecActionFluentImpl;
import java.util.Objects;

public class ExecActionBuilder
extends ExecActionFluentImpl<ExecActionBuilder>
implements VisitableBuilder<ExecAction, ExecActionBuilder> {
    ExecActionFluent<?> fluent;
    Boolean validationEnabled;

    public ExecActionBuilder() {
        this(false);
    }

    public ExecActionBuilder(Boolean validationEnabled) {
        this(new ExecAction(), validationEnabled);
    }

    public ExecActionBuilder(ExecActionFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ExecActionBuilder(ExecActionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ExecAction(), validationEnabled);
    }

    public ExecActionBuilder(ExecActionFluent<?> fluent, ExecAction instance) {
        this(fluent, instance, false);
    }

    public ExecActionBuilder(ExecActionFluent<?> fluent, ExecAction instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCommand(instance.getCommand());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ExecActionBuilder(ExecAction instance) {
        this(instance, (Boolean)false);
    }

    public ExecActionBuilder(ExecAction instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCommand(instance.getCommand());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ExecAction build() {
        ExecAction buildable = new ExecAction(this.fluent.getCommand());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecActionBuilder that = (ExecActionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

