/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_11;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.kubernetes.api.model.v5_11.EndpointAddress;
import io.fabric8.kubernetes.api.model.v5_11.EndpointAddressFluent;
import io.fabric8.kubernetes.api.model.v5_11.ObjectReference;
import io.fabric8.kubernetes.api.model.v5_11.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v5_11.ObjectReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class EndpointAddressFluentImpl<A extends EndpointAddressFluent<A>>
extends BaseFluent<A>
implements EndpointAddressFluent<A> {
    private String hostname;
    private String ip;
    private String nodeName;
    private ObjectReferenceBuilder targetRef;
    private Map<String, Object> additionalProperties;

    public EndpointAddressFluentImpl() {
    }

    public EndpointAddressFluentImpl(EndpointAddress instance) {
        this.withHostname(instance.getHostname());
        this.withIp(instance.getIp());
        this.withNodeName(instance.getNodeName());
        this.withTargetRef(instance.getTargetRef());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    @Deprecated
    public A withNewHostname(String arg0) {
        return this.withHostname(new String(arg0));
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    @Override
    public Boolean hasIp() {
        return this.ip != null;
    }

    @Override
    @Deprecated
    public A withNewIp(String arg0) {
        return this.withIp(new String(arg0));
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    @Override
    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    @Override
    @Deprecated
    public A withNewNodeName(String arg0) {
        return this.withNodeName(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectReference getTargetRef() {
        return this.targetRef != null ? this.targetRef.build() : null;
    }

    @Override
    public ObjectReference buildTargetRef() {
        return this.targetRef != null ? this.targetRef.build() : null;
    }

    @Override
    public A withTargetRef(ObjectReference targetRef) {
        this._visitables.get("targetRef").remove(this.targetRef);
        if (targetRef != null) {
            this.targetRef = new ObjectReferenceBuilder(targetRef);
            this._visitables.get("targetRef").add(this.targetRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargetRef() {
        return this.targetRef != null;
    }

    @Override
    public EndpointAddressFluent.TargetRefNested<A> withNewTargetRef() {
        return new TargetRefNestedImpl();
    }

    @Override
    public EndpointAddressFluent.TargetRefNested<A> withNewTargetRefLike(ObjectReference item) {
        return new TargetRefNestedImpl(item);
    }

    @Override
    public EndpointAddressFluent.TargetRefNested<A> editTargetRef() {
        return this.withNewTargetRefLike(this.getTargetRef());
    }

    @Override
    public EndpointAddressFluent.TargetRefNested<A> editOrNewTargetRef() {
        return this.withNewTargetRefLike(this.getTargetRef() != null ? this.getTargetRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public EndpointAddressFluent.TargetRefNested<A> editOrNewTargetRefLike(ObjectReference item) {
        return this.withNewTargetRefLike(this.getTargetRef() != null ? this.getTargetRef() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointAddressFluentImpl that = (EndpointAddressFluentImpl)o;
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.ip != null ? !this.ip.equals(that.ip) : that.ip != null) {
            return false;
        }
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        if (this.targetRef != null ? !this.targetRef.equals(that.targetRef) : that.targetRef != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.ip, this.nodeName, this.targetRef, this.additionalProperties, super.hashCode());
    }

    public class TargetRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<EndpointAddressFluent.TargetRefNested<N>>
    implements EndpointAddressFluent.TargetRefNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        TargetRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        TargetRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointAddressFluentImpl.this.withTargetRef(this.builder.build());
        }

        @Override
        public N endTargetRef() {
            return this.and();
        }
    }
}

