/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_11.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.openshift.api.model.v5_11.operator.v1.AccessLogging;
import io.fabric8.openshift.api.model.v5_11.operator.v1.AccessLoggingFluent;
import io.fabric8.openshift.api.model.v5_11.operator.v1.IngressControllerCaptureHTTPCookie;
import io.fabric8.openshift.api.model.v5_11.operator.v1.IngressControllerCaptureHTTPCookieBuilder;
import io.fabric8.openshift.api.model.v5_11.operator.v1.IngressControllerCaptureHTTPCookieFluentImpl;
import io.fabric8.openshift.api.model.v5_11.operator.v1.IngressControllerCaptureHTTPHeaders;
import io.fabric8.openshift.api.model.v5_11.operator.v1.IngressControllerCaptureHTTPHeadersBuilder;
import io.fabric8.openshift.api.model.v5_11.operator.v1.IngressControllerCaptureHTTPHeadersFluentImpl;
import io.fabric8.openshift.api.model.v5_11.operator.v1.LoggingDestination;
import io.fabric8.openshift.api.model.v5_11.operator.v1.LoggingDestinationBuilder;
import io.fabric8.openshift.api.model.v5_11.operator.v1.LoggingDestinationFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AccessLoggingFluentImpl<A extends AccessLoggingFluent<A>>
extends BaseFluent<A>
implements AccessLoggingFluent<A> {
    private LoggingDestinationBuilder destination;
    private List<IngressControllerCaptureHTTPCookieBuilder> httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();
    private IngressControllerCaptureHTTPHeadersBuilder httpCaptureHeaders;
    private String httpLogFormat;
    private String logEmptyRequests;
    private Map<String, Object> additionalProperties;

    public AccessLoggingFluentImpl() {
    }

    public AccessLoggingFluentImpl(AccessLogging instance) {
        this.withDestination(instance.getDestination());
        this.withHttpCaptureCookies(instance.getHttpCaptureCookies());
        this.withHttpCaptureHeaders(instance.getHttpCaptureHeaders());
        this.withHttpLogFormat(instance.getHttpLogFormat());
        this.withLogEmptyRequests(instance.getLogEmptyRequests());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public LoggingDestination getDestination() {
        return this.destination != null ? this.destination.build() : null;
    }

    @Override
    public LoggingDestination buildDestination() {
        return this.destination != null ? this.destination.build() : null;
    }

    @Override
    public A withDestination(LoggingDestination destination) {
        this._visitables.get("destination").remove(this.destination);
        if (destination != null) {
            this.destination = new LoggingDestinationBuilder(destination);
            this._visitables.get("destination").add(this.destination);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDestination() {
        return this.destination != null;
    }

    @Override
    public AccessLoggingFluent.DestinationNested<A> withNewDestination() {
        return new DestinationNestedImpl();
    }

    @Override
    public AccessLoggingFluent.DestinationNested<A> withNewDestinationLike(LoggingDestination item) {
        return new DestinationNestedImpl(item);
    }

    @Override
    public AccessLoggingFluent.DestinationNested<A> editDestination() {
        return this.withNewDestinationLike(this.getDestination());
    }

    @Override
    public AccessLoggingFluent.DestinationNested<A> editOrNewDestination() {
        return this.withNewDestinationLike(this.getDestination() != null ? this.getDestination() : new LoggingDestinationBuilder().build());
    }

    @Override
    public AccessLoggingFluent.DestinationNested<A> editOrNewDestinationLike(LoggingDestination item) {
        return this.withNewDestinationLike(this.getDestination() != null ? this.getDestination() : item);
    }

    @Override
    public A addToHttpCaptureCookies(Integer index, IngressControllerCaptureHTTPCookie item) {
        if (this.httpCaptureCookies == null) {
            this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();
        }
        IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
        this._visitables.get("httpCaptureCookies").add(index >= 0 ? index.intValue() : this._visitables.get("httpCaptureCookies").size(), builder);
        this.httpCaptureCookies.add(index >= 0 ? index.intValue() : this.httpCaptureCookies.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHttpCaptureCookies(Integer index, IngressControllerCaptureHTTPCookie item) {
        if (this.httpCaptureCookies == null) {
            this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();
        }
        IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
        if (index < 0 || index >= this._visitables.get("httpCaptureCookies").size()) {
            this._visitables.get("httpCaptureCookies").add(builder);
        } else {
            this._visitables.get("httpCaptureCookies").set(index, builder);
        }
        if (index < 0 || index >= this.httpCaptureCookies.size()) {
            this.httpCaptureCookies.add(builder);
        } else {
            this.httpCaptureCookies.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHttpCaptureCookies(IngressControllerCaptureHTTPCookie ... items) {
        if (this.httpCaptureCookies == null) {
            this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();
        }
        for (IngressControllerCaptureHTTPCookie item : items) {
            IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
            this._visitables.get("httpCaptureCookies").add(builder);
            this.httpCaptureCookies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHttpCaptureCookies(Collection<IngressControllerCaptureHTTPCookie> items) {
        if (this.httpCaptureCookies == null) {
            this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();
        }
        for (IngressControllerCaptureHTTPCookie item : items) {
            IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
            this._visitables.get("httpCaptureCookies").add(builder);
            this.httpCaptureCookies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHttpCaptureCookies(IngressControllerCaptureHTTPCookie ... items) {
        for (IngressControllerCaptureHTTPCookie item : items) {
            IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
            this._visitables.get("httpCaptureCookies").remove(builder);
            if (this.httpCaptureCookies == null) continue;
            this.httpCaptureCookies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHttpCaptureCookies(Collection<IngressControllerCaptureHTTPCookie> items) {
        for (IngressControllerCaptureHTTPCookie item : items) {
            IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
            this._visitables.get("httpCaptureCookies").remove(builder);
            if (this.httpCaptureCookies == null) continue;
            this.httpCaptureCookies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHttpCaptureCookies(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
        if (this.httpCaptureCookies == null) {
            return (A)this;
        }
        Iterator<IngressControllerCaptureHTTPCookieBuilder> each = this.httpCaptureCookies.iterator();
        Object visitables = this._visitables.get("httpCaptureCookies");
        while (each.hasNext()) {
            IngressControllerCaptureHTTPCookieBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IngressControllerCaptureHTTPCookie> getHttpCaptureCookies() {
        return AccessLoggingFluentImpl.build(this.httpCaptureCookies);
    }

    @Override
    public List<IngressControllerCaptureHTTPCookie> buildHttpCaptureCookies() {
        return AccessLoggingFluentImpl.build(this.httpCaptureCookies);
    }

    @Override
    public IngressControllerCaptureHTTPCookie buildHttpCaptureCooky(Integer index) {
        return this.httpCaptureCookies.get(index).build();
    }

    @Override
    public IngressControllerCaptureHTTPCookie buildFirstHttpCaptureCooky() {
        return this.httpCaptureCookies.get(0).build();
    }

    @Override
    public IngressControllerCaptureHTTPCookie buildLastHttpCaptureCooky() {
        return this.httpCaptureCookies.get(this.httpCaptureCookies.size() - 1).build();
    }

    @Override
    public IngressControllerCaptureHTTPCookie buildMatchingHttpCaptureCooky(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
        for (IngressControllerCaptureHTTPCookieBuilder item : this.httpCaptureCookies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHttpCaptureCooky(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
        for (IngressControllerCaptureHTTPCookieBuilder item : this.httpCaptureCookies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHttpCaptureCookies(List<IngressControllerCaptureHTTPCookie> httpCaptureCookies) {
        if (this.httpCaptureCookies != null) {
            this._visitables.get("httpCaptureCookies").removeAll(this.httpCaptureCookies);
        }
        if (httpCaptureCookies != null) {
            this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();
            for (IngressControllerCaptureHTTPCookie item : httpCaptureCookies) {
                this.addToHttpCaptureCookies(item);
            }
        } else {
            this.httpCaptureCookies = null;
        }
        return (A)this;
    }

    @Override
    public A withHttpCaptureCookies(IngressControllerCaptureHTTPCookie ... httpCaptureCookies) {
        if (this.httpCaptureCookies != null) {
            this.httpCaptureCookies.clear();
        }
        if (httpCaptureCookies != null) {
            for (IngressControllerCaptureHTTPCookie item : httpCaptureCookies) {
                this.addToHttpCaptureCookies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHttpCaptureCookies() {
        return this.httpCaptureCookies != null && !this.httpCaptureCookies.isEmpty();
    }

    @Override
    public A addNewHttpCaptureCooky(String matchType, Integer maxLength, String name, String namePrefix) {
        return this.addToHttpCaptureCookies(new IngressControllerCaptureHTTPCookie(matchType, maxLength, name, namePrefix));
    }

    @Override
    public AccessLoggingFluent.HttpCaptureCookiesNested<A> addNewHttpCaptureCooky() {
        return new HttpCaptureCookiesNestedImpl();
    }

    @Override
    public AccessLoggingFluent.HttpCaptureCookiesNested<A> addNewHttpCaptureCookyLike(IngressControllerCaptureHTTPCookie item) {
        return new HttpCaptureCookiesNestedImpl(-1, item);
    }

    @Override
    public AccessLoggingFluent.HttpCaptureCookiesNested<A> setNewHttpCaptureCookyLike(Integer index, IngressControllerCaptureHTTPCookie item) {
        return new HttpCaptureCookiesNestedImpl(index, item);
    }

    @Override
    public AccessLoggingFluent.HttpCaptureCookiesNested<A> editHttpCaptureCooky(Integer index) {
        if (this.httpCaptureCookies.size() <= index) {
            throw new RuntimeException("Can't edit httpCaptureCookies. Index exceeds size.");
        }
        return this.setNewHttpCaptureCookyLike(index, this.buildHttpCaptureCooky(index));
    }

    @Override
    public AccessLoggingFluent.HttpCaptureCookiesNested<A> editFirstHttpCaptureCooky() {
        if (this.httpCaptureCookies.size() == 0) {
            throw new RuntimeException("Can't edit first httpCaptureCookies. The list is empty.");
        }
        return this.setNewHttpCaptureCookyLike(0, this.buildHttpCaptureCooky(0));
    }

    @Override
    public AccessLoggingFluent.HttpCaptureCookiesNested<A> editLastHttpCaptureCooky() {
        int index = this.httpCaptureCookies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last httpCaptureCookies. The list is empty.");
        }
        return this.setNewHttpCaptureCookyLike(index, this.buildHttpCaptureCooky(index));
    }

    @Override
    public AccessLoggingFluent.HttpCaptureCookiesNested<A> editMatchingHttpCaptureCooky(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.httpCaptureCookies.size(); ++i) {
            if (!predicate.test(this.httpCaptureCookies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching httpCaptureCookies. No match found.");
        }
        return this.setNewHttpCaptureCookyLike(index, this.buildHttpCaptureCooky(index));
    }

    @Override
    @Deprecated
    public IngressControllerCaptureHTTPHeaders getHttpCaptureHeaders() {
        return this.httpCaptureHeaders != null ? this.httpCaptureHeaders.build() : null;
    }

    @Override
    public IngressControllerCaptureHTTPHeaders buildHttpCaptureHeaders() {
        return this.httpCaptureHeaders != null ? this.httpCaptureHeaders.build() : null;
    }

    @Override
    public A withHttpCaptureHeaders(IngressControllerCaptureHTTPHeaders httpCaptureHeaders) {
        this._visitables.get("httpCaptureHeaders").remove(this.httpCaptureHeaders);
        if (httpCaptureHeaders != null) {
            this.httpCaptureHeaders = new IngressControllerCaptureHTTPHeadersBuilder(httpCaptureHeaders);
            this._visitables.get("httpCaptureHeaders").add(this.httpCaptureHeaders);
        }
        return (A)this;
    }

    @Override
    public Boolean hasHttpCaptureHeaders() {
        return this.httpCaptureHeaders != null;
    }

    @Override
    public AccessLoggingFluent.HttpCaptureHeadersNested<A> withNewHttpCaptureHeaders() {
        return new HttpCaptureHeadersNestedImpl();
    }

    @Override
    public AccessLoggingFluent.HttpCaptureHeadersNested<A> withNewHttpCaptureHeadersLike(IngressControllerCaptureHTTPHeaders item) {
        return new HttpCaptureHeadersNestedImpl(item);
    }

    @Override
    public AccessLoggingFluent.HttpCaptureHeadersNested<A> editHttpCaptureHeaders() {
        return this.withNewHttpCaptureHeadersLike(this.getHttpCaptureHeaders());
    }

    @Override
    public AccessLoggingFluent.HttpCaptureHeadersNested<A> editOrNewHttpCaptureHeaders() {
        return this.withNewHttpCaptureHeadersLike(this.getHttpCaptureHeaders() != null ? this.getHttpCaptureHeaders() : new IngressControllerCaptureHTTPHeadersBuilder().build());
    }

    @Override
    public AccessLoggingFluent.HttpCaptureHeadersNested<A> editOrNewHttpCaptureHeadersLike(IngressControllerCaptureHTTPHeaders item) {
        return this.withNewHttpCaptureHeadersLike(this.getHttpCaptureHeaders() != null ? this.getHttpCaptureHeaders() : item);
    }

    @Override
    public String getHttpLogFormat() {
        return this.httpLogFormat;
    }

    @Override
    public A withHttpLogFormat(String httpLogFormat) {
        this.httpLogFormat = httpLogFormat;
        return (A)this;
    }

    @Override
    public Boolean hasHttpLogFormat() {
        return this.httpLogFormat != null;
    }

    @Override
    @Deprecated
    public A withNewHttpLogFormat(String arg0) {
        return this.withHttpLogFormat(new String(arg0));
    }

    @Override
    public String getLogEmptyRequests() {
        return this.logEmptyRequests;
    }

    @Override
    public A withLogEmptyRequests(String logEmptyRequests) {
        this.logEmptyRequests = logEmptyRequests;
        return (A)this;
    }

    @Override
    public Boolean hasLogEmptyRequests() {
        return this.logEmptyRequests != null;
    }

    @Override
    @Deprecated
    public A withNewLogEmptyRequests(String arg0) {
        return this.withLogEmptyRequests(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessLoggingFluentImpl that = (AccessLoggingFluentImpl)o;
        if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) {
            return false;
        }
        if (this.httpCaptureCookies != null ? !this.httpCaptureCookies.equals(that.httpCaptureCookies) : that.httpCaptureCookies != null) {
            return false;
        }
        if (this.httpCaptureHeaders != null ? !this.httpCaptureHeaders.equals(that.httpCaptureHeaders) : that.httpCaptureHeaders != null) {
            return false;
        }
        if (this.httpLogFormat != null ? !this.httpLogFormat.equals(that.httpLogFormat) : that.httpLogFormat != null) {
            return false;
        }
        if (this.logEmptyRequests != null ? !this.logEmptyRequests.equals(that.logEmptyRequests) : that.logEmptyRequests != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.destination, this.httpCaptureCookies, this.httpCaptureHeaders, this.httpLogFormat, this.logEmptyRequests, this.additionalProperties, super.hashCode());
    }

    public class HttpCaptureHeadersNestedImpl<N>
    extends IngressControllerCaptureHTTPHeadersFluentImpl<AccessLoggingFluent.HttpCaptureHeadersNested<N>>
    implements AccessLoggingFluent.HttpCaptureHeadersNested<N>,
    Nested<N> {
        IngressControllerCaptureHTTPHeadersBuilder builder;

        HttpCaptureHeadersNestedImpl(IngressControllerCaptureHTTPHeaders item) {
            this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this, item);
        }

        HttpCaptureHeadersNestedImpl() {
            this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this);
        }

        @Override
        public N and() {
            return (N)AccessLoggingFluentImpl.this.withHttpCaptureHeaders(this.builder.build());
        }

        @Override
        public N endHttpCaptureHeaders() {
            return this.and();
        }
    }

    public class HttpCaptureCookiesNestedImpl<N>
    extends IngressControllerCaptureHTTPCookieFluentImpl<AccessLoggingFluent.HttpCaptureCookiesNested<N>>
    implements AccessLoggingFluent.HttpCaptureCookiesNested<N>,
    Nested<N> {
        IngressControllerCaptureHTTPCookieBuilder builder;
        Integer index;

        HttpCaptureCookiesNestedImpl(Integer index, IngressControllerCaptureHTTPCookie item) {
            this.index = index;
            this.builder = new IngressControllerCaptureHTTPCookieBuilder(this, item);
        }

        HttpCaptureCookiesNestedImpl() {
            this.index = -1;
            this.builder = new IngressControllerCaptureHTTPCookieBuilder(this);
        }

        @Override
        public N and() {
            return (N)AccessLoggingFluentImpl.this.setToHttpCaptureCookies(this.index, this.builder.build());
        }

        @Override
        public N endHttpCaptureCooky() {
            return this.and();
        }
    }

    public class DestinationNestedImpl<N>
    extends LoggingDestinationFluentImpl<AccessLoggingFluent.DestinationNested<N>>
    implements AccessLoggingFluent.DestinationNested<N>,
    Nested<N> {
        LoggingDestinationBuilder builder;

        DestinationNestedImpl(LoggingDestination item) {
            this.builder = new LoggingDestinationBuilder(this, item);
        }

        DestinationNestedImpl() {
            this.builder = new LoggingDestinationBuilder(this);
        }

        @Override
        public N and() {
            return (N)AccessLoggingFluentImpl.this.withDestination(this.builder.build());
        }

        @Override
        public N endDestination() {
            return this.and();
        }
    }
}

