/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_11;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.kubernetes.api.model.v5_11.EnvVar;
import io.fabric8.kubernetes.api.model.v5_11.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_11.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_11.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v5_11.ObjectReference;
import io.fabric8.kubernetes.api.model.v5_11.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v5_11.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v5_11.BinaryBuildSource;
import io.fabric8.openshift.api.model.v5_11.BinaryBuildSourceBuilder;
import io.fabric8.openshift.api.model.v5_11.BinaryBuildSourceFluentImpl;
import io.fabric8.openshift.api.model.v5_11.BuildRequest;
import io.fabric8.openshift.api.model.v5_11.BuildRequestFluent;
import io.fabric8.openshift.api.model.v5_11.BuildTriggerCause;
import io.fabric8.openshift.api.model.v5_11.BuildTriggerCauseBuilder;
import io.fabric8.openshift.api.model.v5_11.BuildTriggerCauseFluentImpl;
import io.fabric8.openshift.api.model.v5_11.DockerStrategyOptions;
import io.fabric8.openshift.api.model.v5_11.DockerStrategyOptionsBuilder;
import io.fabric8.openshift.api.model.v5_11.DockerStrategyOptionsFluentImpl;
import io.fabric8.openshift.api.model.v5_11.SourceRevision;
import io.fabric8.openshift.api.model.v5_11.SourceRevisionBuilder;
import io.fabric8.openshift.api.model.v5_11.SourceRevisionFluentImpl;
import io.fabric8.openshift.api.model.v5_11.SourceStrategyOptions;
import io.fabric8.openshift.api.model.v5_11.SourceStrategyOptionsBuilder;
import io.fabric8.openshift.api.model.v5_11.SourceStrategyOptionsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class BuildRequestFluentImpl<A extends BuildRequestFluent<A>>
extends BaseFluent<A>
implements BuildRequestFluent<A> {
    private String apiVersion;
    private BinaryBuildSourceBuilder binary;
    private DockerStrategyOptionsBuilder dockerStrategyOptions;
    private List<EnvVar> env = new ArrayList<EnvVar>();
    private ObjectReferenceBuilder from;
    private String kind;
    private Long lastVersion;
    private ObjectMetaBuilder metadata;
    private SourceRevisionBuilder revision;
    private SourceStrategyOptionsBuilder sourceStrategyOptions;
    private List<BuildTriggerCauseBuilder> triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();
    private ObjectReferenceBuilder triggeredByImage;
    private Map<String, Object> additionalProperties;

    public BuildRequestFluentImpl() {
    }

    public BuildRequestFluentImpl(BuildRequest instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withBinary(instance.getBinary());
        this.withDockerStrategyOptions(instance.getDockerStrategyOptions());
        this.withEnv(instance.getEnv());
        this.withFrom(instance.getFrom());
        this.withKind(instance.getKind());
        this.withLastVersion(instance.getLastVersion());
        this.withMetadata(instance.getMetadata());
        this.withRevision(instance.getRevision());
        this.withSourceStrategyOptions(instance.getSourceStrategyOptions());
        this.withTriggeredBy(instance.getTriggeredBy());
        this.withTriggeredByImage(instance.getTriggeredByImage());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    @Deprecated
    public BinaryBuildSource getBinary() {
        return this.binary != null ? this.binary.build() : null;
    }

    @Override
    public BinaryBuildSource buildBinary() {
        return this.binary != null ? this.binary.build() : null;
    }

    @Override
    public A withBinary(BinaryBuildSource binary) {
        this._visitables.get("binary").remove(this.binary);
        if (binary != null) {
            this.binary = new BinaryBuildSourceBuilder(binary);
            this._visitables.get("binary").add(this.binary);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBinary() {
        return this.binary != null;
    }

    @Override
    public A withNewBinary(String asFile) {
        return this.withBinary(new BinaryBuildSource(asFile));
    }

    @Override
    public BuildRequestFluent.BinaryNested<A> withNewBinary() {
        return new BinaryNestedImpl();
    }

    @Override
    public BuildRequestFluent.BinaryNested<A> withNewBinaryLike(BinaryBuildSource item) {
        return new BinaryNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.BinaryNested<A> editBinary() {
        return this.withNewBinaryLike(this.getBinary());
    }

    @Override
    public BuildRequestFluent.BinaryNested<A> editOrNewBinary() {
        return this.withNewBinaryLike(this.getBinary() != null ? this.getBinary() : new BinaryBuildSourceBuilder().build());
    }

    @Override
    public BuildRequestFluent.BinaryNested<A> editOrNewBinaryLike(BinaryBuildSource item) {
        return this.withNewBinaryLike(this.getBinary() != null ? this.getBinary() : item);
    }

    @Override
    @Deprecated
    public DockerStrategyOptions getDockerStrategyOptions() {
        return this.dockerStrategyOptions != null ? this.dockerStrategyOptions.build() : null;
    }

    @Override
    public DockerStrategyOptions buildDockerStrategyOptions() {
        return this.dockerStrategyOptions != null ? this.dockerStrategyOptions.build() : null;
    }

    @Override
    public A withDockerStrategyOptions(DockerStrategyOptions dockerStrategyOptions) {
        this._visitables.get("dockerStrategyOptions").remove(this.dockerStrategyOptions);
        if (dockerStrategyOptions != null) {
            this.dockerStrategyOptions = new DockerStrategyOptionsBuilder(dockerStrategyOptions);
            this._visitables.get("dockerStrategyOptions").add(this.dockerStrategyOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDockerStrategyOptions() {
        return this.dockerStrategyOptions != null;
    }

    @Override
    public BuildRequestFluent.DockerStrategyOptionsNested<A> withNewDockerStrategyOptions() {
        return new DockerStrategyOptionsNestedImpl();
    }

    @Override
    public BuildRequestFluent.DockerStrategyOptionsNested<A> withNewDockerStrategyOptionsLike(DockerStrategyOptions item) {
        return new DockerStrategyOptionsNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.DockerStrategyOptionsNested<A> editDockerStrategyOptions() {
        return this.withNewDockerStrategyOptionsLike(this.getDockerStrategyOptions());
    }

    @Override
    public BuildRequestFluent.DockerStrategyOptionsNested<A> editOrNewDockerStrategyOptions() {
        return this.withNewDockerStrategyOptionsLike(this.getDockerStrategyOptions() != null ? this.getDockerStrategyOptions() : new DockerStrategyOptionsBuilder().build());
    }

    @Override
    public BuildRequestFluent.DockerStrategyOptionsNested<A> editOrNewDockerStrategyOptionsLike(DockerStrategyOptions item) {
        return this.withNewDockerStrategyOptionsLike(this.getDockerStrategyOptions() != null ? this.getDockerStrategyOptions() : item);
    }

    @Override
    public A addToEnv(Integer index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.add(index, item);
        return (A)this;
    }

    @Override
    public A setToEnv(Integer index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.set(index, item);
        return (A)this;
    }

    @Override
    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            if (this.env == null) continue;
            this.env.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            if (this.env == null) continue;
            this.env.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<EnvVar> getEnv() {
        return this.env;
    }

    @Override
    public EnvVar getEnv(Integer index) {
        return this.env.get(index);
    }

    @Override
    public EnvVar getFirstEnv() {
        return this.env.get(0);
    }

    @Override
    public EnvVar getLastEnv() {
        return this.env.get(this.env.size() - 1);
    }

    @Override
    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnv(List<EnvVar> env) {
        if (env != null) {
            this.env = new ArrayList<EnvVar>();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)this;
    }

    @Override
    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    @Override
    @Deprecated
    public ObjectReference getFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        this._visitables.get("from").remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get("from").add(this.from);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFrom() {
        return this.from != null;
    }

    @Override
    public BuildRequestFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public BuildRequestFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public BuildRequestFluent.FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : new ObjectReferenceBuilder().build());
    }

    @Override
    public BuildRequestFluent.FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public Long getLastVersion() {
        return this.lastVersion;
    }

    @Override
    public A withLastVersion(Long lastVersion) {
        this.lastVersion = lastVersion;
        return (A)this;
    }

    @Override
    public Boolean hasLastVersion() {
        return this.lastVersion != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public BuildRequestFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public BuildRequestFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public BuildRequestFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public BuildRequestFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public SourceRevision getRevision() {
        return this.revision != null ? this.revision.build() : null;
    }

    @Override
    public SourceRevision buildRevision() {
        return this.revision != null ? this.revision.build() : null;
    }

    @Override
    public A withRevision(SourceRevision revision) {
        this._visitables.get("revision").remove(this.revision);
        if (revision != null) {
            this.revision = new SourceRevisionBuilder(revision);
            this._visitables.get("revision").add(this.revision);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRevision() {
        return this.revision != null;
    }

    @Override
    public BuildRequestFluent.RevisionNested<A> withNewRevision() {
        return new RevisionNestedImpl();
    }

    @Override
    public BuildRequestFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item) {
        return new RevisionNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.RevisionNested<A> editRevision() {
        return this.withNewRevisionLike(this.getRevision());
    }

    @Override
    public BuildRequestFluent.RevisionNested<A> editOrNewRevision() {
        return this.withNewRevisionLike(this.getRevision() != null ? this.getRevision() : new SourceRevisionBuilder().build());
    }

    @Override
    public BuildRequestFluent.RevisionNested<A> editOrNewRevisionLike(SourceRevision item) {
        return this.withNewRevisionLike(this.getRevision() != null ? this.getRevision() : item);
    }

    @Override
    @Deprecated
    public SourceStrategyOptions getSourceStrategyOptions() {
        return this.sourceStrategyOptions != null ? this.sourceStrategyOptions.build() : null;
    }

    @Override
    public SourceStrategyOptions buildSourceStrategyOptions() {
        return this.sourceStrategyOptions != null ? this.sourceStrategyOptions.build() : null;
    }

    @Override
    public A withSourceStrategyOptions(SourceStrategyOptions sourceStrategyOptions) {
        this._visitables.get("sourceStrategyOptions").remove(this.sourceStrategyOptions);
        if (sourceStrategyOptions != null) {
            this.sourceStrategyOptions = new SourceStrategyOptionsBuilder(sourceStrategyOptions);
            this._visitables.get("sourceStrategyOptions").add(this.sourceStrategyOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSourceStrategyOptions() {
        return this.sourceStrategyOptions != null;
    }

    @Override
    public A withNewSourceStrategyOptions(Boolean incremental) {
        return this.withSourceStrategyOptions(new SourceStrategyOptions(incremental));
    }

    @Override
    public BuildRequestFluent.SourceStrategyOptionsNested<A> withNewSourceStrategyOptions() {
        return new SourceStrategyOptionsNestedImpl();
    }

    @Override
    public BuildRequestFluent.SourceStrategyOptionsNested<A> withNewSourceStrategyOptionsLike(SourceStrategyOptions item) {
        return new SourceStrategyOptionsNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.SourceStrategyOptionsNested<A> editSourceStrategyOptions() {
        return this.withNewSourceStrategyOptionsLike(this.getSourceStrategyOptions());
    }

    @Override
    public BuildRequestFluent.SourceStrategyOptionsNested<A> editOrNewSourceStrategyOptions() {
        return this.withNewSourceStrategyOptionsLike(this.getSourceStrategyOptions() != null ? this.getSourceStrategyOptions() : new SourceStrategyOptionsBuilder().build());
    }

    @Override
    public BuildRequestFluent.SourceStrategyOptionsNested<A> editOrNewSourceStrategyOptionsLike(SourceStrategyOptions item) {
        return this.withNewSourceStrategyOptionsLike(this.getSourceStrategyOptions() != null ? this.getSourceStrategyOptions() : item);
    }

    @Override
    public A addToTriggeredBy(Integer index, BuildTriggerCause item) {
        if (this.triggeredBy == null) {
            this.triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();
        }
        BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
        this._visitables.get("triggeredBy").add(index >= 0 ? index.intValue() : this._visitables.get("triggeredBy").size(), builder);
        this.triggeredBy.add(index >= 0 ? index.intValue() : this.triggeredBy.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTriggeredBy(Integer index, BuildTriggerCause item) {
        if (this.triggeredBy == null) {
            this.triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();
        }
        BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
        if (index < 0 || index >= this._visitables.get("triggeredBy").size()) {
            this._visitables.get("triggeredBy").add(builder);
        } else {
            this._visitables.get("triggeredBy").set(index, builder);
        }
        if (index < 0 || index >= this.triggeredBy.size()) {
            this.triggeredBy.add(builder);
        } else {
            this.triggeredBy.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTriggeredBy(BuildTriggerCause ... items) {
        if (this.triggeredBy == null) {
            this.triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();
        }
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.get("triggeredBy").add(builder);
            this.triggeredBy.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTriggeredBy(Collection<BuildTriggerCause> items) {
        if (this.triggeredBy == null) {
            this.triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();
        }
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.get("triggeredBy").add(builder);
            this.triggeredBy.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTriggeredBy(BuildTriggerCause ... items) {
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.get("triggeredBy").remove(builder);
            if (this.triggeredBy == null) continue;
            this.triggeredBy.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTriggeredBy(Collection<BuildTriggerCause> items) {
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.get("triggeredBy").remove(builder);
            if (this.triggeredBy == null) continue;
            this.triggeredBy.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
        if (this.triggeredBy == null) {
            return (A)this;
        }
        Iterator<BuildTriggerCauseBuilder> each = this.triggeredBy.iterator();
        Object visitables = this._visitables.get("triggeredBy");
        while (each.hasNext()) {
            BuildTriggerCauseBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BuildTriggerCause> getTriggeredBy() {
        return BuildRequestFluentImpl.build(this.triggeredBy);
    }

    @Override
    public List<BuildTriggerCause> buildTriggeredBy() {
        return BuildRequestFluentImpl.build(this.triggeredBy);
    }

    @Override
    public BuildTriggerCause buildTriggeredBy(Integer index) {
        return this.triggeredBy.get(index).build();
    }

    @Override
    public BuildTriggerCause buildFirstTriggeredBy() {
        return this.triggeredBy.get(0).build();
    }

    @Override
    public BuildTriggerCause buildLastTriggeredBy() {
        return this.triggeredBy.get(this.triggeredBy.size() - 1).build();
    }

    @Override
    public BuildTriggerCause buildMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
        for (BuildTriggerCauseBuilder item : this.triggeredBy) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
        for (BuildTriggerCauseBuilder item : this.triggeredBy) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTriggeredBy(List<BuildTriggerCause> triggeredBy) {
        if (this.triggeredBy != null) {
            this._visitables.get("triggeredBy").removeAll(this.triggeredBy);
        }
        if (triggeredBy != null) {
            this.triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();
            for (BuildTriggerCause item : triggeredBy) {
                this.addToTriggeredBy(item);
            }
        } else {
            this.triggeredBy = null;
        }
        return (A)this;
    }

    @Override
    public A withTriggeredBy(BuildTriggerCause ... triggeredBy) {
        if (this.triggeredBy != null) {
            this.triggeredBy.clear();
        }
        if (triggeredBy != null) {
            for (BuildTriggerCause item : triggeredBy) {
                this.addToTriggeredBy(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTriggeredBy() {
        return this.triggeredBy != null && !this.triggeredBy.isEmpty();
    }

    @Override
    public BuildRequestFluent.TriggeredByNested<A> addNewTriggeredBy() {
        return new TriggeredByNestedImpl();
    }

    @Override
    public BuildRequestFluent.TriggeredByNested<A> addNewTriggeredByLike(BuildTriggerCause item) {
        return new TriggeredByNestedImpl(-1, item);
    }

    @Override
    public BuildRequestFluent.TriggeredByNested<A> setNewTriggeredByLike(Integer index, BuildTriggerCause item) {
        return new TriggeredByNestedImpl(index, item);
    }

    @Override
    public BuildRequestFluent.TriggeredByNested<A> editTriggeredBy(Integer index) {
        if (this.triggeredBy.size() <= index) {
            throw new RuntimeException("Can't edit triggeredBy. Index exceeds size.");
        }
        return this.setNewTriggeredByLike(index, this.buildTriggeredBy(index));
    }

    @Override
    public BuildRequestFluent.TriggeredByNested<A> editFirstTriggeredBy() {
        if (this.triggeredBy.size() == 0) {
            throw new RuntimeException("Can't edit first triggeredBy. The list is empty.");
        }
        return this.setNewTriggeredByLike(0, this.buildTriggeredBy(0));
    }

    @Override
    public BuildRequestFluent.TriggeredByNested<A> editLastTriggeredBy() {
        int index = this.triggeredBy.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last triggeredBy. The list is empty.");
        }
        return this.setNewTriggeredByLike(index, this.buildTriggeredBy(index));
    }

    @Override
    public BuildRequestFluent.TriggeredByNested<A> editMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.triggeredBy.size(); ++i) {
            if (!predicate.test(this.triggeredBy.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching triggeredBy. No match found.");
        }
        return this.setNewTriggeredByLike(index, this.buildTriggeredBy(index));
    }

    @Override
    @Deprecated
    public ObjectReference getTriggeredByImage() {
        return this.triggeredByImage != null ? this.triggeredByImage.build() : null;
    }

    @Override
    public ObjectReference buildTriggeredByImage() {
        return this.triggeredByImage != null ? this.triggeredByImage.build() : null;
    }

    @Override
    public A withTriggeredByImage(ObjectReference triggeredByImage) {
        this._visitables.get("triggeredByImage").remove(this.triggeredByImage);
        if (triggeredByImage != null) {
            this.triggeredByImage = new ObjectReferenceBuilder(triggeredByImage);
            this._visitables.get("triggeredByImage").add(this.triggeredByImage);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTriggeredByImage() {
        return this.triggeredByImage != null;
    }

    @Override
    public BuildRequestFluent.TriggeredByImageNested<A> withNewTriggeredByImage() {
        return new TriggeredByImageNestedImpl();
    }

    @Override
    public BuildRequestFluent.TriggeredByImageNested<A> withNewTriggeredByImageLike(ObjectReference item) {
        return new TriggeredByImageNestedImpl(item);
    }

    @Override
    public BuildRequestFluent.TriggeredByImageNested<A> editTriggeredByImage() {
        return this.withNewTriggeredByImageLike(this.getTriggeredByImage());
    }

    @Override
    public BuildRequestFluent.TriggeredByImageNested<A> editOrNewTriggeredByImage() {
        return this.withNewTriggeredByImageLike(this.getTriggeredByImage() != null ? this.getTriggeredByImage() : new ObjectReferenceBuilder().build());
    }

    @Override
    public BuildRequestFluent.TriggeredByImageNested<A> editOrNewTriggeredByImageLike(ObjectReference item) {
        return this.withNewTriggeredByImageLike(this.getTriggeredByImage() != null ? this.getTriggeredByImage() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildRequestFluentImpl that = (BuildRequestFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.binary != null ? !this.binary.equals(that.binary) : that.binary != null) {
            return false;
        }
        if (this.dockerStrategyOptions != null ? !this.dockerStrategyOptions.equals(that.dockerStrategyOptions) : that.dockerStrategyOptions != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastVersion != null ? !this.lastVersion.equals(that.lastVersion) : that.lastVersion != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.sourceStrategyOptions != null ? !this.sourceStrategyOptions.equals(that.sourceStrategyOptions) : that.sourceStrategyOptions != null) {
            return false;
        }
        if (this.triggeredBy != null ? !this.triggeredBy.equals(that.triggeredBy) : that.triggeredBy != null) {
            return false;
        }
        if (this.triggeredByImage != null ? !this.triggeredByImage.equals(that.triggeredByImage) : that.triggeredByImage != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.binary, this.dockerStrategyOptions, this.env, this.from, this.kind, this.lastVersion, this.metadata, this.revision, this.sourceStrategyOptions, this.triggeredBy, this.triggeredByImage, this.additionalProperties, super.hashCode());
    }

    public class TriggeredByImageNestedImpl<N>
    extends ObjectReferenceFluentImpl<BuildRequestFluent.TriggeredByImageNested<N>>
    implements BuildRequestFluent.TriggeredByImageNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        TriggeredByImageNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        TriggeredByImageNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withTriggeredByImage(this.builder.build());
        }

        @Override
        public N endTriggeredByImage() {
            return this.and();
        }
    }

    public class TriggeredByNestedImpl<N>
    extends BuildTriggerCauseFluentImpl<BuildRequestFluent.TriggeredByNested<N>>
    implements BuildRequestFluent.TriggeredByNested<N>,
    Nested<N> {
        BuildTriggerCauseBuilder builder;
        Integer index;

        TriggeredByNestedImpl(Integer index, BuildTriggerCause item) {
            this.index = index;
            this.builder = new BuildTriggerCauseBuilder(this, item);
        }

        TriggeredByNestedImpl() {
            this.index = -1;
            this.builder = new BuildTriggerCauseBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.setToTriggeredBy(this.index, this.builder.build());
        }

        @Override
        public N endTriggeredBy() {
            return this.and();
        }
    }

    public class SourceStrategyOptionsNestedImpl<N>
    extends SourceStrategyOptionsFluentImpl<BuildRequestFluent.SourceStrategyOptionsNested<N>>
    implements BuildRequestFluent.SourceStrategyOptionsNested<N>,
    Nested<N> {
        SourceStrategyOptionsBuilder builder;

        SourceStrategyOptionsNestedImpl(SourceStrategyOptions item) {
            this.builder = new SourceStrategyOptionsBuilder(this, item);
        }

        SourceStrategyOptionsNestedImpl() {
            this.builder = new SourceStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withSourceStrategyOptions(this.builder.build());
        }

        @Override
        public N endSourceStrategyOptions() {
            return this.and();
        }
    }

    public class RevisionNestedImpl<N>
    extends SourceRevisionFluentImpl<BuildRequestFluent.RevisionNested<N>>
    implements BuildRequestFluent.RevisionNested<N>,
    Nested<N> {
        SourceRevisionBuilder builder;

        RevisionNestedImpl(SourceRevision item) {
            this.builder = new SourceRevisionBuilder(this, item);
        }

        RevisionNestedImpl() {
            this.builder = new SourceRevisionBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withRevision(this.builder.build());
        }

        @Override
        public N endRevision() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<BuildRequestFluent.MetadataNested<N>>
    implements BuildRequestFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<BuildRequestFluent.FromNested<N>>
    implements BuildRequestFluent.FromNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withFrom(this.builder.build());
        }

        @Override
        public N endFrom() {
            return this.and();
        }
    }

    public class DockerStrategyOptionsNestedImpl<N>
    extends DockerStrategyOptionsFluentImpl<BuildRequestFluent.DockerStrategyOptionsNested<N>>
    implements BuildRequestFluent.DockerStrategyOptionsNested<N>,
    Nested<N> {
        DockerStrategyOptionsBuilder builder;

        DockerStrategyOptionsNestedImpl(DockerStrategyOptions item) {
            this.builder = new DockerStrategyOptionsBuilder(this, item);
        }

        DockerStrategyOptionsNestedImpl() {
            this.builder = new DockerStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withDockerStrategyOptions(this.builder.build());
        }

        @Override
        public N endDockerStrategyOptions() {
            return this.and();
        }
    }

    public class BinaryNestedImpl<N>
    extends BinaryBuildSourceFluentImpl<BuildRequestFluent.BinaryNested<N>>
    implements BuildRequestFluent.BinaryNested<N>,
    Nested<N> {
        BinaryBuildSourceBuilder builder;

        BinaryNestedImpl(BinaryBuildSource item) {
            this.builder = new BinaryBuildSourceBuilder(this, item);
        }

        BinaryNestedImpl() {
            this.builder = new BinaryBuildSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildRequestFluentImpl.this.withBinary(this.builder.build());
        }

        @Override
        public N endBinary() {
            return this.and();
        }
    }
}

