/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_11.extended.leaderelection.resourcelock;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Objects;

public class LeaderElectionRecord {
    private final String holderIdentity;
    private final Duration leaseDuration;
    @JsonFormat(timezone="UTC", pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
    private final ZonedDateTime acquireTime;
    @JsonFormat(timezone="UTC", pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
    private final ZonedDateTime renewTime;
    private final int leaderTransitions;
    @JsonIgnore
    private transient Serializable version;

    @JsonCreator
    public LeaderElectionRecord(@JsonProperty(value="holderIdentity") String holderIdentity, @JsonProperty(value="leaseDuration") Duration leaseDuration, @JsonProperty(value="acquireTime") ZonedDateTime acquireTime, @JsonProperty(value="renewTime") ZonedDateTime renewTime, @JsonProperty(value="leaderTransitions") int leaderTransitions) {
        this.holderIdentity = Objects.requireNonNull(holderIdentity, "holderIdentity is required");
        this.leaseDuration = Objects.requireNonNull(leaseDuration, "leaseDuration is required");
        this.acquireTime = Objects.requireNonNull(acquireTime, "acquireTime is required");
        this.renewTime = Objects.requireNonNull(renewTime, "renewTime is required");
        this.leaderTransitions = leaderTransitions;
    }

    public String getHolderIdentity() {
        return this.holderIdentity;
    }

    public Duration getLeaseDuration() {
        return this.leaseDuration;
    }

    public ZonedDateTime getAcquireTime() {
        return this.acquireTime;
    }

    public ZonedDateTime getRenewTime() {
        return this.renewTime;
    }

    public int getLeaderTransitions() {
        return this.leaderTransitions;
    }

    public Serializable getVersion() {
        return this.version;
    }

    public void setVersion(Serializable version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeaderElectionRecord that = (LeaderElectionRecord)o;
        return this.leaderTransitions == that.leaderTransitions && Objects.equals(this.holderIdentity, that.holderIdentity) && Objects.equals(this.leaseDuration, that.leaseDuration) && Objects.equals(this.acquireTime, that.acquireTime) && Objects.equals(this.renewTime, that.renewTime) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.holderIdentity, this.leaseDuration, this.acquireTime, this.renewTime, this.leaderTransitions, this.version);
    }
}

