/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_11.dsl.base;

import io.fabric8.kubernetes.api.builder.v5_11.TypedVisitor;
import io.fabric8.kubernetes.api.builder.v5_11.Visitor;
import io.fabric8.kubernetes.api.model.v5_11.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_11.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_11.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_11.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_11.ListOptions;
import io.fabric8.kubernetes.api.model.v5_11.ListOptionsBuilder;
import io.fabric8.kubernetes.api.model.v5_11.ObjectReference;
import io.fabric8.kubernetes.api.model.v5_11.Status;
import io.fabric8.kubernetes.api.model.v5_11.autoscaling.v1.Scale;
import io.fabric8.kubernetes.api.model.v5_11.extensions.DeploymentRollback;
import io.fabric8.kubernetes.clnt.v5_11.Config;
import io.fabric8.kubernetes.clnt.v5_11.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v5_11.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_11.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.clnt.v5_11.OperationInfo;
import io.fabric8.kubernetes.clnt.v5_11.ResourceNotFoundException;
import io.fabric8.kubernetes.clnt.v5_11.Watch;
import io.fabric8.kubernetes.clnt.v5_11.Watcher;
import io.fabric8.kubernetes.clnt.v5_11.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.FilterNested;
import io.fabric8.kubernetes.clnt.v5_11.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Informable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.ReplaceDeletable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_11.dsl.WritableOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.base.CreateOnlyResourceOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.base.FilterNestedImpl;
import io.fabric8.kubernetes.clnt.v5_11.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_11.dsl.base.PatchContext;
import io.fabric8.kubernetes.clnt.v5_11.dsl.internal.DefaultOperationInfo;
import io.fabric8.kubernetes.clnt.v5_11.dsl.internal.WatchConnectionManager;
import io.fabric8.kubernetes.clnt.v5_11.dsl.internal.WatchHTTPManager;
import io.fabric8.kubernetes.clnt.v5_11.http.HttpRequest;
import io.fabric8.kubernetes.clnt.v5_11.informers.ListerWatcher;
import io.fabric8.kubernetes.clnt.v5_11.informers.ResourceEventHandler;
import io.fabric8.kubernetes.clnt.v5_11.informers.SharedIndexInformer;
import io.fabric8.kubernetes.clnt.v5_11.informers.impl.DefaultSharedIndexInformer;
import io.fabric8.kubernetes.clnt.v5_11.internal.readiness.Readiness;
import io.fabric8.kubernetes.clnt.v5_11.utils.CreateOrReplaceHelper;
import io.fabric8.kubernetes.clnt.v5_11.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v5_11.utils.Utils;
import io.fabric8.kubernetes.clnt.v5_11.utils.WatcherToggle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class BaseOperation<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
extends CreateOnlyResourceOperation<T, T>
implements OperationInfo,
MixedOperation<T, L, R>,
Resource<T>,
ListerWatcher<T, L> {
    private static final String WATCH = "watch";
    private static final String READ_ONLY_UPDATE_EXCEPTION_MESSAGE = "Cannot update read-only resources";
    private static final String READ_ONLY_EDIT_EXCEPTION_MESSAGE = "Cannot edit read-only resources";
    private final boolean cascading;
    private final T item;
    private final String resourceVersion;
    private final boolean reloadingFromServer;
    private final long gracePeriodSeconds;
    private final DeletionPropagation propagationPolicy;
    protected String apiVersion;
    protected Class<L> listType;
    private Map<String, Function<T, List<String>>> indexers;

    protected BaseOperation(OperationContext ctx) {
        super(ctx);
        this.cascading = ctx.getCascading();
        this.item = (HasMetadata)ctx.getItem();
        this.reloadingFromServer = ctx.isReloadingFromServer();
        this.resourceVersion = ctx.getResourceVersion();
        this.gracePeriodSeconds = ctx.getGracePeriodSeconds();
        this.propagationPolicy = ctx.getPropagationPolicy();
    }

    public BaseOperation<T, L, R> newInstance(OperationContext context) {
        return new BaseOperation<T, L, R>(context);
    }

    private L listRequestHelper(URL url) {
        try {
            HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().url(url);
            KubernetesResourceList answer = (KubernetesResourceList)this.handleResponse(requestBuilder, this.listType);
            this.updateApiVersion(answer);
            return (L)answer;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("list"), (Throwable)ie);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("list"), (Throwable)e);
        }
    }

    protected URL fetchListUrl(URL url, ListOptions listOptions) {
        return BaseOperation.appendListOptionParams(url, listOptions);
    }

    @Override
    public T get() {
        try {
            T answer = this.getMandatory();
            this.updateApiVersion((HasMetadata)answer);
            return answer;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
    }

    @Override
    public T require() {
        try {
            T answer = this.getMandatory();
            if (answer == null) {
                throw new ResourceNotFoundException("The resource you request doesn't exist or couldn't be fetched.");
            }
            return answer;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            throw new ResourceNotFoundException("Resource not found : " + e.getMessage(), e);
        }
    }

    public T getMandatory() {
        if (this.item != null && !this.reloadingFromServer) {
            return this.item;
        }
        try {
            URL requestUrl = this.getCompleteResourceUrl();
            return this.handleGet(requestUrl);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("get"), (Throwable)ie);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("get"), (Throwable)e);
        }
    }

    @Override
    public T edit(UnaryOperator<T> function) {
        throw new KubernetesClientException(READ_ONLY_EDIT_EXCEPTION_MESSAGE);
    }

    @Override
    public T editStatus(UnaryOperator<T> function) {
        throw new KubernetesClientException(READ_ONLY_EDIT_EXCEPTION_MESSAGE);
    }

    @Override
    public T edit(Visitor ... visitors) {
        throw new KubernetesClientException(READ_ONLY_EDIT_EXCEPTION_MESSAGE);
    }

    @Override
    public <V> T edit(final Class<V> visitorType, final Visitor<V> visitor) {
        return (T)this.edit(new Visitor[]{new TypedVisitor<V>(){

            @Override
            public Class<V> getType() {
                return visitorType;
            }

            @Override
            public void visit(V item) {
                visitor.visit(item);
            }
        }});
    }

    @Override
    public T accept(Consumer<T> consumer) {
        throw new KubernetesClientException(READ_ONLY_EDIT_EXCEPTION_MESSAGE);
    }

    @Override
    public R withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        return (R)this.newInstance(this.context.withName(name));
    }

    @Override
    public ReplaceDeletable<T> lockResourceVersion(String resourceVersion) {
        return this.newInstance(this.context.withResourceVersion(resourceVersion));
    }

    @Override
    public NonNamespaceOperation<T, L, R> inNamespace(String namespace) {
        return this.newInstance(this.context.withNamespace(namespace));
    }

    @Override
    public NonNamespaceOperation<T, L, R> inAnyNamespace() {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.config).withNamespace(null)).build();
        return this.newInstance(this.context.withConfig(updated).withNamespace(null));
    }

    @Override
    public EditReplacePatchDeletable<T> cascading(boolean cascading) {
        return this.newInstance(this.context.withCascading(cascading).withPropagationPolicy(null));
    }

    @Override
    public R load(InputStream is) {
        return (R)this.newInstance(this.context.withItem(BaseOperation.unmarshal(is, this.type)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R load(URL url) {
        try (InputStream inputStream = url.openStream();){
            Object object = this.load(inputStream);
            return (R)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R load(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            Object object = this.load(fis);
            return (R)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public R load(String path) {
        return (R)this.load(new File(path));
    }

    @Override
    public Gettable<T> fromServer() {
        return this.newInstance(this.context.withReloadingFromServer(true));
    }

    @Override
    @SafeVarargs
    public final T createOrReplace(T ... items) {
        Object itemToCreateOrReplace = this.getItem();
        if (items.length > 1) {
            throw new IllegalArgumentException("Too many items to create.");
        }
        if (items.length == 1) {
            itemToCreateOrReplace = items[0];
        }
        if (itemToCreateOrReplace == null) {
            throw new IllegalArgumentException("Nothing to create.");
        }
        if (Utils.isNullOrEmpty(this.name)) {
            return (T)this.withName(itemToCreateOrReplace.getMetadata().getName()).createOrReplace(itemToCreateOrReplace);
        }
        Object finalItemToCreateOrReplace = itemToCreateOrReplace;
        CreateOrReplaceHelper<Object> createOrReplaceHelper = new CreateOrReplaceHelper<Object>(this::create, this::replace, m -> this.waitUntilCondition(Objects::nonNull, 1L, TimeUnit.SECONDS), m -> (HasMetadata)this.fromServer().get());
        return (T)createOrReplaceHelper.createOrReplace(finalItemToCreateOrReplace);
    }

    @Override
    public FilterWatchListDeletable<T, L> withLabels(Map<String, String> labels) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withLabels(labels)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withLabelSelector(LabelSelector selector) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withLabelSelector(selector)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withoutLabels(Map<String, String> labels) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withoutLabels(labels)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withLabelIn(String key, String ... values) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withLabelIn(key, values)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withLabelNotIn(String key, String ... values) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withLabelNotIn(key, values)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withLabel(String key, String value) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withLabel(key, value)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withoutLabel(String key, String value) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withoutLabel(key, value)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withLabelSelector(String selectorAsString) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withLabelSelector(selectorAsString)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withFields(Map<String, String> fields) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withFields(fields)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withField(String key, String value) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withField(key, value)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withInvolvedObject(ObjectReference objectReference) {
        if (objectReference != null) {
            return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withInvolvedObject(objectReference)).endFilter();
        }
        return this;
    }

    @Override
    public FilterNested<FilterWatchListDeletable<T, L>> withNewFilter() {
        return new FilterNestedImpl(this);
    }

    @Override
    public FilterWatchListDeletable<T, L> withoutFields(Map<String, String> fields) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withoutFields(fields)).endFilter();
    }

    @Override
    public FilterWatchListDeletable<T, L> withoutField(String key, String value) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withoutField(key, value)).endFilter();
    }

    public String getFieldQueryParam() {
        return this.context.getFieldQueryParam();
    }

    public String getLabelQueryParam() {
        return this.context.getLabelQueryParam();
    }

    @Override
    public L list() {
        return (L)this.list(new ListOptions());
    }

    @Override
    public L list(Integer limitVal, String continueVal) {
        return (L)this.list(((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.parseLong(limitVal.toString()))).withContinue(continueVal)).build());
    }

    @Override
    public L list(ListOptions listOptions) {
        try {
            return this.listRequestHelper(this.fetchListUrl(this.getNamespacedUrl(), this.defaultListOptions(listOptions, null)));
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("list"), (Throwable)e);
        }
    }

    private ListOptions defaultListOptions(ListOptions options, Boolean watch) {
        String labelQueryParam;
        options.setWatch(watch);
        String fieldQueryParam = this.context.getFieldQueryParam();
        if (fieldQueryParam != null) {
            options.setFieldSelector(fieldQueryParam);
        }
        if ((labelQueryParam = this.context.getLabelQueryParam()) != null) {
            options.setLabelSelector(labelQueryParam);
        }
        if (this.resourceVersion != null) {
            options.setResourceVersion(this.resourceVersion);
        }
        return options;
    }

    @Override
    public Boolean delete() {
        if (this.item != null || this.name != null && !this.name.isEmpty()) {
            try {
                this.deleteThis();
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getCode() != 404) {
                    throw e;
                }
                return false;
            }
        }
        try {
            this.deleteList();
            return true;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return false;
        }
    }

    @Override
    @SafeVarargs
    public final Boolean delete(T ... items) {
        return this.delete(Arrays.asList(items));
    }

    @Override
    public Boolean delete(List<T> items) {
        boolean deleted = true;
        if (items != null) {
            for (HasMetadata toDelete : items) {
                if (toDelete == null) continue;
                this.updateApiVersion(toDelete);
                try {
                    if (toDelete.getMetadata() != null && toDelete.getMetadata().getName() != null && !toDelete.getMetadata().getName().isEmpty()) {
                        deleted &= ((Resource)this.inNamespace(this.checkNamespace(toDelete)).withName(toDelete.getMetadata().getName())).delete().booleanValue();
                        continue;
                    }
                    deleted &= this.withItem(toDelete).delete().booleanValue();
                }
                catch (KubernetesClientException e) {
                    if (e.getCode() != 404) {
                        throw e;
                    }
                    return false;
                }
            }
        }
        return deleted;
    }

    @Override
    public T updateStatus(T item) {
        try {
            return this.handleUpdate(item, true);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("statusUpdate"), (Throwable)ie);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("statusUpdate"), (Throwable)e);
        }
    }

    @Override
    public T patchStatus(T item) {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    public BaseOperation<T, L, R> withItem(T item) {
        return this.newInstance(this.context.withItem(item));
    }

    void deleteThis() {
        try {
            if (this.item != null) {
                this.updateApiVersion((HasMetadata)this.item);
                this.handleDelete(this.item, this.gracePeriodSeconds, this.propagationPolicy, this.resourceVersion, this.cascading);
            } else {
                this.handleDelete(this.getResourceURLForWriteOperation(this.getResourceUrl()), this.gracePeriodSeconds, this.propagationPolicy, this.resourceVersion, this.cascading);
            }
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("delete"), (Throwable)e);
        }
    }

    void deleteList() {
        this.delete(this.list().getItems());
    }

    @Override
    public BaseOperation<T, L, R> withResourceVersion(String resourceVersion) {
        return this.newInstance(this.context.withResourceVersion(resourceVersion));
    }

    @Override
    public Watch watch(Watcher<T> watcher) {
        return this.watch(new ListOptions(), watcher);
    }

    @Override
    public Watch watch(String resourceVersion, Watcher<T> watcher) {
        return this.watch(((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion(resourceVersion)).build(), watcher);
    }

    @Override
    public Watch watch(ListOptions options, Watcher<T> watcher) {
        WatcherToggle<T> watcherToggle = new WatcherToggle<T>(watcher, true);
        options = this.defaultListOptions(options, true);
        WatchConnectionManager watch = null;
        try {
            watch = new WatchConnectionManager(this.httpClient, this, options, watcherToggle, this.config.getWatchReconnectInterval(), this.config.getWatchReconnectLimit(), this.config.getWebsocketTimeout());
            watch.waitUntilReady();
            return watch;
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType(WATCH), (Throwable)e);
        }
        catch (KubernetesClientException ke) {
            List<Integer> furtherProcessedCodes = Arrays.asList(200, 503);
            if (!furtherProcessedCodes.contains(ke.getCode())) {
                if (watch != null) {
                    watch.close();
                }
                throw ke;
            }
            if (watch != null) {
                watcherToggle.disable();
                watch.close();
            }
            try {
                return new WatchHTTPManager(this.httpClient, this, options, watcher, this.config.getWatchReconnectInterval(), this.config.getWatchReconnectLimit(), this.config.getConnectionTimeout());
            }
            catch (MalformedURLException e) {
                throw KubernetesClientException.launderThrowable(this.forOperationType(WATCH), (Throwable)e);
            }
        }
    }

    @Override
    public T replace(T item) {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    @Override
    public T replaceStatus(T item) {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    @Override
    public T patch(PatchContext patchContext, String patch) {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    @Override
    public T patch(PatchContext patchContext, T item) {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    @Override
    public boolean isResourceNamespaced() {
        return Utils.isResourceNamespaced(this.getType());
    }

    protected T handleResponse(HttpRequest.Builder requestBuilder) throws InterruptedException, IOException {
        return (T)((HasMetadata)this.handleResponse(requestBuilder, this.getType()));
    }

    @Override
    protected T handleCreate(T resource) throws InterruptedException, IOException {
        this.updateApiVersion((HasMetadata)resource);
        return (T)((HasMetadata)this.handleCreate(resource, this.getType()));
    }

    protected T handleUpdate(T updated, boolean status) throws InterruptedException, IOException {
        this.updateApiVersion((HasMetadata)updated);
        return (T)((HasMetadata)this.handleUpdate(updated, this.getType(), status));
    }

    protected T handlePatch(PatchContext context, T current, T updated, boolean status) throws InterruptedException, IOException {
        this.updateApiVersion((HasMetadata)updated);
        return (T)((HasMetadata)this.handlePatch(context, current, updated, this.getType(), status));
    }

    protected T handlePatch(T current, Map<String, Object> patchedUpdate) throws InterruptedException, IOException {
        this.updateApiVersion((HasMetadata)current);
        return (T)((HasMetadata)this.handlePatch(current, patchedUpdate, this.getType()));
    }

    protected T sendPatchedObject(T oldObject, T updatedObject) {
        try {
            return this.handlePatch(null, oldObject, updatedObject, false);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(interruptedException);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    protected Scale handleScale(Scale scaleParam) {
        try {
            return this.handleScale(this.getCompleteResourceUrl().toString(), scaleParam);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("scale"), (Throwable)ie);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("scale"), (Throwable)e);
        }
    }

    protected Status handleDeploymentRollback(DeploymentRollback deploymentRollback) {
        try {
            return this.handleDeploymentRollback(this.getCompleteResourceUrl().toString(), deploymentRollback);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("rollback"), (Throwable)ie);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("rollback"), (Throwable)e);
        }
    }

    protected T handleGet(URL resourceUrl) throws InterruptedException, IOException {
        HasMetadata answer = (HasMetadata)this.handleGet(resourceUrl, this.getType());
        this.updateApiVersion(answer);
        return (T)answer;
    }

    private URL getCompleteResourceUrl() throws MalformedURLException {
        URL requestUrl = null;
        requestUrl = this.item != null ? this.getNamespacedUrl(this.item) : this.getNamespacedUrl();
        if (this.name != null) {
            requestUrl = new URL(URLUtils.join(requestUrl.toString(), this.name));
        } else if (this.item != null && this.reloadingFromServer) {
            requestUrl = new URL(URLUtils.join(requestUrl.toString(), this.checkName(this.item)));
        }
        return requestUrl;
    }

    public Boolean isCascading() {
        return this.cascading;
    }

    @Override
    public T getItem() {
        return this.item;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public Boolean isReloadingFromServer() {
        return this.reloadingFromServer;
    }

    public Long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    public DeletionPropagation getPropagationPolicy() {
        return this.propagationPolicy;
    }

    public Class<L> getListType() {
        return this.listType;
    }

    @Override
    public String getKind() {
        return this.type != null ? HasMetadata.getKind(this.type) : "Resource";
    }

    @Override
    public String getGroup() {
        return this.getAPIGroupName();
    }

    @Override
    public String getPlural() {
        return this.getResourceT();
    }

    @Override
    public String getVersion() {
        return this.getAPIGroupVersion();
    }

    @Override
    public String getOperationType() {
        return null;
    }

    @Override
    public OperationInfo forOperationType(String type) {
        return new DefaultOperationInfo(this.getKind(), type, this.name, this.namespace, this.getGroup(), this.getPlural(), this.getVersion());
    }

    @Override
    public FilterWatchListDeletable<T, L> withGracePeriod(long gracePeriodSeconds) {
        return this.newInstance(this.context.withGracePeriodSeconds(gracePeriodSeconds));
    }

    @Override
    public EditReplacePatchDeletable<T> withPropagationPolicy(DeletionPropagation propagationPolicy) {
        return this.newInstance(this.context.withPropagationPolicy(propagationPolicy));
    }

    public BaseOperation<T, L, R> withWaitRetryBackoff(long initialBackoff, TimeUnit backoffUnit, double backoffMultiplier) {
        return this;
    }

    protected Class<? extends Config> getConfigType() {
        return Config.class;
    }

    protected void updateApiVersion(KubernetesResourceList<T> list) {
        String version = this.apiVersion;
        if (list != null && version != null && version.length() > 0 && list.getItems() != null) {
            list.getItems().forEach(this::updateApiVersion);
        }
    }

    protected void updateApiVersion(HasMetadata hasMetadata) {
        String current;
        String version = this.apiVersion;
        if (hasMetadata != null && version != null && version.length() > 0 && ((current = hasMetadata.getApiVersion()) == null || "v1".equals(current) || current.indexOf(47) < 0 && version.indexOf(47) > 0)) {
            hasMetadata.setApiVersion(version);
        }
    }

    public Readiness getReadiness() {
        return this.config.getReadiness();
    }

    @Override
    public final boolean isReady() {
        HasMetadata item = (HasMetadata)this.fromServer().get();
        if (item == null) {
            return false;
        }
        return this.getReadiness().isReady(item);
    }

    @Override
    public T waitUntilReady(long amount, TimeUnit timeUnit) {
        return (T)this.waitUntilCondition(resource -> Objects.nonNull(resource) && this.getReadiness().isReady((HasMetadata)resource), amount, timeUnit);
    }

    @Override
    public T waitUntilCondition(Predicate<T> condition, long amount, TimeUnit timeUnit) {
        CompletableFuture<List<T>> futureCondition = this.informOnCondition(l -> {
            if (l.isEmpty()) {
                return condition.test(null);
            }
            return condition.test(l.get(0));
        });
        if (!Utils.waitUntilReady(futureCondition, amount, timeUnit)) {
            futureCondition.cancel(true);
            Object i = this.getItem();
            if (i != null) {
                throw new KubernetesClientTimeoutException((HasMetadata)i, amount, timeUnit);
            }
            throw new KubernetesClientTimeoutException(this.getKind(), this.getName(), this.getNamespace(), amount, timeUnit);
        }
        return (T)((HasMetadata)((CompletableFuture)futureCondition.thenApply(l -> l.isEmpty() ? null : (HasMetadata)l.get(0))).getNow(null));
    }

    @Override
    public CompletableFuture<List<T>> informOnCondition(Predicate<List<T>> condition) {
        CompletableFuture future = new CompletableFuture();
        AtomicReference<Runnable> tester = new AtomicReference<Runnable>();
        DefaultSharedIndexInformer informer = this.createInformer(0L);
        future.whenComplete((r, t) -> informer.stop());
        final Runnable test = () -> {
            try {
                List list = informer.getStore().list();
                if (condition.test(list)) {
                    future.complete(list);
                }
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        };
        tester.set(test);
        informer.addEventHandler(new ResourceEventHandler<T>(){

            @Override
            public void onAdd(T obj) {
                test.run();
            }

            @Override
            public void onDelete(T obj, boolean deletedFinalStateUnknown) {
                test.run();
            }

            @Override
            public void onUpdate(T oldObj, T newObj) {
                test.run();
            }

            @Override
            public void onNothing() {
                test.run();
            }
        });
        informer.run();
        return future;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public void setListType(Class<L> listType) {
        this.listType = listType;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public WritableOperation<T> dryRun(boolean isDryRun) {
        return this.newInstance(this.context.withDryRun(isDryRun));
    }

    @Override
    public Informable<T> withIndexers(Map<String, Function<T, List<String>>> indexers) {
        BaseOperation<T, L, R> result = this.newInstance(this.context);
        result.indexers = indexers;
        return result;
    }

    @Override
    public SharedIndexInformer<T> inform(ResourceEventHandler<? super T> handler, long resync) {
        DefaultSharedIndexInformer<? super T, L> result = this.createInformer(resync);
        if (handler != null) {
            result.addEventHandler(handler);
        }
        result.run();
        return result;
    }

    @Override
    public SharedIndexInformer<T> runnableInformer(long resync) {
        return this.createInformer(resync);
    }

    private DefaultSharedIndexInformer<T, L> createInformer(long resync) {
        Object i = this.getItem();
        if (Utils.isNotNullOrEmpty(this.getName()) && i != null) {
            this.checkName(i);
        }
        DefaultSharedIndexInformer informer = new DefaultSharedIndexInformer(this.getType(), this.withResourceVersion(null), resync, Runnable::run);
        if (this.indexers != null) {
            informer.addIndexers(this.indexers);
        }
        return informer;
    }

    public static URL appendListOptionParams(URL base, ListOptions listOptions) {
        if (listOptions == null) {
            return base;
        }
        URLUtils.URLBuilder urlBuilder = new URLUtils.URLBuilder(base);
        if (listOptions.getLimit() != null) {
            urlBuilder.addQueryParameter("limit", listOptions.getLimit().toString());
        }
        if (listOptions.getContinue() != null) {
            urlBuilder.addQueryParameter("continue", listOptions.getContinue());
        }
        if (listOptions.getFieldSelector() != null) {
            urlBuilder.addQueryParameter("fieldSelector", listOptions.getFieldSelector());
        }
        if (listOptions.getLabelSelector() != null) {
            urlBuilder.addQueryParameter("labelSelector", listOptions.getLabelSelector());
        }
        if (listOptions.getResourceVersion() != null) {
            urlBuilder.addQueryParameter("resourceVersion", listOptions.getResourceVersion());
        }
        if (listOptions.getTimeoutSeconds() != null) {
            urlBuilder.addQueryParameter("timeoutSeconds", listOptions.getTimeoutSeconds().toString());
        }
        if (listOptions.getAllowWatchBookmarks() != null) {
            urlBuilder.addQueryParameter("allowWatchBookmarks", listOptions.getAllowWatchBookmarks().toString());
        }
        if (listOptions.getWatch() != null) {
            urlBuilder.addQueryParameter(WATCH, listOptions.getWatch().toString());
        }
        return urlBuilder.build();
    }
}

