/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_11;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.kubernetes.api.model.v5_11.StatusCause;
import io.fabric8.kubernetes.api.model.v5_11.StatusCauseBuilder;
import io.fabric8.kubernetes.api.model.v5_11.StatusCauseFluentImpl;
import io.fabric8.kubernetes.api.model.v5_11.StatusDetails;
import io.fabric8.kubernetes.api.model.v5_11.StatusDetailsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class StatusDetailsFluentImpl<A extends StatusDetailsFluent<A>>
extends BaseFluent<A>
implements StatusDetailsFluent<A> {
    private List<StatusCauseBuilder> causes = new ArrayList<StatusCauseBuilder>();
    private String group;
    private String kind;
    private String name;
    private Integer retryAfterSeconds;
    private String uid;
    private Map<String, Object> additionalProperties;

    public StatusDetailsFluentImpl() {
    }

    public StatusDetailsFluentImpl(StatusDetails instance) {
        this.withCauses(instance.getCauses());
        this.withGroup(instance.getGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withRetryAfterSeconds(instance.getRetryAfterSeconds());
        this.withUid(instance.getUid());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToCauses(Integer index, StatusCause item) {
        if (this.causes == null) {
            this.causes = new ArrayList<StatusCauseBuilder>();
        }
        StatusCauseBuilder builder = new StatusCauseBuilder(item);
        this._visitables.get("causes").add(index >= 0 ? index.intValue() : this._visitables.get("causes").size(), builder);
        this.causes.add(index >= 0 ? index.intValue() : this.causes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToCauses(Integer index, StatusCause item) {
        if (this.causes == null) {
            this.causes = new ArrayList<StatusCauseBuilder>();
        }
        StatusCauseBuilder builder = new StatusCauseBuilder(item);
        if (index < 0 || index >= this._visitables.get("causes").size()) {
            this._visitables.get("causes").add(builder);
        } else {
            this._visitables.get("causes").set(index, builder);
        }
        if (index < 0 || index >= this.causes.size()) {
            this.causes.add(builder);
        } else {
            this.causes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToCauses(StatusCause ... items) {
        if (this.causes == null) {
            this.causes = new ArrayList<StatusCauseBuilder>();
        }
        for (StatusCause item : items) {
            StatusCauseBuilder builder = new StatusCauseBuilder(item);
            this._visitables.get("causes").add(builder);
            this.causes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToCauses(Collection<StatusCause> items) {
        if (this.causes == null) {
            this.causes = new ArrayList<StatusCauseBuilder>();
        }
        for (StatusCause item : items) {
            StatusCauseBuilder builder = new StatusCauseBuilder(item);
            this._visitables.get("causes").add(builder);
            this.causes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromCauses(StatusCause ... items) {
        for (StatusCause item : items) {
            StatusCauseBuilder builder = new StatusCauseBuilder(item);
            this._visitables.get("causes").remove(builder);
            if (this.causes == null) continue;
            this.causes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCauses(Collection<StatusCause> items) {
        for (StatusCause item : items) {
            StatusCauseBuilder builder = new StatusCauseBuilder(item);
            this._visitables.get("causes").remove(builder);
            if (this.causes == null) continue;
            this.causes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromCauses(Predicate<StatusCauseBuilder> predicate) {
        if (this.causes == null) {
            return (A)this;
        }
        Iterator<StatusCauseBuilder> each = this.causes.iterator();
        Object visitables = this._visitables.get("causes");
        while (each.hasNext()) {
            StatusCauseBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<StatusCause> getCauses() {
        return StatusDetailsFluentImpl.build(this.causes);
    }

    @Override
    public List<StatusCause> buildCauses() {
        return StatusDetailsFluentImpl.build(this.causes);
    }

    @Override
    public StatusCause buildCause(Integer index) {
        return this.causes.get(index).build();
    }

    @Override
    public StatusCause buildFirstCause() {
        return this.causes.get(0).build();
    }

    @Override
    public StatusCause buildLastCause() {
        return this.causes.get(this.causes.size() - 1).build();
    }

    @Override
    public StatusCause buildMatchingCause(Predicate<StatusCauseBuilder> predicate) {
        for (StatusCauseBuilder item : this.causes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCause(Predicate<StatusCauseBuilder> predicate) {
        for (StatusCauseBuilder item : this.causes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCauses(List<StatusCause> causes) {
        if (this.causes != null) {
            this._visitables.get("causes").removeAll(this.causes);
        }
        if (causes != null) {
            this.causes = new ArrayList<StatusCauseBuilder>();
            for (StatusCause item : causes) {
                this.addToCauses(item);
            }
        } else {
            this.causes = null;
        }
        return (A)this;
    }

    @Override
    public A withCauses(StatusCause ... causes) {
        if (this.causes != null) {
            this.causes.clear();
        }
        if (causes != null) {
            for (StatusCause item : causes) {
                this.addToCauses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCauses() {
        return this.causes != null && !this.causes.isEmpty();
    }

    @Override
    public A addNewCause(String field, String message, String reason) {
        return this.addToCauses(new StatusCause(field, message, reason));
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> addNewCause() {
        return new CausesNestedImpl();
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> addNewCauseLike(StatusCause item) {
        return new CausesNestedImpl(-1, item);
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> setNewCauseLike(Integer index, StatusCause item) {
        return new CausesNestedImpl(index, item);
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> editCause(Integer index) {
        if (this.causes.size() <= index) {
            throw new RuntimeException("Can't edit causes. Index exceeds size.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> editFirstCause() {
        if (this.causes.size() == 0) {
            throw new RuntimeException("Can't edit first causes. The list is empty.");
        }
        return this.setNewCauseLike(0, this.buildCause(0));
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> editLastCause() {
        int index = this.causes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last causes. The list is empty.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> editMatchingCause(Predicate<StatusCauseBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.causes.size(); ++i) {
            if (!predicate.test(this.causes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching causes. No match found.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null;
    }

    @Override
    @Deprecated
    public A withNewGroup(String arg0) {
        return this.withGroup(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    public Integer getRetryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    @Override
    public A withRetryAfterSeconds(Integer retryAfterSeconds) {
        this.retryAfterSeconds = retryAfterSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasRetryAfterSeconds() {
        return this.retryAfterSeconds != null;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    @Override
    public Boolean hasUid() {
        return this.uid != null;
    }

    @Override
    @Deprecated
    public A withNewUid(String arg0) {
        return this.withUid(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusDetailsFluentImpl that = (StatusDetailsFluentImpl)o;
        if (this.causes != null ? !this.causes.equals(that.causes) : that.causes != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.retryAfterSeconds != null ? !this.retryAfterSeconds.equals(that.retryAfterSeconds) : that.retryAfterSeconds != null) {
            return false;
        }
        if (this.uid != null ? !this.uid.equals(that.uid) : that.uid != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.causes, this.group, this.kind, this.name, this.retryAfterSeconds, this.uid, this.additionalProperties, super.hashCode());
    }

    public class CausesNestedImpl<N>
    extends StatusCauseFluentImpl<StatusDetailsFluent.CausesNested<N>>
    implements StatusDetailsFluent.CausesNested<N>,
    Nested<N> {
        StatusCauseBuilder builder;
        Integer index;

        CausesNestedImpl(Integer index, StatusCause item) {
            this.index = index;
            this.builder = new StatusCauseBuilder(this, item);
        }

        CausesNestedImpl() {
            this.index = -1;
            this.builder = new StatusCauseBuilder(this);
        }

        @Override
        public N and() {
            return (N)StatusDetailsFluentImpl.this.setToCauses(this.index, this.builder.build());
        }

        @Override
        public N endCause() {
            return this.and();
        }
    }
}

