/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_11;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.kubernetes.api.model.v5_11.LoadBalancerIngress;
import io.fabric8.kubernetes.api.model.v5_11.LoadBalancerIngressBuilder;
import io.fabric8.kubernetes.api.model.v5_11.LoadBalancerIngressFluentImpl;
import io.fabric8.kubernetes.api.model.v5_11.LoadBalancerStatus;
import io.fabric8.kubernetes.api.model.v5_11.LoadBalancerStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class LoadBalancerStatusFluentImpl<A extends LoadBalancerStatusFluent<A>>
extends BaseFluent<A>
implements LoadBalancerStatusFluent<A> {
    private List<LoadBalancerIngressBuilder> ingress = new ArrayList<LoadBalancerIngressBuilder>();
    private Map<String, Object> additionalProperties;

    public LoadBalancerStatusFluentImpl() {
    }

    public LoadBalancerStatusFluentImpl(LoadBalancerStatus instance) {
        this.withIngress(instance.getIngress());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToIngress(Integer index, LoadBalancerIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<LoadBalancerIngressBuilder>();
        }
        LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);
        this._visitables.get("ingress").add(index >= 0 ? index.intValue() : this._visitables.get("ingress").size(), builder);
        this.ingress.add(index >= 0 ? index.intValue() : this.ingress.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIngress(Integer index, LoadBalancerIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<LoadBalancerIngressBuilder>();
        }
        LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);
        if (index < 0 || index >= this._visitables.get("ingress").size()) {
            this._visitables.get("ingress").add(builder);
        } else {
            this._visitables.get("ingress").set(index, builder);
        }
        if (index < 0 || index >= this.ingress.size()) {
            this.ingress.add(builder);
        } else {
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIngress(LoadBalancerIngress ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<LoadBalancerIngressBuilder>();
        }
        for (LoadBalancerIngress item : items) {
            LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIngress(Collection<LoadBalancerIngress> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<LoadBalancerIngressBuilder>();
        }
        for (LoadBalancerIngress item : items) {
            LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIngress(LoadBalancerIngress ... items) {
        for (LoadBalancerIngress item : items) {
            LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIngress(Collection<LoadBalancerIngress> items) {
        for (LoadBalancerIngress item : items) {
            LoadBalancerIngressBuilder builder = new LoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromIngress(Predicate<LoadBalancerIngressBuilder> predicate) {
        if (this.ingress == null) {
            return (A)this;
        }
        Iterator<LoadBalancerIngressBuilder> each = this.ingress.iterator();
        Object visitables = this._visitables.get("ingress");
        while (each.hasNext()) {
            LoadBalancerIngressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<LoadBalancerIngress> getIngress() {
        return LoadBalancerStatusFluentImpl.build(this.ingress);
    }

    @Override
    public List<LoadBalancerIngress> buildIngress() {
        return LoadBalancerStatusFluentImpl.build(this.ingress);
    }

    @Override
    public LoadBalancerIngress buildIngress(Integer index) {
        return this.ingress.get(index).build();
    }

    @Override
    public LoadBalancerIngress buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    @Override
    public LoadBalancerIngress buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    @Override
    public LoadBalancerIngress buildMatchingIngress(Predicate<LoadBalancerIngressBuilder> predicate) {
        for (LoadBalancerIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIngress(Predicate<LoadBalancerIngressBuilder> predicate) {
        for (LoadBalancerIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIngress(List<LoadBalancerIngress> ingress) {
        if (this.ingress != null) {
            this._visitables.get("ingress").removeAll(this.ingress);
        }
        if (ingress != null) {
            this.ingress = new ArrayList<LoadBalancerIngressBuilder>();
            for (LoadBalancerIngress item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)this;
    }

    @Override
    public A withIngress(LoadBalancerIngress ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
        }
        if (ingress != null) {
            for (LoadBalancerIngress item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    @Override
    public LoadBalancerStatusFluent.IngressNested<A> addNewIngress() {
        return new IngressNestedImpl();
    }

    @Override
    public LoadBalancerStatusFluent.IngressNested<A> addNewIngressLike(LoadBalancerIngress item) {
        return new IngressNestedImpl(-1, item);
    }

    @Override
    public LoadBalancerStatusFluent.IngressNested<A> setNewIngressLike(Integer index, LoadBalancerIngress item) {
        return new IngressNestedImpl(index, item);
    }

    @Override
    public LoadBalancerStatusFluent.IngressNested<A> editIngress(Integer index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public LoadBalancerStatusFluent.IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    @Override
    public LoadBalancerStatusFluent.IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public LoadBalancerStatusFluent.IngressNested<A> editMatchingIngress(Predicate<LoadBalancerIngressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.test(this.ingress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadBalancerStatusFluentImpl that = (LoadBalancerStatusFluentImpl)o;
        if (this.ingress != null ? !this.ingress.equals(that.ingress) : that.ingress != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.ingress, this.additionalProperties, super.hashCode());
    }

    public class IngressNestedImpl<N>
    extends LoadBalancerIngressFluentImpl<LoadBalancerStatusFluent.IngressNested<N>>
    implements LoadBalancerStatusFluent.IngressNested<N>,
    Nested<N> {
        LoadBalancerIngressBuilder builder;
        Integer index;

        IngressNestedImpl(Integer index, LoadBalancerIngress item) {
            this.index = index;
            this.builder = new LoadBalancerIngressBuilder(this, item);
        }

        IngressNestedImpl() {
            this.index = -1;
            this.builder = new LoadBalancerIngressBuilder(this);
        }

        @Override
        public N and() {
            return (N)LoadBalancerStatusFluentImpl.this.setToIngress(this.index, this.builder.build());
        }

        @Override
        public N endIngress() {
            return this.and();
        }
    }
}

