/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_11;

import io.fabric8.kubernetes.api.builder.v5_11.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_11.APIGroup;
import io.fabric8.kubernetes.api.model.v5_11.APIGroupFluent;
import io.fabric8.kubernetes.api.model.v5_11.APIGroupFluentImpl;
import java.util.Objects;

public class APIGroupBuilder
extends APIGroupFluentImpl<APIGroupBuilder>
implements VisitableBuilder<APIGroup, APIGroupBuilder> {
    APIGroupFluent<?> fluent;
    Boolean validationEnabled;

    public APIGroupBuilder() {
        this(false);
    }

    public APIGroupBuilder(Boolean validationEnabled) {
        this(new APIGroup(), validationEnabled);
    }

    public APIGroupBuilder(APIGroupFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public APIGroupBuilder(APIGroupFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new APIGroup(), validationEnabled);
    }

    public APIGroupBuilder(APIGroupFluent<?> fluent, APIGroup instance) {
        this(fluent, instance, false);
    }

    public APIGroupBuilder(APIGroupFluent<?> fluent, APIGroup instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withPreferredVersion(instance.getPreferredVersion());
        fluent.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
        fluent.withVersions(instance.getVersions());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public APIGroupBuilder(APIGroup instance) {
        this(instance, (Boolean)false);
    }

    public APIGroupBuilder(APIGroup instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withPreferredVersion(instance.getPreferredVersion());
        this.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
        this.withVersions(instance.getVersions());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public APIGroup build() {
        APIGroup buildable = new APIGroup(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getPreferredVersion(), this.fluent.getServerAddressByClientCIDRs(), this.fluent.getVersions());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIGroupBuilder that = (APIGroupBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

