/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.tuned.v1.TunedMatch;
import io.fabric8.openshift.api.model.tuned.v1.TunedMatchBuilder;
import io.fabric8.openshift.api.model.tuned.v1.TunedMatchFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TunedMatchFluentImpl<A extends TunedMatchFluent<A>>
extends BaseFluent<A>
implements TunedMatchFluent<A> {
    private String label;
    private List<TunedMatchBuilder> match = new ArrayList<TunedMatchBuilder>();
    private String type;
    private String value;
    private Map<String, Object> additionalProperties;

    public TunedMatchFluentImpl() {
    }

    public TunedMatchFluentImpl(TunedMatch instance) {
        this.withLabel(instance.getLabel());
        this.withMatch(instance.getMatch());
        this.withType(instance.getType());
        this.withValue(instance.getValue());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public A withLabel(String label) {
        this.label = label;
        return (A)this;
    }

    @Override
    public Boolean hasLabel() {
        return this.label != null;
    }

    @Override
    @Deprecated
    public A withNewLabel(String arg0) {
        return this.withLabel(new String(arg0));
    }

    @Override
    public A addToMatch(Integer index, TunedMatch item) {
        if (this.match == null) {
            this.match = new ArrayList<TunedMatchBuilder>();
        }
        TunedMatchBuilder builder = new TunedMatchBuilder(item);
        this._visitables.get("match").add(index >= 0 ? index.intValue() : this._visitables.get("match").size(), builder);
        this.match.add(index >= 0 ? index.intValue() : this.match.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMatch(Integer index, TunedMatch item) {
        if (this.match == null) {
            this.match = new ArrayList<TunedMatchBuilder>();
        }
        TunedMatchBuilder builder = new TunedMatchBuilder(item);
        if (index < 0 || index >= this._visitables.get("match").size()) {
            this._visitables.get("match").add(builder);
        } else {
            this._visitables.get("match").set(index, builder);
        }
        if (index < 0 || index >= this.match.size()) {
            this.match.add(builder);
        } else {
            this.match.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMatch(TunedMatch ... items) {
        if (this.match == null) {
            this.match = new ArrayList<TunedMatchBuilder>();
        }
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get("match").add(builder);
            this.match.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMatch(Collection<TunedMatch> items) {
        if (this.match == null) {
            this.match = new ArrayList<TunedMatchBuilder>();
        }
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get("match").add(builder);
            this.match.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatch(TunedMatch ... items) {
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get("match").remove(builder);
            if (this.match == null) continue;
            this.match.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMatch(Collection<TunedMatch> items) {
        for (TunedMatch item : items) {
            TunedMatchBuilder builder = new TunedMatchBuilder(item);
            this._visitables.get("match").remove(builder);
            if (this.match == null) continue;
            this.match.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMatch(Predicate<TunedMatchBuilder> predicate) {
        if (this.match == null) {
            return (A)this;
        }
        Iterator<TunedMatchBuilder> each = this.match.iterator();
        Object visitables = this._visitables.get("match");
        while (each.hasNext()) {
            TunedMatchBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TunedMatch> getMatch() {
        return TunedMatchFluentImpl.build(this.match);
    }

    @Override
    public List<TunedMatch> buildMatch() {
        return TunedMatchFluentImpl.build(this.match);
    }

    @Override
    public TunedMatch buildMatch(Integer index) {
        return this.match.get(index).build();
    }

    @Override
    public TunedMatch buildFirstMatch() {
        return this.match.get(0).build();
    }

    @Override
    public TunedMatch buildLastMatch() {
        return this.match.get(this.match.size() - 1).build();
    }

    @Override
    public TunedMatch buildMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
        for (TunedMatchBuilder item : this.match) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
        for (TunedMatchBuilder item : this.match) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMatch(List<TunedMatch> match) {
        if (this.match != null) {
            this._visitables.get("match").removeAll(this.match);
        }
        if (match != null) {
            this.match = new ArrayList<TunedMatchBuilder>();
            for (TunedMatch item : match) {
                this.addToMatch(item);
            }
        } else {
            this.match = null;
        }
        return (A)this;
    }

    @Override
    public A withMatch(TunedMatch ... match) {
        if (this.match != null) {
            this.match.clear();
        }
        if (match != null) {
            for (TunedMatch item : match) {
                this.addToMatch(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMatch() {
        return this.match != null && !this.match.isEmpty();
    }

    @Override
    public TunedMatchFluent.MatchNested<A> addNewMatch() {
        return new MatchNestedImpl();
    }

    @Override
    public TunedMatchFluent.MatchNested<A> addNewMatchLike(TunedMatch item) {
        return new MatchNestedImpl(-1, item);
    }

    @Override
    public TunedMatchFluent.MatchNested<A> setNewMatchLike(Integer index, TunedMatch item) {
        return new MatchNestedImpl(index, item);
    }

    @Override
    public TunedMatchFluent.MatchNested<A> editMatch(Integer index) {
        if (this.match.size() <= index) {
            throw new RuntimeException("Can't edit match. Index exceeds size.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    @Override
    public TunedMatchFluent.MatchNested<A> editFirstMatch() {
        if (this.match.size() == 0) {
            throw new RuntimeException("Can't edit first match. The list is empty.");
        }
        return this.setNewMatchLike(0, this.buildMatch(0));
    }

    @Override
    public TunedMatchFluent.MatchNested<A> editLastMatch() {
        int index = this.match.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last match. The list is empty.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    @Override
    public TunedMatchFluent.MatchNested<A> editMatchingMatch(Predicate<TunedMatchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.match.size(); ++i) {
            if (!predicate.test(this.match.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching match. No match found.");
        }
        return this.setNewMatchLike(index, this.buildMatch(index));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    @Deprecated
    public A withNewType(String arg0) {
        return this.withType(new String(arg0));
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public A withValue(String value) {
        this.value = value;
        return (A)this;
    }

    @Override
    public Boolean hasValue() {
        return this.value != null;
    }

    @Override
    @Deprecated
    public A withNewValue(String arg0) {
        return this.withValue(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TunedMatchFluentImpl that = (TunedMatchFluentImpl)o;
        if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
            return false;
        }
        if (this.match != null ? !this.match.equals(that.match) : that.match != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.match, this.type, this.value, this.additionalProperties, super.hashCode());
    }

    public class MatchNestedImpl<N>
    extends TunedMatchFluentImpl<TunedMatchFluent.MatchNested<N>>
    implements TunedMatchFluent.MatchNested<N>,
    Nested<N> {
        TunedMatchBuilder builder;
        Integer index;

        MatchNestedImpl(Integer index, TunedMatch item) {
            this.index = index;
            this.builder = new TunedMatchBuilder(this, item);
        }

        MatchNestedImpl() {
            this.index = -1;
            this.builder = new TunedMatchBuilder(this);
        }

        @Override
        public N and() {
            return (N)TunedMatchFluentImpl.this.setToMatch(this.index, this.builder.build());
        }

        @Override
        public N endMatch() {
            return this.and();
        }
    }
}

