/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_11;

import io.fabric8.kubernetes.api.model.v5_11.ComponentStatus;
import io.fabric8.kubernetes.api.model.v5_11.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v5_11.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_11.KubernetesList;
import io.fabric8.kubernetes.api.model.v5_11.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_11.RootPaths;
import io.fabric8.kubernetes.clnt.v5_11.BaseKubernetesClient;
import io.fabric8.kubernetes.clnt.v5_11.ClientContext;
import io.fabric8.kubernetes.clnt.v5_11.Config;
import io.fabric8.kubernetes.clnt.v5_11.ExtensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_11.Handlers;
import io.fabric8.kubernetes.clnt.v5_11.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_11.RequestConfig;
import io.fabric8.kubernetes.clnt.v5_11.SimpleClientContext;
import io.fabric8.kubernetes.clnt.v5_11.VersionInfo;
import io.fabric8.kubernetes.clnt.v5_11.WithRequestCallable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.CreateOrDeleteable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.InOutCreateable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v5_11.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Nameable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Namespaceable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.NamespacedInOutCreateable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.ParameterMixedOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_11.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.internal.core.v1.ComponentStatusOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_11.extended.leaderelection.LeaderElectorBuilder;
import io.fabric8.kubernetes.clnt.v5_11.http.HttpClient;
import io.fabric8.kubernetes.clnt.v5_11.okhttp.OkHttpClientImpl;
import io.fabric8.kubernetes.clnt.v5_11.utils.HttpClientUtils;
import io.fabric8.kubernetes.clnt.v5_11.utils.Serialization;
import io.fabric8.openshift.api.model.v5_11.BrokerTemplateInstance;
import io.fabric8.openshift.api.model.v5_11.BrokerTemplateInstanceList;
import io.fabric8.openshift.api.model.v5_11.Build;
import io.fabric8.openshift.api.model.v5_11.BuildConfig;
import io.fabric8.openshift.api.model.v5_11.BuildConfigList;
import io.fabric8.openshift.api.model.v5_11.BuildList;
import io.fabric8.openshift.api.model.v5_11.ClusterNetwork;
import io.fabric8.openshift.api.model.v5_11.ClusterNetworkList;
import io.fabric8.openshift.api.model.v5_11.ClusterRole;
import io.fabric8.openshift.api.model.v5_11.ClusterRoleBinding;
import io.fabric8.openshift.api.model.v5_11.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.v5_11.ClusterRoleList;
import io.fabric8.openshift.api.model.v5_11.ClusterVersion;
import io.fabric8.openshift.api.model.v5_11.DeploymentConfig;
import io.fabric8.openshift.api.model.v5_11.DeploymentConfigList;
import io.fabric8.openshift.api.model.v5_11.EgressNetworkPolicy;
import io.fabric8.openshift.api.model.v5_11.EgressNetworkPolicyList;
import io.fabric8.openshift.api.model.v5_11.Group;
import io.fabric8.openshift.api.model.v5_11.GroupList;
import io.fabric8.openshift.api.model.v5_11.HelmChartRepository;
import io.fabric8.openshift.api.model.v5_11.HelmChartRepositoryList;
import io.fabric8.openshift.api.model.v5_11.HostSubnet;
import io.fabric8.openshift.api.model.v5_11.HostSubnetList;
import io.fabric8.openshift.api.model.v5_11.Identity;
import io.fabric8.openshift.api.model.v5_11.IdentityList;
import io.fabric8.openshift.api.model.v5_11.Image;
import io.fabric8.openshift.api.model.v5_11.ImageList;
import io.fabric8.openshift.api.model.v5_11.ImageSignature;
import io.fabric8.openshift.api.model.v5_11.ImageStream;
import io.fabric8.openshift.api.model.v5_11.ImageStreamImage;
import io.fabric8.openshift.api.model.v5_11.ImageStreamImport;
import io.fabric8.openshift.api.model.v5_11.ImageStreamList;
import io.fabric8.openshift.api.model.v5_11.ImageStreamMapping;
import io.fabric8.openshift.api.model.v5_11.ImageStreamTag;
import io.fabric8.openshift.api.model.v5_11.ImageStreamTagList;
import io.fabric8.openshift.api.model.v5_11.ImageTag;
import io.fabric8.openshift.api.model.v5_11.ImageTagList;
import io.fabric8.openshift.api.model.v5_11.LocalResourceAccessReview;
import io.fabric8.openshift.api.model.v5_11.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.v5_11.NetNamespace;
import io.fabric8.openshift.api.model.v5_11.NetNamespaceList;
import io.fabric8.openshift.api.model.v5_11.OAuthAccessToken;
import io.fabric8.openshift.api.model.v5_11.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.v5_11.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.v5_11.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.v5_11.OAuthClient;
import io.fabric8.openshift.api.model.v5_11.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.v5_11.OAuthClientAuthorizationList;
import io.fabric8.openshift.api.model.v5_11.OAuthClientList;
import io.fabric8.openshift.api.model.v5_11.PodSecurityPolicyReview;
import io.fabric8.openshift.api.model.v5_11.PodSecurityPolicySelfSubjectReview;
import io.fabric8.openshift.api.model.v5_11.PodSecurityPolicySubjectReview;
import io.fabric8.openshift.api.model.v5_11.RangeAllocation;
import io.fabric8.openshift.api.model.v5_11.RangeAllocationList;
import io.fabric8.openshift.api.model.v5_11.ResourceAccessReview;
import io.fabric8.openshift.api.model.v5_11.ResourceAccessReviewResponse;
import io.fabric8.openshift.api.model.v5_11.Role;
import io.fabric8.openshift.api.model.v5_11.RoleBinding;
import io.fabric8.openshift.api.model.v5_11.RoleBindingList;
import io.fabric8.openshift.api.model.v5_11.RoleBindingRestriction;
import io.fabric8.openshift.api.model.v5_11.RoleBindingRestrictionList;
import io.fabric8.openshift.api.model.v5_11.RoleList;
import io.fabric8.openshift.api.model.v5_11.Route;
import io.fabric8.openshift.api.model.v5_11.RouteList;
import io.fabric8.openshift.api.model.v5_11.SecurityContextConstraints;
import io.fabric8.openshift.api.model.v5_11.SecurityContextConstraintsList;
import io.fabric8.openshift.api.model.v5_11.SelfSubjectRulesReview;
import io.fabric8.openshift.api.model.v5_11.SubjectAccessReview;
import io.fabric8.openshift.api.model.v5_11.SubjectAccessReviewResponse;
import io.fabric8.openshift.api.model.v5_11.SubjectRulesReview;
import io.fabric8.openshift.api.model.v5_11.Template;
import io.fabric8.openshift.api.model.v5_11.TemplateInstance;
import io.fabric8.openshift.api.model.v5_11.TemplateInstanceList;
import io.fabric8.openshift.api.model.v5_11.TemplateList;
import io.fabric8.openshift.api.model.v5_11.User;
import io.fabric8.openshift.api.model.v5_11.UserIdentityMapping;
import io.fabric8.openshift.api.model.v5_11.UserList;
import io.fabric8.openshift.api.model.v5_11.UserOAuthAccessToken;
import io.fabric8.openshift.api.model.v5_11.UserOAuthAccessTokenList;
import io.fabric8.openshift.api.model.v5_11.miscellaneous.apiserver.v1.APIRequestCount;
import io.fabric8.openshift.api.model.v5_11.miscellaneous.apiserver.v1.APIRequestCountList;
import io.fabric8.openshift.api.model.v5_11.miscellaneous.cloudcredential.v1.CredentialsRequest;
import io.fabric8.openshift.api.model.v5_11.miscellaneous.cloudcredential.v1.CredentialsRequestList;
import io.fabric8.openshift.api.model.v5_11.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinition;
import io.fabric8.openshift.api.model.v5_11.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinitionList;
import io.fabric8.openshift.api.model.v5_11.miscellaneous.imageregistry.operator.v1.ConfigList;
import io.fabric8.openshift.api.model.v5_11.miscellaneous.metal3.v1alpha1.BareMetalHost;
import io.fabric8.openshift.api.model.v5_11.miscellaneous.metal3.v1alpha1.BareMetalHostList;
import io.fabric8.openshift.api.model.v5_11.miscellaneous.network.operator.v1.EgressRouter;
import io.fabric8.openshift.api.model.v5_11.miscellaneous.network.operator.v1.EgressRouterList;
import io.fabric8.openshift.api.model.v5_11.miscellaneous.network.operator.v1.OperatorPKI;
import io.fabric8.openshift.api.model.v5_11.miscellaneous.network.operator.v1.OperatorPKIList;
import io.fabric8.openshift.clnt.v5_11.NamespacedOpenShiftClient;
import io.fabric8.openshift.clnt.v5_11.OpenShiftClusterAutoscalingAPIGroupClient;
import io.fabric8.openshift.clnt.v5_11.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_11.OpenShiftConfigAPIGroupClient;
import io.fabric8.openshift.clnt.v5_11.OpenShiftConfigBuilder;
import io.fabric8.openshift.clnt.v5_11.OpenShiftConsoleAPIGroupClient;
import io.fabric8.openshift.clnt.v5_11.OpenShiftHandlers;
import io.fabric8.openshift.clnt.v5_11.OpenShiftMachineAPIGroupClient;
import io.fabric8.openshift.clnt.v5_11.OpenShiftMachineConfigurationAPIGroupClient;
import io.fabric8.openshift.clnt.v5_11.OpenShiftMonitoringAPIGroupClient;
import io.fabric8.openshift.clnt.v5_11.OpenShiftOperatorAPIGroupClient;
import io.fabric8.openshift.clnt.v5_11.OpenShiftOperatorHubAPIGroupClient;
import io.fabric8.openshift.clnt.v5_11.OpenShiftQuotaAPIGroupClient;
import io.fabric8.openshift.clnt.v5_11.OpenShiftStorageVersionMigratorApiGroupClient;
import io.fabric8.openshift.clnt.v5_11.OpenShiftTunedAPIGroupClient;
import io.fabric8.openshift.clnt.v5_11.OpenShiftWhereaboutsAPIGroupClient;
import io.fabric8.openshift.clnt.v5_11.OpenshiftAdapterSupport;
import io.fabric8.openshift.clnt.v5_11.OpenshiftClientContext;
import io.fabric8.openshift.clnt.v5_11.dsl.BuildConfigResource;
import io.fabric8.openshift.clnt.v5_11.dsl.BuildResource;
import io.fabric8.openshift.clnt.v5_11.dsl.DeployableScalableResource;
import io.fabric8.openshift.clnt.v5_11.dsl.MachineConfigurationAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_11.dsl.NameableCreateOrDeleteable;
import io.fabric8.openshift.clnt.v5_11.dsl.OpenShiftClusterAutoscalingAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_11.dsl.OpenShiftConfigAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_11.dsl.OpenShiftConsoleAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_11.dsl.OpenShiftMachineAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_11.dsl.OpenShiftMonitoringAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_11.dsl.OpenShiftOperatorAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_11.dsl.OpenShiftOperatorHubAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_11.dsl.OpenShiftQuotaAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_11.dsl.OpenShiftStorageVersionMigratorApiGroupDSL;
import io.fabric8.openshift.clnt.v5_11.dsl.OpenShiftTunedAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_11.dsl.OpenShiftWhereaboutsAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_11.dsl.ProjectOperation;
import io.fabric8.openshift.clnt.v5_11.dsl.ProjectRequestOperation;
import io.fabric8.openshift.clnt.v5_11.dsl.TemplateResource;
import io.fabric8.openshift.clnt.v5_11.dsl.internal.ProjectRequestsOperationImpl;
import io.fabric8.openshift.clnt.v5_11.dsl.internal.apps.DeploymentConfigOperationsImpl;
import io.fabric8.openshift.clnt.v5_11.dsl.internal.authorization.ClusterRoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v5_11.dsl.internal.authorization.RoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v5_11.dsl.internal.authorization.RoleOperationsImpl;
import io.fabric8.openshift.clnt.v5_11.dsl.internal.build.BuildConfigOperationsImpl;
import io.fabric8.openshift.clnt.v5_11.dsl.internal.build.BuildOperationsImpl;
import io.fabric8.openshift.clnt.v5_11.dsl.internal.core.NetworkAttachmentDefinitionOperationsImpl;
import io.fabric8.openshift.clnt.v5_11.dsl.internal.core.TemplateOperationsImpl;
import io.fabric8.openshift.clnt.v5_11.dsl.internal.oauth.OAuthAccessTokenOperationsImpl;
import io.fabric8.openshift.clnt.v5_11.dsl.internal.oauth.OAuthAuthorizeTokenOperationsImpl;
import io.fabric8.openshift.clnt.v5_11.dsl.internal.oauth.OAuthClientOperationsImpl;
import io.fabric8.openshift.clnt.v5_11.dsl.internal.project.ProjectOperationsImpl;
import io.fabric8.openshift.clnt.v5_11.dsl.internal.security.SecurityContextConstraintsOperationsImpl;
import io.fabric8.openshift.clnt.v5_11.dsl.internal.user.GroupOperationsImpl;
import io.fabric8.openshift.clnt.v5_11.dsl.internal.user.UserOperationsImpl;
import io.fabric8.openshift.clnt.v5_11.internal.OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import okhttp3.OkHttpClient;

public class DefaultOpenShiftClient
extends BaseKubernetesClient<NamespacedOpenShiftClient>
implements NamespacedOpenShiftClient,
OpenshiftClientContext {
    public static final String OPENSHIFT_VERSION_ENDPOINT = "version/openshift";
    private final URL openShiftUrl;

    public DefaultOpenShiftClient() {
        this(new OpenShiftConfigBuilder().build());
    }

    public DefaultOpenShiftClient(String masterUrl) {
        this(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public DefaultOpenShiftClient(Config config) {
        this(new OpenShiftConfig(config));
    }

    public DefaultOpenShiftClient(OpenShiftConfig config) {
        this(HttpClientUtils.createHttpClient(config), config);
    }

    @Deprecated
    public DefaultOpenShiftClient(OkHttpClient httpClient, OpenShiftConfig config) {
        this((HttpClient)new OkHttpClientImpl(httpClient), config);
    }

    public DefaultOpenShiftClient(HttpClient httpClient, OpenShiftConfig config) {
        this(new SimpleClientContext(config, httpClient));
    }

    public DefaultOpenShiftClient(ClientContext clientContext) {
        super(clientContext);
        try {
            this.openShiftUrl = new URL(this.getConfiguration().getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", e);
        }
    }

    public static DefaultOpenShiftClient fromConfig(String config) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(config, OpenShiftConfig.class));
    }

    public static DefaultOpenShiftClient fromConfig(InputStream is) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(is, OpenShiftConfig.class));
    }

    @Override
    public URL getOpenshiftUrl() {
        return this.openShiftUrl;
    }

    @Override
    public OpenShiftConfig getConfiguration() {
        return OpenShiftConfig.wrap(super.getConfiguration());
    }

    @Override
    public OpenShiftConfigAPIGroupDSL config() {
        return this.adapt(OpenShiftConfigAPIGroupClient.class);
    }

    @Override
    public OpenShiftConsoleAPIGroupDSL console() {
        return this.adapt(OpenShiftConsoleAPIGroupClient.class);
    }

    @Override
    public OpenShiftClusterAutoscalingAPIGroupDSL clusterAutoscaling() {
        return this.adapt(OpenShiftClusterAutoscalingAPIGroupClient.class);
    }

    @Override
    public OpenShiftOperatorAPIGroupDSL operator() {
        return this.adapt(OpenShiftOperatorAPIGroupClient.class);
    }

    @Override
    public OpenShiftOperatorHubAPIGroupDSL operatorHub() {
        return this.adapt(OpenShiftOperatorHubAPIGroupClient.class);
    }

    public MixedOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return new ComponentStatusOperationsImpl(this);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> load(InputStream is) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this, is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(KubernetesResourceList item) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this, item);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(String s) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this, s);
    }

    @Override
    public MixedOperation<Build, BuildList, BuildResource<Build, LogWatch>> builds() {
        return new BuildOperationsImpl(this);
    }

    @Override
    public MixedOperation<BuildConfig, BuildConfigList, BuildConfigResource<BuildConfig, Void, Build>> buildConfigs() {
        return new BuildConfigOperationsImpl(this);
    }

    @Override
    public MixedOperation<CredentialsRequest, CredentialsRequestList, Resource<CredentialsRequest>> credentialsRequests() {
        return OpenShiftHandlers.getOperation(CredentialsRequest.class, CredentialsRequestList.class, this);
    }

    @Override
    public MixedOperation<DeploymentConfig, DeploymentConfigList, DeployableScalableResource<DeploymentConfig>> deploymentConfigs() {
        return new DeploymentConfigOperationsImpl(this);
    }

    public MixedOperation<Group, GroupList, Resource<Group>> groups() {
        return new GroupOperationsImpl(this);
    }

    @Override
    public NonNamespaceOperation<HelmChartRepository, HelmChartRepositoryList, Resource<HelmChartRepository>> helmChartRepositories() {
        return OpenShiftHandlers.getOperation(HelmChartRepository.class, HelmChartRepositoryList.class, this);
    }

    @Override
    public NonNamespaceOperation<Image, ImageList, Resource<Image>> images() {
        return OpenShiftHandlers.getOperation(Image.class, ImageList.class, this);
    }

    @Override
    public MixedOperation<ImageTag, ImageTagList, Resource<ImageTag>> imageTags() {
        return OpenShiftHandlers.getOperation(ImageTag.class, ImageTagList.class, this);
    }

    @Override
    public MixedOperation<ImageStream, ImageStreamList, Resource<ImageStream>> imageStreams() {
        return OpenShiftHandlers.getOperation(ImageStream.class, ImageStreamList.class, this);
    }

    @Override
    public MixedOperation<ImageStreamTag, ImageStreamTagList, Resource<ImageStreamTag>> imageStreamTags() {
        return OpenShiftHandlers.getOperation(ImageStreamTag.class, ImageStreamTagList.class, this);
    }

    @Override
    public NamespacedInOutCreateable<ImageStreamImport, ImageStreamImport> imageStreamImports() {
        return Handlers.getNamespacedHasMetadataCreateOnlyOperation(ImageStreamImport.class, this);
    }

    @Override
    public NamespacedInOutCreateable<ImageStreamMapping, ImageStreamMapping> imageStreamMappings() {
        return Handlers.getNamespacedHasMetadataCreateOnlyOperation(ImageStreamMapping.class, this);
    }

    @Override
    public Namespaceable<Nameable<? extends Gettable<ImageStreamImage>>> imageStreamImages() {
        HasMetadataOperation<ImageStreamImage, ?, Resource<ImageStreamImage>> operation = Handlers.getNonListingOperation(ImageStreamImage.class, this);
        return operation::inNamespace;
    }

    @Override
    public NameableCreateOrDeleteable imageSignatures() {
        final HasMetadataOperation<ImageSignature, ?, Resource<ImageSignature>> operation = Handlers.getNonListingOperation(ImageSignature.class, this);
        return new NameableCreateOrDeleteable(){

            @Override
            public Boolean delete() {
                return operation.delete();
            }

            @Override
            public ImageSignature create(ImageSignature item) {
                return (ImageSignature)operation.create(item);
            }

            @Override
            public ImageSignature create(ImageSignature ... item) {
                return (ImageSignature)operation.create(item);
            }

            @Override
            public CreateOrDeleteable<ImageSignature> withName(String name) {
                return operation.withName(name);
            }
        };
    }

    @Override
    public NonNamespaceOperation<io.fabric8.openshift.api.model.v5_11.miscellaneous.imageregistry.operator.v1.Config, ConfigList, Resource<io.fabric8.openshift.api.model.v5_11.miscellaneous.imageregistry.operator.v1.Config>> imageRegistryOperatorConfigs() {
        return OpenShiftHandlers.getOperation(io.fabric8.openshift.api.model.v5_11.miscellaneous.imageregistry.operator.v1.Config.class, ConfigList.class, this);
    }

    @Override
    public MixedOperation<NetworkAttachmentDefinition, NetworkAttachmentDefinitionList, Resource<NetworkAttachmentDefinition>> networkAttachmentDefinitions() {
        return new NetworkAttachmentDefinitionOperationsImpl(this);
    }

    @Override
    public NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, Resource<OAuthAccessToken>> oAuthAccessTokens() {
        return new OAuthAccessTokenOperationsImpl(this);
    }

    @Override
    public NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, Resource<OAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return new OAuthAuthorizeTokenOperationsImpl(this);
    }

    @Override
    public NonNamespaceOperation<OAuthClient, OAuthClientList, Resource<OAuthClient>> oAuthClients() {
        return new OAuthClientOperationsImpl(this);
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicyReview, PodSecurityPolicyReview> podSecurityPolicyReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(PodSecurityPolicyReview.class, PodSecurityPolicyReview.class, this);
    }

    @Override
    public NonNamespaceOperation<OAuthClientAuthorization, OAuthClientAuthorizationList, Resource<OAuthClientAuthorization>> oAuthClientAuthorizations() {
        return OpenShiftHandlers.getOperation(OAuthClientAuthorization.class, OAuthClientAuthorizationList.class, this);
    }

    @Override
    public MixedOperation<OperatorPKI, OperatorPKIList, Resource<OperatorPKI>> operatorPKIs() {
        return OpenShiftHandlers.getOperation(OperatorPKI.class, OperatorPKIList.class, this);
    }

    @Override
    public MixedOperation<EgressRouter, EgressRouterList, Resource<EgressRouter>> egressRouters() {
        return OpenShiftHandlers.getOperation(EgressRouter.class, EgressRouterList.class, this);
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicySelfSubjectReview, PodSecurityPolicySelfSubjectReview> podSecurityPolicySelfSubjectReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(PodSecurityPolicySelfSubjectReview.class, PodSecurityPolicySelfSubjectReview.class, this);
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicySubjectReview, PodSecurityPolicySubjectReview> podSecurityPolicySubjectReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(PodSecurityPolicySubjectReview.class, PodSecurityPolicySubjectReview.class, this);
    }

    @Override
    public ProjectOperation projects() {
        return new ProjectOperationsImpl(this);
    }

    @Override
    public OpenShiftQuotaAPIGroupDSL quotas() {
        return this.adapt(OpenShiftQuotaAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<RangeAllocation, RangeAllocationList, Resource<RangeAllocation>> rangeAllocations() {
        return OpenShiftHandlers.getOperation(RangeAllocation.class, RangeAllocationList.class, this);
    }

    @Override
    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, Resource<SecurityContextConstraints>> securityContextConstraints() {
        return new SecurityContextConstraintsOperationsImpl(this);
    }

    @Override
    public ProjectRequestOperation projectrequests() {
        return new ProjectRequestsOperationImpl(this);
    }

    @Override
    public MixedOperation<Role, RoleList, Resource<Role>> roles() {
        return new RoleOperationsImpl(this);
    }

    @Override
    public MixedOperation<RoleBinding, RoleBindingList, Resource<RoleBinding>> roleBindings() {
        return new RoleBindingOperationsImpl(this);
    }

    @Override
    public MixedOperation<Route, RouteList, Resource<Route>> routes() {
        return OpenShiftHandlers.getOperation(Route.class, RouteList.class, this);
    }

    @Override
    public ParameterMixedOperation<Template, TemplateList, TemplateResource<Template, KubernetesList>> templates() {
        return new TemplateOperationsImpl(this);
    }

    @Override
    public MixedOperation<TemplateInstance, TemplateInstanceList, Resource<TemplateInstance>> templateInstances() {
        return OpenShiftHandlers.getOperation(TemplateInstance.class, TemplateInstanceList.class, this);
    }

    @Override
    public OpenShiftTunedAPIGroupDSL tuned() {
        return this.adapt(OpenShiftTunedAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<BrokerTemplateInstance, BrokerTemplateInstanceList, Resource<BrokerTemplateInstance>> brokerTemplateInstances() {
        return OpenShiftHandlers.getOperation(BrokerTemplateInstance.class, BrokerTemplateInstanceList.class, this);
    }

    public MixedOperation<User, UserList, Resource<User>> users() {
        return new UserOperationsImpl(this);
    }

    @Override
    public MixedOperation<ClusterRoleBinding, ClusterRoleBindingList, Resource<ClusterRoleBinding>> clusterRoleBindings() {
        return new ClusterRoleBindingOperationsImpl(this);
    }

    @Override
    public MixedOperation<RoleBindingRestriction, RoleBindingRestrictionList, Resource<RoleBindingRestriction>> roleBindingRestrictions() {
        return OpenShiftHandlers.getOperation(RoleBindingRestriction.class, RoleBindingRestrictionList.class, this);
    }

    @Override
    public NamespacedOpenShiftClient inNamespace(String namespace) {
        OpenShiftConfig updated = ((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(this.getConfiguration()).withNamespace(namespace)).build();
        return new DefaultOpenShiftClient(this.newState(updated));
    }

    @Override
    public NamespacedOpenShiftClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public ExtensionsAPIGroupClient extensions() {
        return this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public VersionInfo getVersion() {
        for (Supplier supplier : new Supplier[]{this::getOpenShiftV3Version, this::getOpenShiftV4VersionInfo}) {
            try {
                VersionInfo vi = (VersionInfo)supplier.get();
                if (vi == null) continue;
                return vi;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.getVersion();
    }

    @Override
    public VersionInfo getKubernetesVersion() {
        return super.getVersion();
    }

    @Override
    public VersionInfo getOpenShiftV3Version() {
        return this.getVersionInfo(OPENSHIFT_VERSION_ENDPOINT);
    }

    private VersionInfo getOpenShiftV4VersionInfo() {
        return ((KubernetesResourceList)this.resources(ClusterVersion.class).list()).getItems().stream().findFirst().map(clusterVersion -> {
            String[] versionParts = clusterVersion.getStatus().getDesired().getVersion().split("\\.");
            VersionInfo.Builder versionInfoBuilder = new VersionInfo.Builder();
            if (versionParts.length > 2) {
                versionInfoBuilder.withMajor(versionParts[0]);
                versionInfoBuilder.withMinor(versionParts[1] + "." + versionParts[2]);
            }
            try {
                versionInfoBuilder.withBuildDate(clusterVersion.getMetadata().getCreationTimestamp());
            }
            catch (ParseException e) {
                return null;
            }
            return versionInfoBuilder.build();
        }).orElse(null);
    }

    @Override
    public String getOpenShiftV4Version() {
        return ((KubernetesResourceList)this.resources(ClusterVersion.class).list()).getItems().stream().findFirst().map(cv -> cv.getStatus().getDesired().getVersion()).orElse(null);
    }

    @Override
    public MachineConfigurationAPIGroupDSL machineConfigurations() {
        return this.adapt(OpenShiftMachineConfigurationAPIGroupClient.class);
    }

    @Override
    public OpenShiftMachineAPIGroupDSL machine() {
        return this.adapt(OpenShiftMachineAPIGroupClient.class);
    }

    @Override
    public OpenShiftMonitoringAPIGroupDSL monitoring() {
        return this.adapt(OpenShiftMonitoringAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<NetNamespace, NetNamespaceList, Resource<NetNamespace>> netNamespaces() {
        return OpenShiftHandlers.getOperation(NetNamespace.class, NetNamespaceList.class, this);
    }

    @Override
    public NonNamespaceOperation<ClusterNetwork, ClusterNetworkList, Resource<ClusterNetwork>> clusterNetworks() {
        return OpenShiftHandlers.getOperation(ClusterNetwork.class, ClusterNetworkList.class, this);
    }

    @Override
    public MixedOperation<EgressNetworkPolicy, EgressNetworkPolicyList, Resource<EgressNetworkPolicy>> egressNetworkPolicies() {
        return OpenShiftHandlers.getOperation(EgressNetworkPolicy.class, EgressNetworkPolicyList.class, this);
    }

    @Override
    public NonNamespaceOperation<HostSubnet, HostSubnetList, Resource<HostSubnet>> hostSubnets() {
        return OpenShiftHandlers.getOperation(HostSubnet.class, HostSubnetList.class, this);
    }

    @Override
    public NonNamespaceOperation<APIRequestCount, APIRequestCountList, Resource<APIRequestCount>> apiRequestCounts() {
        return OpenShiftHandlers.getOperation(APIRequestCount.class, APIRequestCountList.class, this);
    }

    @Override
    public MixedOperation<BareMetalHost, BareMetalHostList, Resource<BareMetalHost>> bareMetalHosts() {
        return OpenShiftHandlers.getOperation(BareMetalHost.class, BareMetalHostList.class, this);
    }

    @Override
    public InOutCreateable<SubjectAccessReview, SubjectAccessReviewResponse> subjectAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(SubjectAccessReview.class, SubjectAccessReviewResponse.class, this);
    }

    @Override
    public InOutCreateable<ResourceAccessReview, ResourceAccessReviewResponse> resourceAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(ResourceAccessReview.class, ResourceAccessReviewResponse.class, this);
    }

    @Override
    public NamespacedInOutCreateable<LocalSubjectAccessReview, SubjectAccessReviewResponse> localSubjectAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(LocalSubjectAccessReview.class, SubjectAccessReviewResponse.class, this);
    }

    @Override
    public NamespacedInOutCreateable<LocalResourceAccessReview, ResourceAccessReviewResponse> localResourceAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(LocalResourceAccessReview.class, ResourceAccessReviewResponse.class, this);
    }

    @Override
    public NamespacedInOutCreateable<SelfSubjectRulesReview, SelfSubjectRulesReview> selfSubjectRulesReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(SelfSubjectRulesReview.class, SelfSubjectRulesReview.class, this);
    }

    @Override
    public NamespacedInOutCreateable<SubjectRulesReview, SubjectRulesReview> subjectRulesReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(SubjectRulesReview.class, SubjectRulesReview.class, this);
    }

    @Override
    public OpenShiftStorageVersionMigratorApiGroupDSL kubeStorageVersionMigrator() {
        return this.adapt(OpenShiftStorageVersionMigratorApiGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<ClusterRole, ClusterRoleList, Resource<ClusterRole>> clusterRoles() {
        return OpenShiftHandlers.getOperation(ClusterRole.class, ClusterRoleList.class, this);
    }

    public LeaderElectorBuilder<NamespacedOpenShiftClient> leaderElector() {
        return new LeaderElectorBuilder<NamespacedOpenShiftClient>(this);
    }

    @Override
    public FunctionCallable<NamespacedOpenShiftClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable<NamespacedOpenShiftClient>(this, requestConfig);
    }

    @Override
    public User currentUser() {
        return (User)((Resource)this.users().withName("~")).get();
    }

    @Override
    public NonNamespaceOperation<Identity, IdentityList, Resource<Identity>> identities() {
        return OpenShiftHandlers.getOperation(Identity.class, IdentityList.class, this);
    }

    @Override
    public InOutCreateable<UserIdentityMapping, UserIdentityMapping> userIdentityMappings() {
        return Handlers.getNonListingOperation(UserIdentityMapping.class, this);
    }

    @Override
    public NonNamespaceOperation<UserOAuthAccessToken, UserOAuthAccessTokenList, Resource<UserOAuthAccessToken>> userOAuthAccessTokens() {
        return OpenShiftHandlers.getOperation(UserOAuthAccessToken.class, UserOAuthAccessTokenList.class, this);
    }

    @Override
    public OpenShiftWhereaboutsAPIGroupDSL whereabouts() {
        return this.adapt(OpenShiftWhereaboutsAPIGroupClient.class);
    }

    @Override
    public boolean supportsOpenShiftAPIGroup(String apiGroup) {
        List<String> paths;
        String apiGroupPath = "/apis/" + apiGroup;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!Objects.equals("/oapi", path) && !Objects.equals("oapi", path) && !Objects.equals(apiGroupPath, path)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void adaptState() {
        OpenShiftConfig wrapped = OpenShiftConfig.wrap(this.config);
        this.config = wrapped;
        this.httpClient = OpenshiftAdapterSupport.adaptHttpClient(this.httpClient, wrapped);
    }
}

