/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_11.operatorhub.v1;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.kubernetes.api.model.v5_11.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_11.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v5_11.LabelSelectorFluentImpl;
import io.fabric8.openshift.api.model.v5_11.operatorhub.v1.Components;
import io.fabric8.openshift.api.model.v5_11.operatorhub.v1.ComponentsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ComponentsFluentImpl<A extends ComponentsFluent<A>>
extends BaseFluent<A>
implements ComponentsFluent<A> {
    private LabelSelectorBuilder labelSelector;
    private List<JsonNode> refs = new ArrayList<JsonNode>();
    private Map<String, Object> additionalProperties;

    public ComponentsFluentImpl() {
    }

    public ComponentsFluentImpl(Components instance) {
        this.withLabelSelector(instance.getLabelSelector());
        this.withRefs(instance.getRefs());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public LabelSelector getLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    @Override
    public LabelSelector buildLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    @Override
    public A withLabelSelector(LabelSelector labelSelector) {
        this._visitables.get("labelSelector").remove(this.labelSelector);
        if (labelSelector != null) {
            this.labelSelector = new LabelSelectorBuilder(labelSelector);
            this._visitables.get("labelSelector").add(this.labelSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    @Override
    public ComponentsFluent.LabelSelectorNested<A> withNewLabelSelector() {
        return new LabelSelectorNestedImpl();
    }

    @Override
    public ComponentsFluent.LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
        return new LabelSelectorNestedImpl(item);
    }

    @Override
    public ComponentsFluent.LabelSelectorNested<A> editLabelSelector() {
        return this.withNewLabelSelectorLike(this.getLabelSelector());
    }

    @Override
    public ComponentsFluent.LabelSelectorNested<A> editOrNewLabelSelector() {
        return this.withNewLabelSelectorLike(this.getLabelSelector() != null ? this.getLabelSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public ComponentsFluent.LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
        return this.withNewLabelSelectorLike(this.getLabelSelector() != null ? this.getLabelSelector() : item);
    }

    @Override
    public A addToRefs(Integer index, JsonNode item) {
        if (this.refs == null) {
            this.refs = new ArrayList<JsonNode>();
        }
        this.refs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRefs(Integer index, JsonNode item) {
        if (this.refs == null) {
            this.refs = new ArrayList<JsonNode>();
        }
        this.refs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRefs(JsonNode ... items) {
        if (this.refs == null) {
            this.refs = new ArrayList<JsonNode>();
        }
        for (JsonNode item : items) {
            this.refs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRefs(Collection<JsonNode> items) {
        if (this.refs == null) {
            this.refs = new ArrayList<JsonNode>();
        }
        for (JsonNode item : items) {
            this.refs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRefs(JsonNode ... items) {
        for (JsonNode item : items) {
            if (this.refs == null) continue;
            this.refs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRefs(Collection<JsonNode> items) {
        for (JsonNode item : items) {
            if (this.refs == null) continue;
            this.refs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<JsonNode> getRefs() {
        return this.refs;
    }

    @Override
    public JsonNode getRef(Integer index) {
        return this.refs.get(index);
    }

    @Override
    public JsonNode getFirstRef() {
        return this.refs.get(0);
    }

    @Override
    public JsonNode getLastRef() {
        return this.refs.get(this.refs.size() - 1);
    }

    @Override
    public JsonNode getMatchingRef(Predicate<JsonNode> predicate) {
        for (JsonNode item : this.refs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRef(Predicate<JsonNode> predicate) {
        for (JsonNode item : this.refs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRefs(List<JsonNode> refs) {
        if (refs != null) {
            this.refs = new ArrayList<JsonNode>();
            for (JsonNode item : refs) {
                this.addToRefs(item);
            }
        } else {
            this.refs = null;
        }
        return (A)this;
    }

    @Override
    public A withRefs(JsonNode ... refs) {
        if (this.refs != null) {
            this.refs.clear();
        }
        if (refs != null) {
            for (JsonNode item : refs) {
                this.addToRefs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRefs() {
        return this.refs != null && !this.refs.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentsFluentImpl that = (ComponentsFluentImpl)o;
        if (this.labelSelector != null ? !this.labelSelector.equals(that.labelSelector) : that.labelSelector != null) {
            return false;
        }
        if (this.refs != null ? !this.refs.equals(that.refs) : that.refs != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.labelSelector, this.refs, this.additionalProperties, super.hashCode());
    }

    public class LabelSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<ComponentsFluent.LabelSelectorNested<N>>
    implements ComponentsFluent.LabelSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        LabelSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        LabelSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentsFluentImpl.this.withLabelSelector(this.builder.build());
        }

        @Override
        public N endLabelSelector() {
            return this.and();
        }
    }
}

