/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_11.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_11.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_11.operator.v1.Upstream;
import io.fabric8.openshift.api.model.v5_11.operator.v1.UpstreamFluent;
import io.fabric8.openshift.api.model.v5_11.operator.v1.UpstreamFluentImpl;
import java.util.Objects;

public class UpstreamBuilder
extends UpstreamFluentImpl<UpstreamBuilder>
implements VisitableBuilder<Upstream, UpstreamBuilder> {
    UpstreamFluent<?> fluent;
    Boolean validationEnabled;

    public UpstreamBuilder() {
        this(false);
    }

    public UpstreamBuilder(Boolean validationEnabled) {
        this(new Upstream(), validationEnabled);
    }

    public UpstreamBuilder(UpstreamFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public UpstreamBuilder(UpstreamFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Upstream(), validationEnabled);
    }

    public UpstreamBuilder(UpstreamFluent<?> fluent, Upstream instance) {
        this(fluent, instance, false);
    }

    public UpstreamBuilder(UpstreamFluent<?> fluent, Upstream instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddress(instance.getAddress());
        fluent.withPort(instance.getPort());
        fluent.withType(instance.getType());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public UpstreamBuilder(Upstream instance) {
        this(instance, (Boolean)false);
    }

    public UpstreamBuilder(Upstream instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddress(instance.getAddress());
        this.withPort(instance.getPort());
        this.withType(instance.getType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Upstream build() {
        Upstream buildable = new Upstream(this.fluent.getAddress(), this.fluent.getPort(), this.fluent.getType());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UpstreamBuilder that = (UpstreamBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

