/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_11.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.kubernetes.api.model.v5_11.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_11.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v5_11.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.v5_11.Toleration;
import io.fabric8.openshift.api.model.v5_11.operator.v1.NodePlacement;
import io.fabric8.openshift.api.model.v5_11.operator.v1.NodePlacementFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NodePlacementFluentImpl<A extends NodePlacementFluent<A>>
extends BaseFluent<A>
implements NodePlacementFluent<A> {
    private LabelSelectorBuilder nodeSelector;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private Map<String, Object> additionalProperties;

    public NodePlacementFluentImpl() {
    }

    public NodePlacementFluentImpl(NodePlacement instance) {
        this.withNodeSelector(instance.getNodeSelector());
        this.withTolerations(instance.getTolerations());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public LabelSelector getNodeSelector() {
        return this.nodeSelector != null ? this.nodeSelector.build() : null;
    }

    @Override
    public LabelSelector buildNodeSelector() {
        return this.nodeSelector != null ? this.nodeSelector.build() : null;
    }

    @Override
    public A withNodeSelector(LabelSelector nodeSelector) {
        this._visitables.get("nodeSelector").remove(this.nodeSelector);
        if (nodeSelector != null) {
            this.nodeSelector = new LabelSelectorBuilder(nodeSelector);
            this._visitables.get("nodeSelector").add(this.nodeSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    public NodePlacementFluent.NodeSelectorNested<A> withNewNodeSelector() {
        return new NodeSelectorNestedImpl();
    }

    @Override
    public NodePlacementFluent.NodeSelectorNested<A> withNewNodeSelectorLike(LabelSelector item) {
        return new NodeSelectorNestedImpl(item);
    }

    @Override
    public NodePlacementFluent.NodeSelectorNested<A> editNodeSelector() {
        return this.withNewNodeSelectorLike(this.getNodeSelector());
    }

    @Override
    public NodePlacementFluent.NodeSelectorNested<A> editOrNewNodeSelector() {
        return this.withNewNodeSelectorLike(this.getNodeSelector() != null ? this.getNodeSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public NodePlacementFluent.NodeSelectorNested<A> editOrNewNodeSelectorLike(LabelSelector item) {
        return this.withNewNodeSelectorLike(this.getNodeSelector() != null ? this.getNodeSelector() : item);
    }

    @Override
    public A addToTolerations(Integer index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTolerations(Integer index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(Toleration ... items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    @Override
    public Toleration getToleration(Integer index) {
        return this.tolerations.get(index);
    }

    @Override
    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    @Override
    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    @Override
    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTolerations(List<Toleration> tolerations) {
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    @Override
    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePlacementFluentImpl that = (NodePlacementFluentImpl)o;
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        if (this.tolerations != null ? !this.tolerations.equals(that.tolerations) : that.tolerations != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.nodeSelector, this.tolerations, this.additionalProperties, super.hashCode());
    }

    public class NodeSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<NodePlacementFluent.NodeSelectorNested<N>>
    implements NodePlacementFluent.NodeSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        NodeSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        NodeSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodePlacementFluentImpl.this.withNodeSelector(this.builder.build());
        }

        @Override
        public N endNodeSelector() {
            return this.and();
        }
    }
}

