/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_11.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v5_11.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_11.monitoring.v1.Rule;
import io.fabric8.openshift.api.model.v5_11.monitoring.v1.RuleFluent;
import io.fabric8.openshift.api.model.v5_11.monitoring.v1.RuleFluentImpl;
import java.util.Objects;

public class RuleBuilder
extends RuleFluentImpl<RuleBuilder>
implements VisitableBuilder<Rule, RuleBuilder> {
    RuleFluent<?> fluent;
    Boolean validationEnabled;

    public RuleBuilder() {
        this(false);
    }

    public RuleBuilder(Boolean validationEnabled) {
        this(new Rule(), validationEnabled);
    }

    public RuleBuilder(RuleFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public RuleBuilder(RuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Rule(), validationEnabled);
    }

    public RuleBuilder(RuleFluent<?> fluent, Rule instance) {
        this(fluent, instance, false);
    }

    public RuleBuilder(RuleFluent<?> fluent, Rule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAlert(instance.getAlert());
        fluent.withAnnotations(instance.getAnnotations());
        fluent.withExpr(instance.getExpr());
        fluent.withFor(instance.getFor());
        fluent.withLabels(instance.getLabels());
        fluent.withRecord(instance.getRecord());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public RuleBuilder(Rule instance) {
        this(instance, (Boolean)false);
    }

    public RuleBuilder(Rule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAlert(instance.getAlert());
        this.withAnnotations(instance.getAnnotations());
        this.withExpr(instance.getExpr());
        this.withFor(instance.getFor());
        this.withLabels(instance.getLabels());
        this.withRecord(instance.getRecord());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Rule build() {
        Rule buildable = new Rule(this.fluent.getAlert(), this.fluent.getAnnotations(), this.fluent.getExpr(), this.fluent.getFor(), this.fluent.getLabels(), this.fluent.getRecord());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuleBuilder that = (RuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

