/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_11;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.kubernetes.api.model.v5_11.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_11.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v5_11.LabelSelectorFluentImpl;
import io.fabric8.openshift.api.model.v5_11.MaxAgePolicy;
import io.fabric8.openshift.api.model.v5_11.MaxAgePolicyBuilder;
import io.fabric8.openshift.api.model.v5_11.MaxAgePolicyFluentImpl;
import io.fabric8.openshift.api.model.v5_11.RequiredHSTSPolicy;
import io.fabric8.openshift.api.model.v5_11.RequiredHSTSPolicyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RequiredHSTSPolicyFluentImpl<A extends RequiredHSTSPolicyFluent<A>>
extends BaseFluent<A>
implements RequiredHSTSPolicyFluent<A> {
    private List<String> domainPatterns = new ArrayList<String>();
    private String includeSubDomainsPolicy;
    private MaxAgePolicyBuilder maxAge;
    private LabelSelectorBuilder namespaceSelector;
    private String preloadPolicy;
    private Map<String, Object> additionalProperties;

    public RequiredHSTSPolicyFluentImpl() {
    }

    public RequiredHSTSPolicyFluentImpl(RequiredHSTSPolicy instance) {
        this.withDomainPatterns(instance.getDomainPatterns());
        this.withIncludeSubDomainsPolicy(instance.getIncludeSubDomainsPolicy());
        this.withMaxAge(instance.getMaxAge());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withPreloadPolicy(instance.getPreloadPolicy());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToDomainPatterns(Integer index, String item) {
        if (this.domainPatterns == null) {
            this.domainPatterns = new ArrayList<String>();
        }
        this.domainPatterns.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDomainPatterns(Integer index, String item) {
        if (this.domainPatterns == null) {
            this.domainPatterns = new ArrayList<String>();
        }
        this.domainPatterns.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDomainPatterns(String ... items) {
        if (this.domainPatterns == null) {
            this.domainPatterns = new ArrayList<String>();
        }
        for (String item : items) {
            this.domainPatterns.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDomainPatterns(Collection<String> items) {
        if (this.domainPatterns == null) {
            this.domainPatterns = new ArrayList<String>();
        }
        for (String item : items) {
            this.domainPatterns.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDomainPatterns(String ... items) {
        for (String item : items) {
            if (this.domainPatterns == null) continue;
            this.domainPatterns.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDomainPatterns(Collection<String> items) {
        for (String item : items) {
            if (this.domainPatterns == null) continue;
            this.domainPatterns.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDomainPatterns() {
        return this.domainPatterns;
    }

    @Override
    public String getDomainPattern(Integer index) {
        return this.domainPatterns.get(index);
    }

    @Override
    public String getFirstDomainPattern() {
        return this.domainPatterns.get(0);
    }

    @Override
    public String getLastDomainPattern() {
        return this.domainPatterns.get(this.domainPatterns.size() - 1);
    }

    @Override
    public String getMatchingDomainPattern(Predicate<String> predicate) {
        for (String item : this.domainPatterns) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDomainPattern(Predicate<String> predicate) {
        for (String item : this.domainPatterns) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDomainPatterns(List<String> domainPatterns) {
        if (domainPatterns != null) {
            this.domainPatterns = new ArrayList<String>();
            for (String item : domainPatterns) {
                this.addToDomainPatterns(item);
            }
        } else {
            this.domainPatterns = null;
        }
        return (A)this;
    }

    @Override
    public A withDomainPatterns(String ... domainPatterns) {
        if (this.domainPatterns != null) {
            this.domainPatterns.clear();
        }
        if (domainPatterns != null) {
            for (String item : domainPatterns) {
                this.addToDomainPatterns(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDomainPatterns() {
        return this.domainPatterns != null && !this.domainPatterns.isEmpty();
    }

    @Override
    public A addNewDomainPattern(String arg0) {
        return this.addToDomainPatterns(new String(arg0));
    }

    @Override
    public String getIncludeSubDomainsPolicy() {
        return this.includeSubDomainsPolicy;
    }

    @Override
    public A withIncludeSubDomainsPolicy(String includeSubDomainsPolicy) {
        this.includeSubDomainsPolicy = includeSubDomainsPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasIncludeSubDomainsPolicy() {
        return this.includeSubDomainsPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewIncludeSubDomainsPolicy(String arg0) {
        return this.withIncludeSubDomainsPolicy(new String(arg0));
    }

    @Override
    @Deprecated
    public MaxAgePolicy getMaxAge() {
        return this.maxAge != null ? this.maxAge.build() : null;
    }

    @Override
    public MaxAgePolicy buildMaxAge() {
        return this.maxAge != null ? this.maxAge.build() : null;
    }

    @Override
    public A withMaxAge(MaxAgePolicy maxAge) {
        this._visitables.get("maxAge").remove(this.maxAge);
        if (maxAge != null) {
            this.maxAge = new MaxAgePolicyBuilder(maxAge);
            this._visitables.get("maxAge").add(this.maxAge);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMaxAge() {
        return this.maxAge != null;
    }

    @Override
    public A withNewMaxAge(Integer largestMaxAge, Integer smallestMaxAge) {
        return this.withMaxAge(new MaxAgePolicy(largestMaxAge, smallestMaxAge));
    }

    @Override
    public RequiredHSTSPolicyFluent.MaxAgeNested<A> withNewMaxAge() {
        return new MaxAgeNestedImpl();
    }

    @Override
    public RequiredHSTSPolicyFluent.MaxAgeNested<A> withNewMaxAgeLike(MaxAgePolicy item) {
        return new MaxAgeNestedImpl(item);
    }

    @Override
    public RequiredHSTSPolicyFluent.MaxAgeNested<A> editMaxAge() {
        return this.withNewMaxAgeLike(this.getMaxAge());
    }

    @Override
    public RequiredHSTSPolicyFluent.MaxAgeNested<A> editOrNewMaxAge() {
        return this.withNewMaxAgeLike(this.getMaxAge() != null ? this.getMaxAge() : new MaxAgePolicyBuilder().build());
    }

    @Override
    public RequiredHSTSPolicyFluent.MaxAgeNested<A> editOrNewMaxAgeLike(MaxAgePolicy item) {
        return this.withNewMaxAgeLike(this.getMaxAge() != null ? this.getMaxAge() : item);
    }

    @Override
    @Deprecated
    public LabelSelector getNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector != null) {
            this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
            this._visitables.get("namespaceSelector").add(this.namespaceSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    @Override
    public RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNestedImpl();
    }

    @Override
    public RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNestedImpl(item);
    }

    @Override
    public RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector());
    }

    @Override
    public RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : item);
    }

    @Override
    public String getPreloadPolicy() {
        return this.preloadPolicy;
    }

    @Override
    public A withPreloadPolicy(String preloadPolicy) {
        this.preloadPolicy = preloadPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasPreloadPolicy() {
        return this.preloadPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewPreloadPolicy(String arg0) {
        return this.withPreloadPolicy(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequiredHSTSPolicyFluentImpl that = (RequiredHSTSPolicyFluentImpl)o;
        if (this.domainPatterns != null ? !this.domainPatterns.equals(that.domainPatterns) : that.domainPatterns != null) {
            return false;
        }
        if (this.includeSubDomainsPolicy != null ? !this.includeSubDomainsPolicy.equals(that.includeSubDomainsPolicy) : that.includeSubDomainsPolicy != null) {
            return false;
        }
        if (this.maxAge != null ? !this.maxAge.equals(that.maxAge) : that.maxAge != null) {
            return false;
        }
        if (this.namespaceSelector != null ? !this.namespaceSelector.equals(that.namespaceSelector) : that.namespaceSelector != null) {
            return false;
        }
        if (this.preloadPolicy != null ? !this.preloadPolicy.equals(that.preloadPolicy) : that.preloadPolicy != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.domainPatterns, this.includeSubDomainsPolicy, this.maxAge, this.namespaceSelector, this.preloadPolicy, this.additionalProperties, super.hashCode());
    }

    public class NamespaceSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<RequiredHSTSPolicyFluent.NamespaceSelectorNested<N>>
    implements RequiredHSTSPolicyFluent.NamespaceSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        NamespaceSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        NamespaceSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)RequiredHSTSPolicyFluentImpl.this.withNamespaceSelector(this.builder.build());
        }

        @Override
        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class MaxAgeNestedImpl<N>
    extends MaxAgePolicyFluentImpl<RequiredHSTSPolicyFluent.MaxAgeNested<N>>
    implements RequiredHSTSPolicyFluent.MaxAgeNested<N>,
    Nested<N> {
        MaxAgePolicyBuilder builder;

        MaxAgeNestedImpl(MaxAgePolicy item) {
            this.builder = new MaxAgePolicyBuilder(this, item);
        }

        MaxAgeNestedImpl() {
            this.builder = new MaxAgePolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)RequiredHSTSPolicyFluentImpl.this.withMaxAge(this.builder.build());
        }

        @Override
        public N endMaxAge() {
            return this.and();
        }
    }
}

