/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_11;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.kubernetes.api.model.v5_11.Condition;
import io.fabric8.openshift.api.model.v5_11.ConditionalUpdate;
import io.fabric8.openshift.api.model.v5_11.ConditionalUpdateFluent;
import io.fabric8.openshift.api.model.v5_11.ConditionalUpdateRisk;
import io.fabric8.openshift.api.model.v5_11.ConditionalUpdateRiskBuilder;
import io.fabric8.openshift.api.model.v5_11.ConditionalUpdateRiskFluentImpl;
import io.fabric8.openshift.api.model.v5_11.Release;
import io.fabric8.openshift.api.model.v5_11.ReleaseBuilder;
import io.fabric8.openshift.api.model.v5_11.ReleaseFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ConditionalUpdateFluentImpl<A extends ConditionalUpdateFluent<A>>
extends BaseFluent<A>
implements ConditionalUpdateFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private ReleaseBuilder release;
    private List<ConditionalUpdateRiskBuilder> risks = new ArrayList<ConditionalUpdateRiskBuilder>();
    private Map<String, Object> additionalProperties;

    public ConditionalUpdateFluentImpl() {
    }

    public ConditionalUpdateFluentImpl(ConditionalUpdate instance) {
        this.withConditions(instance.getConditions());
        this.withRelease(instance.getRelease());
        this.withRisks(instance.getRisks());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public Condition getCondition(Integer index) {
        return this.conditions.get(index);
    }

    @Override
    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    @Override
    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    @Override
    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    @Deprecated
    public Release getRelease() {
        return this.release != null ? this.release.build() : null;
    }

    @Override
    public Release buildRelease() {
        return this.release != null ? this.release.build() : null;
    }

    @Override
    public A withRelease(Release release) {
        this._visitables.get("release").remove(this.release);
        if (release != null) {
            this.release = new ReleaseBuilder(release);
            this._visitables.get("release").add(this.release);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRelease() {
        return this.release != null;
    }

    @Override
    public ConditionalUpdateFluent.ReleaseNested<A> withNewRelease() {
        return new ReleaseNestedImpl();
    }

    @Override
    public ConditionalUpdateFluent.ReleaseNested<A> withNewReleaseLike(Release item) {
        return new ReleaseNestedImpl(item);
    }

    @Override
    public ConditionalUpdateFluent.ReleaseNested<A> editRelease() {
        return this.withNewReleaseLike(this.getRelease());
    }

    @Override
    public ConditionalUpdateFluent.ReleaseNested<A> editOrNewRelease() {
        return this.withNewReleaseLike(this.getRelease() != null ? this.getRelease() : new ReleaseBuilder().build());
    }

    @Override
    public ConditionalUpdateFluent.ReleaseNested<A> editOrNewReleaseLike(Release item) {
        return this.withNewReleaseLike(this.getRelease() != null ? this.getRelease() : item);
    }

    @Override
    public A addToRisks(Integer index, ConditionalUpdateRisk item) {
        if (this.risks == null) {
            this.risks = new ArrayList<ConditionalUpdateRiskBuilder>();
        }
        ConditionalUpdateRiskBuilder builder = new ConditionalUpdateRiskBuilder(item);
        this._visitables.get("risks").add(index >= 0 ? index.intValue() : this._visitables.get("risks").size(), builder);
        this.risks.add(index >= 0 ? index.intValue() : this.risks.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRisks(Integer index, ConditionalUpdateRisk item) {
        if (this.risks == null) {
            this.risks = new ArrayList<ConditionalUpdateRiskBuilder>();
        }
        ConditionalUpdateRiskBuilder builder = new ConditionalUpdateRiskBuilder(item);
        if (index < 0 || index >= this._visitables.get("risks").size()) {
            this._visitables.get("risks").add(builder);
        } else {
            this._visitables.get("risks").set(index, builder);
        }
        if (index < 0 || index >= this.risks.size()) {
            this.risks.add(builder);
        } else {
            this.risks.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRisks(ConditionalUpdateRisk ... items) {
        if (this.risks == null) {
            this.risks = new ArrayList<ConditionalUpdateRiskBuilder>();
        }
        for (ConditionalUpdateRisk item : items) {
            ConditionalUpdateRiskBuilder builder = new ConditionalUpdateRiskBuilder(item);
            this._visitables.get("risks").add(builder);
            this.risks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRisks(Collection<ConditionalUpdateRisk> items) {
        if (this.risks == null) {
            this.risks = new ArrayList<ConditionalUpdateRiskBuilder>();
        }
        for (ConditionalUpdateRisk item : items) {
            ConditionalUpdateRiskBuilder builder = new ConditionalUpdateRiskBuilder(item);
            this._visitables.get("risks").add(builder);
            this.risks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRisks(ConditionalUpdateRisk ... items) {
        for (ConditionalUpdateRisk item : items) {
            ConditionalUpdateRiskBuilder builder = new ConditionalUpdateRiskBuilder(item);
            this._visitables.get("risks").remove(builder);
            if (this.risks == null) continue;
            this.risks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRisks(Collection<ConditionalUpdateRisk> items) {
        for (ConditionalUpdateRisk item : items) {
            ConditionalUpdateRiskBuilder builder = new ConditionalUpdateRiskBuilder(item);
            this._visitables.get("risks").remove(builder);
            if (this.risks == null) continue;
            this.risks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRisks(Predicate<ConditionalUpdateRiskBuilder> predicate) {
        if (this.risks == null) {
            return (A)this;
        }
        Iterator<ConditionalUpdateRiskBuilder> each = this.risks.iterator();
        Object visitables = this._visitables.get("risks");
        while (each.hasNext()) {
            ConditionalUpdateRiskBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ConditionalUpdateRisk> getRisks() {
        return ConditionalUpdateFluentImpl.build(this.risks);
    }

    @Override
    public List<ConditionalUpdateRisk> buildRisks() {
        return ConditionalUpdateFluentImpl.build(this.risks);
    }

    @Override
    public ConditionalUpdateRisk buildRisk(Integer index) {
        return this.risks.get(index).build();
    }

    @Override
    public ConditionalUpdateRisk buildFirstRisk() {
        return this.risks.get(0).build();
    }

    @Override
    public ConditionalUpdateRisk buildLastRisk() {
        return this.risks.get(this.risks.size() - 1).build();
    }

    @Override
    public ConditionalUpdateRisk buildMatchingRisk(Predicate<ConditionalUpdateRiskBuilder> predicate) {
        for (ConditionalUpdateRiskBuilder item : this.risks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRisk(Predicate<ConditionalUpdateRiskBuilder> predicate) {
        for (ConditionalUpdateRiskBuilder item : this.risks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRisks(List<ConditionalUpdateRisk> risks) {
        if (this.risks != null) {
            this._visitables.get("risks").removeAll(this.risks);
        }
        if (risks != null) {
            this.risks = new ArrayList<ConditionalUpdateRiskBuilder>();
            for (ConditionalUpdateRisk item : risks) {
                this.addToRisks(item);
            }
        } else {
            this.risks = null;
        }
        return (A)this;
    }

    @Override
    public A withRisks(ConditionalUpdateRisk ... risks) {
        if (this.risks != null) {
            this.risks.clear();
        }
        if (risks != null) {
            for (ConditionalUpdateRisk item : risks) {
                this.addToRisks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRisks() {
        return this.risks != null && !this.risks.isEmpty();
    }

    @Override
    public ConditionalUpdateFluent.RisksNested<A> addNewRisk() {
        return new RisksNestedImpl();
    }

    @Override
    public ConditionalUpdateFluent.RisksNested<A> addNewRiskLike(ConditionalUpdateRisk item) {
        return new RisksNestedImpl(-1, item);
    }

    @Override
    public ConditionalUpdateFluent.RisksNested<A> setNewRiskLike(Integer index, ConditionalUpdateRisk item) {
        return new RisksNestedImpl(index, item);
    }

    @Override
    public ConditionalUpdateFluent.RisksNested<A> editRisk(Integer index) {
        if (this.risks.size() <= index) {
            throw new RuntimeException("Can't edit risks. Index exceeds size.");
        }
        return this.setNewRiskLike(index, this.buildRisk(index));
    }

    @Override
    public ConditionalUpdateFluent.RisksNested<A> editFirstRisk() {
        if (this.risks.size() == 0) {
            throw new RuntimeException("Can't edit first risks. The list is empty.");
        }
        return this.setNewRiskLike(0, this.buildRisk(0));
    }

    @Override
    public ConditionalUpdateFluent.RisksNested<A> editLastRisk() {
        int index = this.risks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last risks. The list is empty.");
        }
        return this.setNewRiskLike(index, this.buildRisk(index));
    }

    @Override
    public ConditionalUpdateFluent.RisksNested<A> editMatchingRisk(Predicate<ConditionalUpdateRiskBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.risks.size(); ++i) {
            if (!predicate.test(this.risks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching risks. No match found.");
        }
        return this.setNewRiskLike(index, this.buildRisk(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionalUpdateFluentImpl that = (ConditionalUpdateFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.release != null ? !this.release.equals(that.release) : that.release != null) {
            return false;
        }
        if (this.risks != null ? !this.risks.equals(that.risks) : that.risks != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.release, this.risks, this.additionalProperties, super.hashCode());
    }

    public class RisksNestedImpl<N>
    extends ConditionalUpdateRiskFluentImpl<ConditionalUpdateFluent.RisksNested<N>>
    implements ConditionalUpdateFluent.RisksNested<N>,
    Nested<N> {
        ConditionalUpdateRiskBuilder builder;
        Integer index;

        RisksNestedImpl(Integer index, ConditionalUpdateRisk item) {
            this.index = index;
            this.builder = new ConditionalUpdateRiskBuilder(this, item);
        }

        RisksNestedImpl() {
            this.index = -1;
            this.builder = new ConditionalUpdateRiskBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConditionalUpdateFluentImpl.this.setToRisks(this.index, this.builder.build());
        }

        @Override
        public N endRisk() {
            return this.and();
        }
    }

    public class ReleaseNestedImpl<N>
    extends ReleaseFluentImpl<ConditionalUpdateFluent.ReleaseNested<N>>
    implements ConditionalUpdateFluent.ReleaseNested<N>,
    Nested<N> {
        ReleaseBuilder builder;

        ReleaseNestedImpl(Release item) {
            this.builder = new ReleaseBuilder(this, item);
        }

        ReleaseNestedImpl() {
            this.builder = new ReleaseBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConditionalUpdateFluentImpl.this.withRelease(this.builder.build());
        }

        @Override
        public N endRelease() {
            return this.and();
        }
    }
}

