/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_11;

import io.fabric8.kubernetes.api.builder.v5_11.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_11.ClusterVersion;
import io.fabric8.openshift.api.model.v5_11.ClusterVersionFluent;
import io.fabric8.openshift.api.model.v5_11.ClusterVersionFluentImpl;
import java.util.Objects;

public class ClusterVersionBuilder
extends ClusterVersionFluentImpl<ClusterVersionBuilder>
implements VisitableBuilder<ClusterVersion, ClusterVersionBuilder> {
    ClusterVersionFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterVersionBuilder() {
        this(false);
    }

    public ClusterVersionBuilder(Boolean validationEnabled) {
        this(new ClusterVersion(), validationEnabled);
    }

    public ClusterVersionBuilder(ClusterVersionFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ClusterVersionBuilder(ClusterVersionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterVersion(), validationEnabled);
    }

    public ClusterVersionBuilder(ClusterVersionFluent<?> fluent, ClusterVersion instance) {
        this(fluent, instance, false);
    }

    public ClusterVersionBuilder(ClusterVersionFluent<?> fluent, ClusterVersion instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ClusterVersionBuilder(ClusterVersion instance) {
        this(instance, (Boolean)false);
    }

    public ClusterVersionBuilder(ClusterVersion instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ClusterVersion build() {
        ClusterVersion buildable = new ClusterVersion(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterVersionBuilder that = (ClusterVersionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

