/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_11.okhttp;

import io.fabric8.kubernetes.clnt.v5_11.http.HttpRequest;
import io.fabric8.kubernetes.clnt.v5_11.okhttp.OkHttpClientImpl;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

class OkHttpRequestImpl
implements HttpRequest {
    private Request request;

    public OkHttpRequestImpl(Request request) {
        this.request = request;
    }

    @Override
    public URI uri() {
        return this.request.url().uri();
    }

    @Override
    public String method() {
        return this.request.method();
    }

    public Request getRequest() {
        return this.request;
    }

    @Override
    public List<String> headers(String key) {
        return this.request.headers(key);
    }

    @Override
    public String bodyString() {
        if (this.request.body() == null) {
            return null;
        }
        Buffer buffer = new Buffer();
        try {
            this.request.body().writeTo((BufferedSink)buffer);
        }
        catch (IOException e) {
            return null;
        }
        return buffer.readUtf8();
    }

    static class BuilderImpl
    implements HttpRequest.Builder {
        private Request.Builder builder;

        public BuilderImpl() {
            this(new Request.Builder());
        }

        public BuilderImpl(Request.Builder builder) {
            this.builder = builder;
        }

        @Override
        public HttpRequest build() {
            return new OkHttpRequestImpl(this.builder.build());
        }

        @Override
        public HttpRequest.Builder uri(String uri) {
            this.builder.url(uri);
            return this;
        }

        @Override
        public HttpRequest.Builder url(URL resourceUrl) {
            this.builder.url(resourceUrl);
            return this;
        }

        @Override
        public HttpRequest.Builder method(String method, String contentType, String body) {
            this.builder.method(method, RequestBody.create((MediaType)OkHttpClientImpl.parseMediaType(contentType), (String)body));
            return this;
        }

        @Override
        public HttpRequest.Builder post(String contentType, byte[] writeValueAsBytes) {
            this.builder.post(RequestBody.create((MediaType)OkHttpClientImpl.parseMediaType(contentType), (byte[])writeValueAsBytes));
            return this;
        }

        @Override
        public HttpRequest.Builder post(final String contentType, final InputStream inputStream, final long length) {
            this.builder.post(new RequestBody(){

                public void writeTo(BufferedSink sink) throws IOException {
                    try (BufferedInputStream bis = new BufferedInputStream(inputStream);
                         Source source = Okio.source((InputStream)bis);){
                        sink.writeAll(source);
                    }
                }

                public MediaType contentType() {
                    return OkHttpClientImpl.parseMediaType(contentType);
                }

                public long contentLength() throws IOException {
                    return length;
                }
            });
            return this;
        }

        @Override
        public HttpRequest.Builder header(String k, String v) {
            this.builder.addHeader(k, v);
            return this;
        }

        @Override
        public HttpRequest.Builder setHeader(String k, String v) {
            this.builder.header(k, v);
            return this;
        }

        @Override
        public HttpRequest.Builder uri(URI uri) {
            try {
                this.builder.url(uri.toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(uri.toString(), e);
            }
            return this;
        }

        @Override
        public HttpRequest.Builder expectContinue() {
            this.builder.header("Expect", "100-continue");
            return this;
        }
    }
}

