/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_11.extended.leaderelection;

import io.fabric8.kubernetes.clnt.v5_11.KubernetesClient;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Namespaceable;
import io.fabric8.kubernetes.clnt.v5_11.extended.leaderelection.LeaderElectionConfig;
import io.fabric8.kubernetes.clnt.v5_11.extended.leaderelection.LeaderElector;
import java.time.Duration;
import java.util.Objects;

public class LeaderElectorBuilder<C extends Namespaceable<C> & KubernetesClient> {
    private final C client;
    private LeaderElectionConfig leaderElectionConfig;

    public LeaderElectorBuilder(C client) {
        this.client = client;
    }

    public LeaderElectorBuilder<C> withConfig(LeaderElectionConfig leaderElectionConfig) {
        this.leaderElectionConfig = LeaderElectorBuilder.validate(leaderElectionConfig);
        return this;
    }

    public LeaderElector<C> build() {
        return new LeaderElector<C>(this.client, this.leaderElectionConfig);
    }

    private static LeaderElectionConfig validate(LeaderElectionConfig leaderElectionConfig) {
        Objects.requireNonNull(leaderElectionConfig, "LeaderElectionConfig is required");
        Objects.requireNonNull(leaderElectionConfig.getName(), "name is required");
        Objects.requireNonNull(leaderElectionConfig.getLeaseDuration(), "leaseDuration is required");
        Objects.requireNonNull(leaderElectionConfig.getRenewDeadline(), "renewDeadLine is required");
        Objects.requireNonNull(leaderElectionConfig.getRetryPeriod(), "retryPeriod is required");
        Objects.requireNonNull(leaderElectionConfig.getLeaderCallbacks(), "leaderCallbacks are required");
        Objects.requireNonNull(leaderElectionConfig.getLock(), "lock is required");
        if (leaderElectionConfig.getLeaseDuration().compareTo(leaderElectionConfig.getRenewDeadline()) <= 0) {
            throw new IllegalArgumentException("leaseDuration must be greater than renewDeadLine");
        }
        Duration maxRetryPeriod = leaderElectionConfig.getRetryPeriod().plusMillis((long)Math.ceil((double)leaderElectionConfig.getRetryPeriod().toMillis() * LeaderElector.JITTER_FACTOR));
        if (leaderElectionConfig.getRenewDeadline().compareTo(maxRetryPeriod) <= 0) {
            throw new IllegalArgumentException("renewDeadline must be greater than retryPeriod + retryPeriod*JITTER_FACTOR");
        }
        if (leaderElectionConfig.getLeaseDuration().toMillis() < 1L) {
            throw new IllegalArgumentException("leaseDuration must be greater than zero");
        }
        if (leaderElectionConfig.getRenewDeadline().toMillis() < 1L) {
            throw new IllegalArgumentException("renewDeadline must be greater than zero");
        }
        if (leaderElectionConfig.getRetryPeriod().toMillis() < 1L) {
            throw new IllegalArgumentException("retryPeriod must be greater than zero");
        }
        return leaderElectionConfig;
    }
}

