/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_11.dsl.internal.batch.v1;

import io.fabric8.kubernetes.api.model.v5_11.Pod;
import io.fabric8.kubernetes.api.model.v5_11.autoscaling.v1.Scale;
import io.fabric8.kubernetes.api.model.v5_11.batch.v1.Job;
import io.fabric8.kubernetes.api.model.v5_11.batch.v1.JobList;
import io.fabric8.kubernetes.clnt.v5_11.ClientContext;
import io.fabric8.kubernetes.clnt.v5_11.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_11.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Loggable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v5_11.dsl.ScalableResource;
import io.fabric8.kubernetes.clnt.v5_11.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_11.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_11.dsl.internal.PodControllerOperationContext;
import io.fabric8.kubernetes.clnt.v5_11.utils.PodOperationUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobOperationsImpl
extends HasMetadataOperation<Job, JobList, ScalableResource<Job>>
implements ScalableResource<Job> {
    static final transient Logger LOG = LoggerFactory.getLogger(JobOperationsImpl.class);
    private final PodControllerOperationContext podControllerOperationContext;

    public JobOperationsImpl(ClientContext clientContext) {
        this(clientContext, null);
    }

    public JobOperationsImpl(ClientContext clientContext, String namespace) {
        this(new PodControllerOperationContext(), HasMetadataOperationsImpl.defaultContext(clientContext).withNamespace(namespace));
    }

    public JobOperationsImpl(PodControllerOperationContext context, OperationContext superContext) {
        super(superContext.withApiGroupName("batch").withApiGroupVersion("v1").withPlural("jobs"), Job.class, JobList.class);
        this.podControllerOperationContext = context;
    }

    public JobOperationsImpl newInstance(OperationContext context) {
        return new JobOperationsImpl(this.podControllerOperationContext, context);
    }

    @Override
    public ScalableResource<Job> load(InputStream is) {
        try {
            Job item = JobOperationsImpl.unmarshal(is, Job.class);
            return this.newInstance(this.context.withItem(item));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public ScalableResource<Job> fromServer() {
        return this.newInstance(this.context.withReloadingFromServer(true));
    }

    @Override
    public Job scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public Scale scale() {
        return this.handleScale(null);
    }

    @Override
    public Scale scale(Scale scale) {
        return this.handleScale(scale);
    }

    @Override
    public Job scale(int count, boolean wait) {
        Job res = (Job)this.accept(b -> b.getSpec().setParallelism(count));
        if (wait) {
            this.waitUntilJobIsScaled();
            res = (Job)this.getMandatory();
        }
        return res;
    }

    private void waitUntilJobIsScaled() {
        AtomicReference atomicJob = new AtomicReference();
        this.waitUntilCondition(job -> {
            atomicJob.set(job);
            Integer activeJobs = job.getStatus().getActive();
            if (activeJobs == null) {
                activeJobs = 0;
            }
            if (Objects.equals(job.getSpec().getParallelism(), activeJobs)) {
                return true;
            }
            LOG.debug("Only {}/{} pods scheduled for Job: {} in namespace: {} seconds so waiting...", new Object[]{job.getStatus().getActive(), job.getSpec().getParallelism(), job.getMetadata().getName(), this.namespace});
            return false;
        }, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public String getLog() {
        return this.getLog(false);
    }

    @Override
    public String getLog(Boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<PodResource<Pod>> podOperationList = this.doGetLog(false);
        for (PodResource<Pod> podOperation : podOperationList) {
            stringBuilder.append(podOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<PodResource<Pod>> doGetLog(boolean isPretty) {
        Job job = (Job)this.requireFromServer();
        return PodOperationUtil.getPodOperationsForController(this.context, job.getMetadata().getUid(), JobOperationsImpl.getJobPodLabels(job), isPretty, this.podControllerOperationContext.getLogWaitTimeout(), this.podControllerOperationContext.getContainerId());
    }

    @Override
    public Reader getLogReader() {
        return PodOperationUtil.getLogReader(this.doGetLog(false));
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        return PodOperationUtil.watchLog(this.doGetLog(false), out);
    }

    @Override
    public Loggable<LogWatch> withLogWaitTimeout(Integer logWaitTimeout) {
        return new JobOperationsImpl(this.podControllerOperationContext.withLogWaitTimout(logWaitTimeout), this.context);
    }

    @Override
    public Job replace(Job job) {
        if (job == null) {
            job = (Job)this.getItem();
        }
        Job jobFromServer = (Job)this.requireFromServer();
        if (job.getSpec().getSelector() == null) {
            job.getSpec().setSelector(jobFromServer.getSpec().getSelector());
        }
        if (job.getSpec().getTemplate().getMetadata() != null) {
            job.getSpec().getTemplate().getMetadata().setLabels(jobFromServer.getSpec().getTemplate().getMetadata().getLabels());
        } else {
            job.getSpec().getTemplate().setMetadata(jobFromServer.getSpec().getTemplate().getMetadata());
        }
        return super.replace(job);
    }

    static Map<String, String> getJobPodLabels(Job job) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (job != null && job.getMetadata() != null && job.getMetadata().getUid() != null) {
            labels.put("controller-uid", job.getMetadata().getUid());
        }
        return labels;
    }

    @Override
    public Loggable<LogWatch> inContainer(String id) {
        return new JobOperationsImpl(this.podControllerOperationContext.withContainerId(id), this.context);
    }
}

