/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_11.dsl.internal.apps.v1;

import io.fabric8.kubernetes.api.model.v5_11.Container;
import io.fabric8.kubernetes.api.model.v5_11.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_11.Pod;
import io.fabric8.kubernetes.api.model.v5_11.Status;
import io.fabric8.kubernetes.api.model.v5_11.apps.ControllerRevision;
import io.fabric8.kubernetes.api.model.v5_11.apps.ControllerRevisionList;
import io.fabric8.kubernetes.api.model.v5_11.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.v5_11.apps.StatefulSetList;
import io.fabric8.kubernetes.api.model.v5_11.extensions.DeploymentRollback;
import io.fabric8.kubernetes.clnt.v5_11.ClientContext;
import io.fabric8.kubernetes.clnt.v5_11.Handlers;
import io.fabric8.kubernetes.clnt.v5_11.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_11.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v5_11.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v5_11.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v5_11.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_11.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_11.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.clnt.v5_11.dsl.internal.apps.v1.RollableScalableResourceOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.clnt.v5_11.dsl.internal.apps.v1.StatefulSetRollingUpdater;
import io.fabric8.kubernetes.clnt.v5_11.utils.PodOperationUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class StatefulSetOperationsImpl
extends RollableScalableResourceOperation<StatefulSet, StatefulSetList, RollableScalableResource<StatefulSet>>
implements TimeoutImageEditReplacePatchable<StatefulSet> {
    public StatefulSetOperationsImpl(ClientContext clientContext) {
        this(clientContext, null);
    }

    public StatefulSetOperationsImpl(ClientContext clientContext, String namespace) {
        this(new RollingOperationContext(), HasMetadataOperationsImpl.defaultContext(clientContext).withNamespace(namespace));
    }

    public StatefulSetOperationsImpl(RollingOperationContext context, OperationContext superContext) {
        super(context, superContext.withApiGroupName("apps").withApiGroupVersion("v1").withPlural("statefulsets"), StatefulSet.class, StatefulSetList.class);
    }

    public StatefulSetOperationsImpl newInstance(OperationContext context) {
        return new StatefulSetOperationsImpl(this.rollingOperationContext, context);
    }

    public StatefulSetOperationsImpl newInstance(RollingOperationContext context) {
        return new StatefulSetOperationsImpl(context, this.context);
    }

    @Override
    public StatefulSet withReplicas(int count) {
        return this.cascading(false).accept((T s) -> s.getSpec().setReplicas(count));
    }

    @Override
    public RollingUpdater<StatefulSet, StatefulSetList> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new StatefulSetRollingUpdater(this.context, this.getNamespace(), rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    public int getCurrentReplicas(StatefulSet current) {
        return current.getStatus().getReplicas();
    }

    @Override
    public int getDesiredReplicas(StatefulSet item) {
        return item.getSpec().getReplicas();
    }

    @Override
    public long getObservedGeneration(StatefulSet current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    @Override
    public StatefulSet updateImage(Map<String, String> containerToImageMap) {
        StatefulSet statefulSet = (StatefulSet)this.get();
        if (statefulSet == null) {
            throw new KubernetesClientException("Existing replica set doesn't exist");
        }
        if (statefulSet.getSpec().getTemplate().getSpec().getContainers().isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        List<Container> containers = statefulSet.getSpec().getTemplate().getSpec().getContainers();
        for (Container container : containers) {
            if (!containerToImageMap.containsKey(container.getName())) continue;
            container.setImage(containerToImageMap.get(container.getName()));
        }
        statefulSet.getSpec().getTemplate().getSpec().setContainers(containers);
        return this.sendPatchedObject(this.get(), statefulSet);
    }

    @Override
    public StatefulSet updateImage(String image) {
        StatefulSet oldRC = (StatefulSet)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing StatefulSet doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container container = oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next();
        return this.updateImage((Map)Collections.singletonMap(container.getName(), image));
    }

    @Override
    public Status rollback(DeploymentRollback deploymentRollback) {
        throw new KubernetesClientException("rollback not supported in case of StatefulSets");
    }

    @Override
    public String getLog(Boolean isPretty) {
        return PodOperationUtil.getLog(this.doGetLog(isPretty), isPretty);
    }

    private List<PodResource<Pod>> doGetLog(boolean isPretty) {
        StatefulSet statefulSet = (StatefulSet)this.requireFromServer();
        return PodOperationUtil.getPodOperationsForController(this.context, statefulSet.getMetadata().getUid(), StatefulSetOperationsImpl.getStatefulSetSelectorLabels(statefulSet), isPretty, this.rollingOperationContext.getLogWaitTimeout(), this.rollingOperationContext.getContainerId());
    }

    @Override
    public Reader getLogReader() {
        return PodOperationUtil.getLogReader(this.doGetLog(false));
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        return PodOperationUtil.watchLog(this.doGetLog(false), out);
    }

    @Override
    public StatefulSet pause() {
        return this.sendPatchedStatefulSet(RollingUpdater.requestPayLoadForRolloutPause());
    }

    @Override
    public StatefulSet resume() {
        return this.sendPatchedStatefulSet(RollingUpdater.requestPayLoadForRolloutResume());
    }

    @Override
    public StatefulSet restart() {
        return this.sendPatchedStatefulSet(RollingUpdater.requestPayLoadForRolloutRestart());
    }

    @Override
    public StatefulSet undo() {
        List<ControllerRevision> controllerRevisions = this.getControllerRevisionListForStatefulSet((StatefulSet)this.get()).getItems();
        if (controllerRevisions.size() < 2) {
            throw new IllegalStateException("No revision to rollback to!");
        }
        controllerRevisions.sort((o1, o2) -> {
            Long revision2 = o2.getRevision();
            Long revision1 = o1.getRevision();
            if (revision1 != null && revision2 != null) {
                return revision2.intValue() - revision1.intValue();
            }
            if (revision1 != null) {
                return revision1.intValue();
            }
            if (revision2 != null) {
                return revision2.intValue();
            }
            return 0;
        });
        ControllerRevision previousControllerRevision = controllerRevisions.get(1);
        return this.sendPatchedStatefulSetData(previousControllerRevision.getData());
    }

    private StatefulSet sendPatchedStatefulSet(Map<String, Object> patchedUpdate) {
        StatefulSet oldStatefulSet = (StatefulSet)this.get();
        try {
            return this.handlePatch(oldStatefulSet, patchedUpdate);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(interruptedException);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private StatefulSet sendPatchedStatefulSetData(HasMetadata patchedUpdate) {
        return this.sendPatchedStatefulSet(StatefulSetOperationsImpl.getObjectValueAsMap(patchedUpdate));
    }

    private ControllerRevisionList getControllerRevisionListForStatefulSet(StatefulSet statefulSet) {
        return (ControllerRevisionList)((FilterWatchListDeletable)Handlers.getOperation(ControllerRevision.class, ControllerRevisionList.class, this.context).inNamespace(this.namespace).withLabels(statefulSet.getSpec().getSelector().getMatchLabels())).list();
    }

    static Map<String, String> getStatefulSetSelectorLabels(StatefulSet statefulSet) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (statefulSet != null && statefulSet.getSpec() != null && statefulSet.getSpec().getTemplate() != null && statefulSet.getSpec().getTemplate().getMetadata() != null) {
            labels.putAll(statefulSet.getSpec().getTemplate().getMetadata().getLabels());
        }
        return labels;
    }
}

