/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_11.dsl.internal.apps.v1;

import io.fabric8.kubernetes.api.model.v5_11.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_11.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_11.autoscaling.v1.Scale;
import io.fabric8.kubernetes.clnt.v5_11.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_11.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.clnt.v5_11.dsl.ImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Loggable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_11.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v5_11.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_11.dsl.base.PatchContext;
import io.fabric8.kubernetes.clnt.v5_11.dsl.base.PatchType;
import io.fabric8.kubernetes.clnt.v5_11.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.clnt.v5_11.dsl.internal.apps.v1.RollingUpdater;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RollableScalableResourceOperation<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
extends HasMetadataOperation<T, L, R>
implements RollableScalableResource<T>,
TimeoutImageEditReplacePatchable<T> {
    private static final Logger Log = LoggerFactory.getLogger(RollableScalableResourceOperation.class);
    protected final RollingOperationContext rollingOperationContext;
    final boolean rolling;
    final long rollingTimeout;
    final TimeUnit rollingTimeUnit;

    protected RollableScalableResourceOperation(RollingOperationContext context, OperationContext superContext, Class<T> type, Class<L> listType) {
        super(superContext, type, listType);
        this.rollingOperationContext = context;
        this.rolling = context.getRolling();
        this.rollingTimeout = context.getRollingTimeout();
        this.rollingTimeUnit = context.getRollingTimeUnit();
    }

    protected abstract T withReplicas(int var1);

    protected abstract RollingUpdater<T, L> getRollingUpdater(long var1, TimeUnit var3);

    protected abstract int getCurrentReplicas(T var1);

    protected abstract int getDesiredReplicas(T var1);

    protected abstract long getObservedGeneration(T var1);

    @Override
    public T scale(int count) {
        return (T)this.scale(count, false);
    }

    @Override
    public T scale(int count, boolean wait) {
        T res = this.withReplicas(count);
        if (wait && (res = this.waitUntilScaled(count)) == null) {
            res = this.getMandatory();
        }
        return res;
    }

    @Override
    public Scale scale() {
        return this.handleScale(null);
    }

    @Override
    public Scale scale(Scale scaleParam) {
        return this.handleScale(scaleParam);
    }

    private T waitUntilScaled(int count) {
        AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        String namespace = this.checkNamespace(this.getItem());
        try {
            return (T)this.waitUntilCondition(t -> {
                if (t == null) {
                    if (count == 0) {
                        return true;
                    }
                    throw new IllegalStateException("Can't wait for " + this.getType().getSimpleName() + ": " + name + " in namespace: " + namespace + " to scale. Resource is no longer available.");
                }
                int currentReplicas = this.getCurrentReplicas(t);
                int desiredReplicas = this.getDesiredReplicas(t);
                replicasRef.set(currentReplicas);
                long generation = t.getMetadata().getGeneration() != null ? t.getMetadata().getGeneration() : -1L;
                long observedGeneration = this.getObservedGeneration(t);
                if (observedGeneration >= generation && Objects.equals(desiredReplicas, currentReplicas)) {
                    return true;
                }
                Log.debug("Only {}/{} replicas scheduled for {}: {} in namespace: {} seconds so waiting...", new Object[]{currentReplicas, desiredReplicas, t.getKind(), t.getMetadata().getName(), namespace});
                return false;
            }, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (KubernetesClientTimeoutException e) {
            Log.error("{}/{} pod(s) ready for {}: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{replicasRef.get(), count, this.getType().getSimpleName(), name, namespace, TimeUnit.MILLISECONDS.toSeconds(this.getConfig().getScaleTimeout())});
            return null;
        }
    }

    @Override
    public T edit(UnaryOperator<T> function) {
        if (!this.rolling) {
            return (T)super.edit(function);
        }
        try {
            Object oldObj = this.getMandatory();
            HasMetadata newObj = (HasMetadata)function.apply(oldObj);
            return (T)this.getRollingUpdater(this.rollingTimeout, this.rollingTimeUnit).rollUpdate((HasMetadata)oldObj, newObj);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public T replace(T t) {
        if (!this.rolling) {
            return super.replace(t);
        }
        return this.getRollingUpdater(this.rollingTimeout, this.rollingTimeUnit).rollUpdate(this.getMandatory(), t);
    }

    @Override
    public T patch(PatchContext patchContext, T item) {
        if (!this.rolling || patchContext == null || patchContext.getPatchType() != PatchType.JSON) {
            return super.patch(patchContext, item);
        }
        return this.getRollingUpdater(this.rollingTimeout, this.rollingTimeUnit).rollUpdate(this.getMandatory(), item);
    }

    public abstract RollableScalableResourceOperation<T, L, R> newInstance(RollingOperationContext var1);

    @Override
    public Loggable<LogWatch> withLogWaitTimeout(Integer logWaitTimeout) {
        return this.newInstance(this.rollingOperationContext.withLogWaitTimout(logWaitTimeout));
    }

    @Override
    public Loggable<LogWatch> inContainer(String id) {
        return this.newInstance(this.rollingOperationContext.withContainerId(id));
    }

    @Override
    public TimeoutImageEditReplacePatchable<T> rolling() {
        return this.newInstance(this.rollingOperationContext.withRolling(true));
    }

    @Override
    public ImageEditReplacePatchable<T> withTimeoutInMillis(long timeoutInMillis) {
        return this.newInstance(this.rollingOperationContext.withRollingTimeout(timeoutInMillis).withRollingTimeUnit(TimeUnit.MILLISECONDS));
    }

    @Override
    public ImageEditReplacePatchable<T> withTimeout(long timeout, TimeUnit unit) {
        return this.newInstance(this.rollingOperationContext.withRollingTimeout(timeout).withRollingTimeUnit(unit));
    }

    @Override
    public String getLog() {
        return this.getLog(false);
    }

    @Override
    public LogWatch watchLog() {
        return (LogWatch)this.watchLog(null);
    }
}

