/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_11.dsl.internal;

import io.fabric8.kubernetes.api.builder.v5_11.TypedVisitor;
import io.fabric8.kubernetes.api.builder.v5_11.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.v5_11.Visitor;
import io.fabric8.kubernetes.api.model.v5_11.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_11.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_11.ListOptions;
import io.fabric8.kubernetes.api.model.v5_11.ObjectMetaBuilder;
import io.fabric8.kubernetes.clnt.v5_11.BaseClient;
import io.fabric8.kubernetes.clnt.v5_11.ClientContext;
import io.fabric8.kubernetes.clnt.v5_11.Handlers;
import io.fabric8.kubernetes.clnt.v5_11.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_11.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_11.Watch;
import io.fabric8.kubernetes.clnt.v5_11.Watcher;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Applicable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.CascadingDeletable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Readiable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_11.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.VisitFromServerWritable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Waitable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_11.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_11.dsl.internal.NamespaceVisitOperationContext;
import io.fabric8.kubernetes.clnt.v5_11.internal.readiness.Readiness;
import io.fabric8.kubernetes.clnt.v5_11.utils.DeleteAndCreateHelper;
import io.fabric8.kubernetes.clnt.v5_11.utils.KubernetesResourceUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl
implements NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata>,
Waitable<HasMetadata, HasMetadata>,
Readiable {
    private final NamespaceVisitOperationContext namespaceVisitOperationContext;
    private final OperationContext context;

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(OperationContext context, NamespaceVisitOperationContext namespaceVisitOperationContext) {
        this.context = context;
        this.namespaceVisitOperationContext = namespaceVisitOperationContext;
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(ClientContext clientContext, HasMetadata item) {
        this(HasMetadataOperationsImpl.defaultContext(clientContext).withItem(item), new NamespaceVisitOperationContext());
        NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(item, this.context);
    }

    @Override
    public HasMetadata apply() {
        return this.createOrReplace();
    }

    @Override
    public HasMetadata createOrReplace() {
        if (this.namespaceVisitOperationContext.isDeletingExisting()) {
            return DeleteAndCreateHelper.deleteAndCreateItem(this.get(), this.getResource());
        }
        return this.getResource().createOrReplace((HasMetadata[])new HasMetadata[]{this.get()});
    }

    @Override
    public Waitable<HasMetadata, HasMetadata> createOrReplaceAnd() {
        HasMetadata item = this.createOrReplace();
        return this.newInstance(this.context.withItem(item), this.namespaceVisitOperationContext);
    }

    @Override
    public Boolean delete() {
        return this.getResource().delete();
    }

    @Override
    public HasMetadata get() {
        if (!this.context.isReloadingFromServer()) {
            return (HasMetadata)this.context.getItem();
        }
        return (HasMetadata)this.getResource().get();
    }

    @Override
    public VisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> inNamespace(String explicitNamespace) {
        HasMetadata item = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(this.get(), Collections.emptyList(), explicitNamespace, this.context);
        return this.newInstance(this.context.withItem(item).withNamespace(explicitNamespace), this.namespaceVisitOperationContext.withExplicitNamespace(explicitNamespace));
    }

    @Override
    public Gettable<HasMetadata> fromServer() {
        return (Gettable)this.getResource().fromServer();
    }

    @Override
    public Applicable<HasMetadata> deletingExisting() {
        return this.newInstance(this.context, this.namespaceVisitOperationContext.withDeletingExisting(true));
    }

    @Override
    public VisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> accept(Visitor ... visitors) {
        HasMetadata item = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.acceptVisitors(this.get(), Arrays.asList(visitors), this.namespaceVisitOperationContext.getExplicitNamespace(), this.context);
        return this.newInstance(this.context.withItem(item), this.namespaceVisitOperationContext);
    }

    @Override
    public CascadingDeletable<HasMetadata> withGracePeriod(long gracePeriodSeconds) {
        return this.newInstance(this.context.withGracePeriodSeconds(gracePeriodSeconds), this.namespaceVisitOperationContext);
    }

    @Override
    public CascadingDeletable<HasMetadata> withPropagationPolicy(DeletionPropagation propagationPolicy) {
        return this.newInstance(this.context.withPropagationPolicy(propagationPolicy), this.namespaceVisitOperationContext);
    }

    @Override
    public Deletable cascading(boolean cascading) {
        return (Deletable)this.getResource().cascading(cascading);
    }

    @Override
    public Waitable<HasMetadata, HasMetadata> withWaitRetryBackoff(long initialBackoff, TimeUnit backoffUnit, double backoffMultiplier) {
        return this;
    }

    @Override
    public Watch watch(Watcher<HasMetadata> watcher) {
        return this.getResource().watch(watcher);
    }

    @Override
    public Watch watch(String resourceVersion, Watcher<HasMetadata> watcher) {
        return this.getResource().watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(ListOptions options, Watcher<HasMetadata> watcher) {
        return this.getResource().watch(options, watcher);
    }

    Resource<HasMetadata> getResource() {
        HasMetadata meta = (HasMetadata)this.context.getItem();
        ResourceHandler handler = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(meta, this.context);
        HasMetadataOperation operation = handler.operation(this.context, null);
        return (Resource)operation.newInstance(this.context).inNamespace(KubernetesResourceUtil.getNamespace(meta)).withName(KubernetesResourceUtil.getName(meta));
    }

    protected Readiness getReadiness() {
        return Readiness.getInstance();
    }

    @Override
    public final boolean isReady() {
        HasMetadata meta = (HasMetadata)this.fromServer().get();
        if (meta == null) {
            return false;
        }
        return this.getReadiness().isReady(meta);
    }

    @Override
    public HasMetadata waitUntilReady(long amount, TimeUnit timeUnit) {
        return (HasMetadata)this.getResource().waitUntilReady(amount, timeUnit);
    }

    @Override
    public VisitFromServerWritable<HasMetadata> dryRun(boolean isDryRun) {
        return this.newInstance(this.context.withDryRun(isDryRun), this.namespaceVisitOperationContext);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl newInstance(OperationContext context, NamespaceVisitOperationContext namespaceVisitOperationContext) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(context, namespaceVisitOperationContext);
    }

    @Override
    public HasMetadata waitUntilCondition(Predicate<HasMetadata> condition, long amount, TimeUnit timeUnit) {
        return (HasMetadata)this.getResource().waitUntilCondition(condition, amount, timeUnit);
    }

    @Override
    public <V> HasMetadata edit(Class<V> visitorType, Visitor<V> visitor) {
        return (HasMetadata)this.getResource().edit(visitorType, visitor);
    }

    @Override
    public HasMetadata edit(UnaryOperator<HasMetadata> function) {
        return this.getResource().edit(function);
    }

    @Override
    public HasMetadata edit(Visitor ... visitors) {
        return (HasMetadata)this.getResource().edit(visitors);
    }

    @Override
    public HasMetadata accept(Consumer<HasMetadata> function) {
        return this.getResource().accept(function);
    }

    static HasMetadata acceptVisitors(HasMetadata item, List<Visitor> visitors, String explicitNamespace, OperationContext context) {
        ResourceHandler h = NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl.handlerOf(item, context);
        Object builder = h.edit(item);
        for (Visitor v : visitors) {
            builder.accept(v);
        }
        if (explicitNamespace != null) {
            builder.accept(new ChangeNamespace(explicitNamespace));
        }
        return (HasMetadata)builder.build();
    }

    static <T extends HasMetadata, V extends VisitableBuilder<T, V>> ResourceHandler<T, V> handlerOf(T item, OperationContext context) {
        ResourceHandler result = Handlers.get(item, new BaseClient(context));
        if (result == null) {
            throw new KubernetesClientException("Could not find a registered handler for item: [" + item + "].");
        }
        return result;
    }

    static class ChangeNamespace
    extends TypedVisitor<ObjectMetaBuilder> {
        private final String explicitNamespace;

        ChangeNamespace(String explicitNamespace) {
            this.explicitNamespace = explicitNamespace;
        }

        @Override
        public void visit(ObjectMetaBuilder builder) {
            builder.withNamespace(this.explicitNamespace);
        }
    }
}

