/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_11.dsl.internal;

import io.fabric8.kubernetes.clnt.v5_11.Config;
import io.fabric8.kubernetes.clnt.v5_11.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_11.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v5_11.http.HttpClient;
import io.fabric8.kubernetes.clnt.v5_11.http.HttpRequest;
import io.fabric8.kubernetes.clnt.v5_11.http.HttpResponse;
import io.fabric8.kubernetes.clnt.v5_11.utils.InputStreamPumper;
import io.fabric8.kubernetes.clnt.v5_11.utils.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogWatchCallback
implements LogWatch,
AutoCloseable,
BiConsumer<HttpResponse<InputStream>, Throwable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogWatchCallback.class);
    private final Config config;
    private final OutputStream out;
    private final PipedInputStream output;
    private final Set<Closeable> toClose = new LinkedHashSet<Closeable>();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public LogWatchCallback(Config config, OutputStream out) {
        this.config = config;
        if (out == null) {
            this.out = new PipedOutputStream();
            this.output = new PipedInputStream();
            try {
                this.output.connect((PipedOutputStream)this.out);
            }
            catch (IOException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        } else {
            this.out = out;
            this.output = null;
        }
        if (this.out instanceof PipedOutputStream) {
            this.toClose.add(this.out);
        }
    }

    @Override
    public void close() {
        this.cleanUp();
    }

    private void cleanUp() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.executorService.shutdownNow();
        Utils.closeQuietly(this.toClose);
    }

    public LogWatchCallback callAndWait(HttpClient client, URL url) {
        HttpRequest request = client.newHttpRequestBuilder().url(url).build();
        HttpClient clone = client.newBuilder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
        CompletionStage future = clone.sendAsync(request, InputStream.class).whenComplete((BiConsumer)this);
        if (!Utils.waitUntilReady(future, this.config.getRequestTimeout(), TimeUnit.MILLISECONDS) && LOGGER.isWarnEnabled()) {
            LOGGER.warn("Log watch request has not been opened within: {} millis.", (Object)this.config.getRequestTimeout());
        }
        return this;
    }

    @Override
    public InputStream getOutput() {
        return this.output;
    }

    @Override
    public void accept(HttpResponse<InputStream> t, Throwable u) {
        if (u != null) {
            this.onFailure(u);
        }
        if (t != null) {
            this.onResponse(t);
        }
    }

    public void onFailure(Throwable u) {
        if (this.closed.get()) {
            return;
        }
        LOGGER.error("Log Callback Failure.", u);
        this.cleanUp();
    }

    public void onResponse(HttpResponse<InputStream> response) {
        InputStream body = response.body();
        if (!this.executorService.isShutdown()) {
            InputStreamPumper.pump(body, this.out::write, this.executorService).whenComplete((o, t) -> {
                this.cleanUp();
                Utils.closeQuietly(body);
            });
        } else {
            Utils.closeQuietly(body);
        }
    }
}

