/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_11;

import io.fabric8.kubernetes.clnt.v5_11.BaseKubernetesClient;
import io.fabric8.kubernetes.clnt.v5_11.ClientContext;
import io.fabric8.kubernetes.clnt.v5_11.Config;
import io.fabric8.kubernetes.clnt.v5_11.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v5_11.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v5_11.RequestConfig;
import io.fabric8.kubernetes.clnt.v5_11.WithRequestCallable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v5_11.extended.leaderelection.LeaderElectorBuilder;
import io.fabric8.kubernetes.clnt.v5_11.http.HttpClient;
import io.fabric8.kubernetes.clnt.v5_11.okhttp.OkHttpClientImpl;
import io.fabric8.kubernetes.clnt.v5_11.utils.Serialization;
import java.io.InputStream;
import okhttp3.OkHttpClient;

public class DefaultKubernetesClient
extends BaseKubernetesClient<NamespacedKubernetesClient>
implements NamespacedKubernetesClient {
    public DefaultKubernetesClient() {
    }

    public DefaultKubernetesClient(String masterUrl) {
        super(masterUrl);
    }

    public DefaultKubernetesClient(Config config) {
        super(config);
    }

    @Deprecated
    public DefaultKubernetesClient(OkHttpClient httpClient, Config config) {
        super(new OkHttpClientImpl(httpClient), config);
    }

    public DefaultKubernetesClient(HttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    public DefaultKubernetesClient(ClientContext clientContext) {
        super(clientContext);
    }

    public static DefaultKubernetesClient fromConfig(String config) {
        return new DefaultKubernetesClient(Serialization.unmarshal(config, Config.class));
    }

    public static DefaultKubernetesClient fromConfig(InputStream is) {
        return new DefaultKubernetesClient(Serialization.unmarshal(is, Config.class));
    }

    @Override
    public NamespacedKubernetesClient inNamespace(String name) {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.getConfiguration()).withNamespace(name)).build();
        return new DefaultKubernetesClient(this.newState(updated));
    }

    public LeaderElectorBuilder<NamespacedKubernetesClient> leaderElector() {
        return new LeaderElectorBuilder<NamespacedKubernetesClient>(this);
    }

    @Override
    public FunctionCallable<NamespacedKubernetesClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable<NamespacedKubernetesClient>(this, requestConfig);
    }
}

