/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_11;

import io.fabric8.kubernetes.api.model.v5_11.ComponentStatus;
import io.fabric8.kubernetes.api.model.v5_11.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v5_11.ConfigMap;
import io.fabric8.kubernetes.api.model.v5_11.ConfigMapList;
import io.fabric8.kubernetes.api.model.v5_11.Endpoints;
import io.fabric8.kubernetes.api.model.v5_11.EndpointsList;
import io.fabric8.kubernetes.api.model.v5_11.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_11.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_11.LimitRange;
import io.fabric8.kubernetes.api.model.v5_11.LimitRangeList;
import io.fabric8.kubernetes.api.model.v5_11.Namespace;
import io.fabric8.kubernetes.api.model.v5_11.NamespaceList;
import io.fabric8.kubernetes.api.model.v5_11.Node;
import io.fabric8.kubernetes.api.model.v5_11.NodeList;
import io.fabric8.kubernetes.api.model.v5_11.PersistentVolume;
import io.fabric8.kubernetes.api.model.v5_11.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v5_11.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.v5_11.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.v5_11.Pod;
import io.fabric8.kubernetes.api.model.v5_11.PodList;
import io.fabric8.kubernetes.api.model.v5_11.ReplicationController;
import io.fabric8.kubernetes.api.model.v5_11.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v5_11.ResourceQuota;
import io.fabric8.kubernetes.api.model.v5_11.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.v5_11.RootPaths;
import io.fabric8.kubernetes.api.model.v5_11.Secret;
import io.fabric8.kubernetes.api.model.v5_11.SecretList;
import io.fabric8.kubernetes.api.model.v5_11.Service;
import io.fabric8.kubernetes.api.model.v5_11.ServiceAccount;
import io.fabric8.kubernetes.api.model.v5_11.ServiceAccountList;
import io.fabric8.kubernetes.api.model.v5_11.ServiceList;
import io.fabric8.kubernetes.clnt.v5_11.Adapters;
import io.fabric8.kubernetes.clnt.v5_11.AdmissionRegistrationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_11.ClientContext;
import io.fabric8.kubernetes.clnt.v5_11.Config;
import io.fabric8.kubernetes.clnt.v5_11.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v5_11.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v5_11.ExtensionAdapter;
import io.fabric8.kubernetes.clnt.v5_11.KubernetesClient;
import io.fabric8.kubernetes.clnt.v5_11.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v5_11.VersionInfo;
import io.fabric8.kubernetes.clnt.v5_11.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_11.dsl.AuthorizationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_11.dsl.AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_11.dsl.BatchAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_11.dsl.DiscoveryAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_11.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_11.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.NetworkAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_11.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_11.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_11.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v5_11.dsl.PolicyAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_11.dsl.RbacAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_11.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_11.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v5_11.dsl.ServiceResource;
import io.fabric8.kubernetes.clnt.v5_11.dsl.StorageAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_11.extended.run.RunOperations;
import java.io.InputStream;
import java.net.URL;

public class AutoAdaptableKubernetesClient
extends DefaultKubernetesClient {
    private KubernetesClient delegate;

    public AutoAdaptableKubernetesClient() {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient());
    }

    public AutoAdaptableKubernetesClient(ClientContext clientContext) {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient(clientContext));
    }

    public AutoAdaptableKubernetesClient(Config config) {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient(config));
    }

    public AutoAdaptableKubernetesClient(String masterUrl) {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient(masterUrl));
    }

    public static KubernetesClient adapt(KubernetesClient initial) {
        KubernetesClient result = initial;
        for (ExtensionAdapter<KubernetesClient> adapter : Adapters.list(KubernetesClient.class)) {
            if (!adapter.isAdaptable(result).booleanValue()) continue;
            result = adapter.adapt(result);
        }
        return result;
    }

    @Override
    public NamespacedKubernetesClient inNamespace(String namespace) {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.getConfiguration()).withNamespace(namespace)).build();
        return new AutoAdaptableKubernetesClient(this.newState(updated));
    }

    @Override
    public NamespacedKubernetesClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.delegate.extensions();
    }

    @Override
    public VersionInfo getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public AdmissionRegistrationAPIGroupDSL admissionRegistration() {
        return this.delegate.admissionRegistration();
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.delegate.apps();
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.delegate.autoscaling();
    }

    @Override
    public AuthorizationAPIGroupDSL authorization() {
        return this.delegate.authorization();
    }

    @Override
    public DiscoveryAPIGroupDSL discovery() {
        return this.delegate.discovery();
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.delegate.network();
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.delegate.storage();
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.delegate.batch();
    }

    @Override
    public PolicyAPIGroupDSL policy() {
        return this.delegate.policy();
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.delegate.rbac();
    }

    @Override
    public NonNamespaceOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return this.delegate.componentstatuses();
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> load(InputStream is) {
        return this.delegate.load(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(KubernetesResourceList is) {
        return this.delegate.resourceList(is);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(String s) {
        return this.delegate.resourceList(s);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(HasMetadata is) {
        return this.delegate.resource(is);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, Resource<Endpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, Resource<Namespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, Resource<Node>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, Resource<PersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Pod, PodList, PodResource<Pod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, Resource<ResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public MixedOperation<Secret, SecretList, Resource<Secret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public MixedOperation<Service, ServiceList, ServiceResource<Service>> services() {
        return this.delegate.services();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, Resource<ServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, Resource<LimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public RunOperations run() {
        return this.delegate.run();
    }

    @Override
    public <C> Boolean isAdaptable(Class<C> type) {
        return this.delegate.isAdaptable(type);
    }

    @Override
    public <C> C adapt(Class<C> type) {
        return this.delegate.adapt(type);
    }

    @Override
    public URL getMasterUrl() {
        return this.delegate.getMasterUrl();
    }

    @Override
    public String getApiVersion() {
        return this.delegate.getApiVersion();
    }

    @Override
    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    @Override
    public RootPaths rootPaths() {
        return this.delegate.rootPaths();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Config getConfiguration() {
        return this.delegate.getConfiguration();
    }
}

