/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_11.storage;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.kubernetes.api.model.v5_11.storage.CSINodeDriver;
import io.fabric8.kubernetes.api.model.v5_11.storage.CSINodeDriverBuilder;
import io.fabric8.kubernetes.api.model.v5_11.storage.CSINodeDriverFluentImpl;
import io.fabric8.kubernetes.api.model.v5_11.storage.CSINodeSpec;
import io.fabric8.kubernetes.api.model.v5_11.storage.CSINodeSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CSINodeSpecFluentImpl<A extends CSINodeSpecFluent<A>>
extends BaseFluent<A>
implements CSINodeSpecFluent<A> {
    private List<CSINodeDriverBuilder> drivers = new ArrayList<CSINodeDriverBuilder>();
    private Map<String, Object> additionalProperties;

    public CSINodeSpecFluentImpl() {
    }

    public CSINodeSpecFluentImpl(CSINodeSpec instance) {
        this.withDrivers(instance.getDrivers());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToDrivers(Integer index, CSINodeDriver item) {
        if (this.drivers == null) {
            this.drivers = new ArrayList<CSINodeDriverBuilder>();
        }
        CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);
        this._visitables.get("drivers").add(index >= 0 ? index.intValue() : this._visitables.get("drivers").size(), builder);
        this.drivers.add(index >= 0 ? index.intValue() : this.drivers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToDrivers(Integer index, CSINodeDriver item) {
        if (this.drivers == null) {
            this.drivers = new ArrayList<CSINodeDriverBuilder>();
        }
        CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);
        if (index < 0 || index >= this._visitables.get("drivers").size()) {
            this._visitables.get("drivers").add(builder);
        } else {
            this._visitables.get("drivers").set(index, builder);
        }
        if (index < 0 || index >= this.drivers.size()) {
            this.drivers.add(builder);
        } else {
            this.drivers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToDrivers(CSINodeDriver ... items) {
        if (this.drivers == null) {
            this.drivers = new ArrayList<CSINodeDriverBuilder>();
        }
        for (CSINodeDriver item : items) {
            CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);
            this._visitables.get("drivers").add(builder);
            this.drivers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToDrivers(Collection<CSINodeDriver> items) {
        if (this.drivers == null) {
            this.drivers = new ArrayList<CSINodeDriverBuilder>();
        }
        for (CSINodeDriver item : items) {
            CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);
            this._visitables.get("drivers").add(builder);
            this.drivers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromDrivers(CSINodeDriver ... items) {
        for (CSINodeDriver item : items) {
            CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);
            this._visitables.get("drivers").remove(builder);
            if (this.drivers == null) continue;
            this.drivers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDrivers(Collection<CSINodeDriver> items) {
        for (CSINodeDriver item : items) {
            CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);
            this._visitables.get("drivers").remove(builder);
            if (this.drivers == null) continue;
            this.drivers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromDrivers(Predicate<CSINodeDriverBuilder> predicate) {
        if (this.drivers == null) {
            return (A)this;
        }
        Iterator<CSINodeDriverBuilder> each = this.drivers.iterator();
        Object visitables = this._visitables.get("drivers");
        while (each.hasNext()) {
            CSINodeDriverBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<CSINodeDriver> getDrivers() {
        return CSINodeSpecFluentImpl.build(this.drivers);
    }

    @Override
    public List<CSINodeDriver> buildDrivers() {
        return CSINodeSpecFluentImpl.build(this.drivers);
    }

    @Override
    public CSINodeDriver buildDriver(Integer index) {
        return this.drivers.get(index).build();
    }

    @Override
    public CSINodeDriver buildFirstDriver() {
        return this.drivers.get(0).build();
    }

    @Override
    public CSINodeDriver buildLastDriver() {
        return this.drivers.get(this.drivers.size() - 1).build();
    }

    @Override
    public CSINodeDriver buildMatchingDriver(Predicate<CSINodeDriverBuilder> predicate) {
        for (CSINodeDriverBuilder item : this.drivers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDriver(Predicate<CSINodeDriverBuilder> predicate) {
        for (CSINodeDriverBuilder item : this.drivers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDrivers(List<CSINodeDriver> drivers) {
        if (this.drivers != null) {
            this._visitables.get("drivers").removeAll(this.drivers);
        }
        if (drivers != null) {
            this.drivers = new ArrayList<CSINodeDriverBuilder>();
            for (CSINodeDriver item : drivers) {
                this.addToDrivers(item);
            }
        } else {
            this.drivers = null;
        }
        return (A)this;
    }

    @Override
    public A withDrivers(CSINodeDriver ... drivers) {
        if (this.drivers != null) {
            this.drivers.clear();
        }
        if (drivers != null) {
            for (CSINodeDriver item : drivers) {
                this.addToDrivers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDrivers() {
        return this.drivers != null && !this.drivers.isEmpty();
    }

    @Override
    public CSINodeSpecFluent.DriversNested<A> addNewDriver() {
        return new DriversNestedImpl();
    }

    @Override
    public CSINodeSpecFluent.DriversNested<A> addNewDriverLike(CSINodeDriver item) {
        return new DriversNestedImpl(-1, item);
    }

    @Override
    public CSINodeSpecFluent.DriversNested<A> setNewDriverLike(Integer index, CSINodeDriver item) {
        return new DriversNestedImpl(index, item);
    }

    @Override
    public CSINodeSpecFluent.DriversNested<A> editDriver(Integer index) {
        if (this.drivers.size() <= index) {
            throw new RuntimeException("Can't edit drivers. Index exceeds size.");
        }
        return this.setNewDriverLike(index, this.buildDriver(index));
    }

    @Override
    public CSINodeSpecFluent.DriversNested<A> editFirstDriver() {
        if (this.drivers.size() == 0) {
            throw new RuntimeException("Can't edit first drivers. The list is empty.");
        }
        return this.setNewDriverLike(0, this.buildDriver(0));
    }

    @Override
    public CSINodeSpecFluent.DriversNested<A> editLastDriver() {
        int index = this.drivers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last drivers. The list is empty.");
        }
        return this.setNewDriverLike(index, this.buildDriver(index));
    }

    @Override
    public CSINodeSpecFluent.DriversNested<A> editMatchingDriver(Predicate<CSINodeDriverBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.drivers.size(); ++i) {
            if (!predicate.test(this.drivers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching drivers. No match found.");
        }
        return this.setNewDriverLike(index, this.buildDriver(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CSINodeSpecFluentImpl that = (CSINodeSpecFluentImpl)o;
        if (this.drivers != null ? !this.drivers.equals(that.drivers) : that.drivers != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.drivers, this.additionalProperties, super.hashCode());
    }

    public class DriversNestedImpl<N>
    extends CSINodeDriverFluentImpl<CSINodeSpecFluent.DriversNested<N>>
    implements CSINodeSpecFluent.DriversNested<N>,
    Nested<N> {
        CSINodeDriverBuilder builder;
        Integer index;

        DriversNestedImpl(Integer index, CSINodeDriver item) {
            this.index = index;
            this.builder = new CSINodeDriverBuilder(this, item);
        }

        DriversNestedImpl() {
            this.index = -1;
            this.builder = new CSINodeDriverBuilder(this);
        }

        @Override
        public N and() {
            return (N)CSINodeSpecFluentImpl.this.setToDrivers(this.index, this.builder.build());
        }

        @Override
        public N endDriver() {
            return this.and();
        }
    }
}

