/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_11.networking.v1;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.kubernetes.api.model.v5_11.TypedLocalObjectReference;
import io.fabric8.kubernetes.api.model.v5_11.networking.v1.IngressBackend;
import io.fabric8.kubernetes.api.model.v5_11.networking.v1.IngressBackendFluent;
import io.fabric8.kubernetes.api.model.v5_11.networking.v1.IngressServiceBackend;
import io.fabric8.kubernetes.api.model.v5_11.networking.v1.IngressServiceBackendBuilder;
import io.fabric8.kubernetes.api.model.v5_11.networking.v1.IngressServiceBackendFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class IngressBackendFluentImpl<A extends IngressBackendFluent<A>>
extends BaseFluent<A>
implements IngressBackendFluent<A> {
    private TypedLocalObjectReference resource;
    private IngressServiceBackendBuilder service;
    private Map<String, Object> additionalProperties;

    public IngressBackendFluentImpl() {
    }

    public IngressBackendFluentImpl(IngressBackend instance) {
        this.withResource(instance.getResource());
        this.withService(instance.getService());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public TypedLocalObjectReference getResource() {
        return this.resource;
    }

    @Override
    public A withResource(TypedLocalObjectReference resource) {
        this.resource = resource;
        return (A)this;
    }

    @Override
    public Boolean hasResource() {
        return this.resource != null;
    }

    @Override
    public A withNewResource(String apiGroup, String kind, String name) {
        return this.withResource(new TypedLocalObjectReference(apiGroup, kind, name));
    }

    @Override
    @Deprecated
    public IngressServiceBackend getService() {
        return this.service != null ? this.service.build() : null;
    }

    @Override
    public IngressServiceBackend buildService() {
        return this.service != null ? this.service.build() : null;
    }

    @Override
    public A withService(IngressServiceBackend service) {
        this._visitables.get("service").remove(this.service);
        if (service != null) {
            this.service = new IngressServiceBackendBuilder(service);
            this._visitables.get("service").add(this.service);
        }
        return (A)this;
    }

    @Override
    public Boolean hasService() {
        return this.service != null;
    }

    @Override
    public IngressBackendFluent.ServiceNested<A> withNewService() {
        return new ServiceNestedImpl();
    }

    @Override
    public IngressBackendFluent.ServiceNested<A> withNewServiceLike(IngressServiceBackend item) {
        return new ServiceNestedImpl(item);
    }

    @Override
    public IngressBackendFluent.ServiceNested<A> editService() {
        return this.withNewServiceLike(this.getService());
    }

    @Override
    public IngressBackendFluent.ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(this.getService() != null ? this.getService() : new IngressServiceBackendBuilder().build());
    }

    @Override
    public IngressBackendFluent.ServiceNested<A> editOrNewServiceLike(IngressServiceBackend item) {
        return this.withNewServiceLike(this.getService() != null ? this.getService() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressBackendFluentImpl that = (IngressBackendFluentImpl)o;
        if (this.resource != null ? !this.resource.equals(that.resource) : that.resource != null) {
            return false;
        }
        if (this.service != null ? !this.service.equals(that.service) : that.service != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.service, this.additionalProperties, super.hashCode());
    }

    public class ServiceNestedImpl<N>
    extends IngressServiceBackendFluentImpl<IngressBackendFluent.ServiceNested<N>>
    implements IngressBackendFluent.ServiceNested<N>,
    Nested<N> {
        IngressServiceBackendBuilder builder;

        ServiceNestedImpl(IngressServiceBackend item) {
            this.builder = new IngressServiceBackendBuilder(this, item);
        }

        ServiceNestedImpl() {
            this.builder = new IngressServiceBackendBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressBackendFluentImpl.this.withService(this.builder.build());
        }

        @Override
        public N endService() {
            return this.and();
        }
    }
}

