/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_11.extensions;

import io.fabric8.kubernetes.api.builder.v5_11.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_11.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.v5_11.extensions.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.v5_11.extensions.DeploymentSpecFluentImpl;
import java.util.Objects;

public class DeploymentSpecBuilder
extends DeploymentSpecFluentImpl<DeploymentSpecBuilder>
implements VisitableBuilder<DeploymentSpec, DeploymentSpecBuilder> {
    DeploymentSpecFluent<?> fluent;
    Boolean validationEnabled;

    public DeploymentSpecBuilder() {
        this(false);
    }

    public DeploymentSpecBuilder(Boolean validationEnabled) {
        this(new DeploymentSpec(), validationEnabled);
    }

    public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DeploymentSpec(), validationEnabled);
    }

    public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent, DeploymentSpec instance) {
        this(fluent, instance, false);
    }

    public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent, DeploymentSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMinReadySeconds(instance.getMinReadySeconds());
        fluent.withPaused(instance.getPaused());
        fluent.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
        fluent.withReplicas(instance.getReplicas());
        fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        fluent.withRollbackTo(instance.getRollbackTo());
        fluent.withSelector(instance.getSelector());
        fluent.withStrategy(instance.getStrategy());
        fluent.withTemplate(instance.getTemplate());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentSpecBuilder(DeploymentSpec instance) {
        this(instance, (Boolean)false);
    }

    public DeploymentSpecBuilder(DeploymentSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withPaused(instance.getPaused());
        this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withRollbackTo(instance.getRollbackTo());
        this.withSelector(instance.getSelector());
        this.withStrategy(instance.getStrategy());
        this.withTemplate(instance.getTemplate());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public DeploymentSpec build() {
        DeploymentSpec buildable = new DeploymentSpec(this.fluent.getMinReadySeconds(), this.fluent.getPaused(), this.fluent.getProgressDeadlineSeconds(), this.fluent.getReplicas(), this.fluent.getRevisionHistoryLimit(), this.fluent.getRollbackTo(), this.fluent.getSelector(), this.fluent.getStrategy(), this.fluent.getTemplate());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentSpecBuilder that = (DeploymentSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

