/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_11.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.v5_11.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_11.autoscaling.v2beta1.ResourceMetricSource;
import io.fabric8.kubernetes.api.model.v5_11.autoscaling.v2beta1.ResourceMetricSourceFluent;
import io.fabric8.kubernetes.api.model.v5_11.autoscaling.v2beta1.ResourceMetricSourceFluentImpl;
import java.util.Objects;

public class ResourceMetricSourceBuilder
extends ResourceMetricSourceFluentImpl<ResourceMetricSourceBuilder>
implements VisitableBuilder<ResourceMetricSource, ResourceMetricSourceBuilder> {
    ResourceMetricSourceFluent<?> fluent;
    Boolean validationEnabled;

    public ResourceMetricSourceBuilder() {
        this(false);
    }

    public ResourceMetricSourceBuilder(Boolean validationEnabled) {
        this(new ResourceMetricSource(), validationEnabled);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ResourceMetricSource(), validationEnabled);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent, ResourceMetricSource instance) {
        this(fluent, instance, false);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent, ResourceMetricSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withTargetAverageUtilization(instance.getTargetAverageUtilization());
        fluent.withTargetAverageValue(instance.getTargetAverageValue());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ResourceMetricSourceBuilder(ResourceMetricSource instance) {
        this(instance, (Boolean)false);
    }

    public ResourceMetricSourceBuilder(ResourceMetricSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withTargetAverageUtilization(instance.getTargetAverageUtilization());
        this.withTargetAverageValue(instance.getTargetAverageValue());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ResourceMetricSource build() {
        ResourceMetricSource buildable = new ResourceMetricSource(this.fluent.getName(), this.fluent.getTargetAverageUtilization(), this.fluent.getTargetAverageValue());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceMetricSourceBuilder that = (ResourceMetricSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

