/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_11.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.v5_11.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_11.Nested;
import io.fabric8.kubernetes.api.model.v5_11.apiextensions.v1.CustomResourceConversion;
import io.fabric8.kubernetes.api.model.v5_11.apiextensions.v1.CustomResourceConversionFluent;
import io.fabric8.kubernetes.api.model.v5_11.apiextensions.v1.WebhookConversion;
import io.fabric8.kubernetes.api.model.v5_11.apiextensions.v1.WebhookConversionBuilder;
import io.fabric8.kubernetes.api.model.v5_11.apiextensions.v1.WebhookConversionFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class CustomResourceConversionFluentImpl<A extends CustomResourceConversionFluent<A>>
extends BaseFluent<A>
implements CustomResourceConversionFluent<A> {
    private String strategy;
    private WebhookConversionBuilder webhook;
    private Map<String, Object> additionalProperties;

    public CustomResourceConversionFluentImpl() {
    }

    public CustomResourceConversionFluentImpl(CustomResourceConversion instance) {
        this.withStrategy(instance.getStrategy());
        this.withWebhook(instance.getWebhook());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getStrategy() {
        return this.strategy;
    }

    @Override
    public A withStrategy(String strategy) {
        this.strategy = strategy;
        return (A)this;
    }

    @Override
    public Boolean hasStrategy() {
        return this.strategy != null;
    }

    @Override
    @Deprecated
    public A withNewStrategy(String arg0) {
        return this.withStrategy(new String(arg0));
    }

    @Override
    @Deprecated
    public WebhookConversion getWebhook() {
        return this.webhook != null ? this.webhook.build() : null;
    }

    @Override
    public WebhookConversion buildWebhook() {
        return this.webhook != null ? this.webhook.build() : null;
    }

    @Override
    public A withWebhook(WebhookConversion webhook) {
        this._visitables.get("webhook").remove(this.webhook);
        if (webhook != null) {
            this.webhook = new WebhookConversionBuilder(webhook);
            this._visitables.get("webhook").add(this.webhook);
        }
        return (A)this;
    }

    @Override
    public Boolean hasWebhook() {
        return this.webhook != null;
    }

    @Override
    public CustomResourceConversionFluent.WebhookNested<A> withNewWebhook() {
        return new WebhookNestedImpl();
    }

    @Override
    public CustomResourceConversionFluent.WebhookNested<A> withNewWebhookLike(WebhookConversion item) {
        return new WebhookNestedImpl(item);
    }

    @Override
    public CustomResourceConversionFluent.WebhookNested<A> editWebhook() {
        return this.withNewWebhookLike(this.getWebhook());
    }

    @Override
    public CustomResourceConversionFluent.WebhookNested<A> editOrNewWebhook() {
        return this.withNewWebhookLike(this.getWebhook() != null ? this.getWebhook() : new WebhookConversionBuilder().build());
    }

    @Override
    public CustomResourceConversionFluent.WebhookNested<A> editOrNewWebhookLike(WebhookConversion item) {
        return this.withNewWebhookLike(this.getWebhook() != null ? this.getWebhook() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomResourceConversionFluentImpl that = (CustomResourceConversionFluentImpl)o;
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        if (this.webhook != null ? !this.webhook.equals(that.webhook) : that.webhook != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.strategy, this.webhook, this.additionalProperties, super.hashCode());
    }

    public class WebhookNestedImpl<N>
    extends WebhookConversionFluentImpl<CustomResourceConversionFluent.WebhookNested<N>>
    implements CustomResourceConversionFluent.WebhookNested<N>,
    Nested<N> {
        WebhookConversionBuilder builder;

        WebhookNestedImpl(WebhookConversion item) {
            this.builder = new WebhookConversionBuilder(this, item);
        }

        WebhookNestedImpl() {
            this.builder = new WebhookConversionBuilder(this);
        }

        @Override
        public N and() {
            return (N)CustomResourceConversionFluentImpl.this.withWebhook(this.builder.build());
        }

        @Override
        public N endWebhook() {
            return this.and();
        }
    }
}

