/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.osgi;

import io.fabric8.kubernetes.api.model.APIService;
import io.fabric8.kubernetes.api.model.APIServiceList;
import io.fabric8.kubernetes.api.model.Binding;
import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ComponentStatusList;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.LimitRange;
import io.fabric8.kubernetes.api.model.LimitRangeList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequest;
import io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestList;
import io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseList;
import io.fabric8.kubernetes.api.model.node.v1beta1.RuntimeClass;
import io.fabric8.kubernetes.api.model.node.v1beta1.RuntimeClassList;
import io.fabric8.kubernetes.client.AdmissionRegistrationAPIGroupDSL;
import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.dsl.ApiextensionsAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.AuthorizationAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.BatchAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.CertificatesAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.DiscoveryAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.EventingAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.FlowControlAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.FunctionCallable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.InOutCreateable;
import io.fabric8.kubernetes.client.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.MetricAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.Namespaceable;
import io.fabric8.kubernetes.client.dsl.NamespacedInOutCreateable;
import io.fabric8.kubernetes.client.dsl.NetworkAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ParameterMixedOperation;
import io.fabric8.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PolicyAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.RbacAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.SchedulingAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.StorageAPIGroupDSL;
import io.fabric8.kubernetes.client.dsl.V1APIGroupDSL;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.RawCustomResourceOperationsImpl;
import io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectorBuilder;
import io.fabric8.kubernetes.client.extended.run.RunOperations;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.openshift.api.model.BrokerTemplateInstance;
import io.fabric8.openshift.api.model.BrokerTemplateInstanceList;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.ClusterNetwork;
import io.fabric8.openshift.api.model.ClusterNetworkList;
import io.fabric8.openshift.api.model.ClusterRole;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.ClusterRoleList;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.EgressNetworkPolicy;
import io.fabric8.openshift.api.model.EgressNetworkPolicyList;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.GroupList;
import io.fabric8.openshift.api.model.HelmChartRepository;
import io.fabric8.openshift.api.model.HelmChartRepositoryList;
import io.fabric8.openshift.api.model.HostSubnet;
import io.fabric8.openshift.api.model.HostSubnetList;
import io.fabric8.openshift.api.model.Identity;
import io.fabric8.openshift.api.model.IdentityList;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageList;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamImage;
import io.fabric8.openshift.api.model.ImageStreamImport;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.ImageStreamMapping;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.ImageStreamTagList;
import io.fabric8.openshift.api.model.ImageTag;
import io.fabric8.openshift.api.model.ImageTagList;
import io.fabric8.openshift.api.model.LocalResourceAccessReview;
import io.fabric8.openshift.api.model.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.NetNamespace;
import io.fabric8.openshift.api.model.NetNamespaceList;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationList;
import io.fabric8.openshift.api.model.OAuthClientList;
import io.fabric8.openshift.api.model.PodSecurityPolicyReview;
import io.fabric8.openshift.api.model.PodSecurityPolicySelfSubjectReview;
import io.fabric8.openshift.api.model.PodSecurityPolicySubjectReview;
import io.fabric8.openshift.api.model.RangeAllocation;
import io.fabric8.openshift.api.model.RangeAllocationList;
import io.fabric8.openshift.api.model.ResourceAccessReview;
import io.fabric8.openshift.api.model.ResourceAccessReviewResponse;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingList;
import io.fabric8.openshift.api.model.RoleBindingRestriction;
import io.fabric8.openshift.api.model.RoleBindingRestrictionList;
import io.fabric8.openshift.api.model.RoleList;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.SecurityContextConstraints;
import io.fabric8.openshift.api.model.SecurityContextConstraintsList;
import io.fabric8.openshift.api.model.SelfSubjectRulesReview;
import io.fabric8.openshift.api.model.SubjectAccessReview;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponse;
import io.fabric8.openshift.api.model.SubjectRulesReview;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateInstance;
import io.fabric8.openshift.api.model.TemplateInstanceList;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.UserIdentityMapping;
import io.fabric8.openshift.api.model.UserList;
import io.fabric8.openshift.api.model.UserOAuthAccessToken;
import io.fabric8.openshift.api.model.UserOAuthAccessTokenList;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequest;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.CredentialsRequestList;
import io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinition;
import io.fabric8.openshift.api.model.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinitionList;
import io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.Config;
import io.fabric8.openshift.api.model.miscellaneous.imageregistry.operator.v1.ConfigList;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.BareMetalHost;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.BareMetalHostList;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKI;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKIList;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.BuildResource;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import io.fabric8.openshift.client.dsl.MachineConfigurationAPIGroupDSL;
import io.fabric8.openshift.client.dsl.NameableCreateOrDeleteable;
import io.fabric8.openshift.client.dsl.OpenShiftClusterAutoscalingAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftConfigAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftConsoleAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftMachineAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftMonitoringAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftOperatorAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftOperatorHubAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftQuotaAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftStorageVersionMigratorApiGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftTunedAPIGroupDSL;
import io.fabric8.openshift.client.dsl.OpenShiftWhereaboutsAPIGroupDSL;
import io.fabric8.openshift.client.dsl.ProjectOperation;
import io.fabric8.openshift.client.dsl.ProjectRequestOperation;
import io.fabric8.openshift.client.dsl.TemplateResource;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;

@Component(immediate=true, configurationPid="io.fabric8.openshift.client", policy=ConfigurationPolicy.OPTIONAL)
@Service(value={OpenShiftClient.class, NamespacedOpenShiftClient.class})
public class ManagedOpenShiftClient
extends BaseClient
implements NamespacedOpenShiftClient {
    private DefaultOpenShiftClient delegate;

    @Activate
    public void activate(Map<String, Object> properties) {
        OpenShiftConfigBuilder builder = new OpenShiftConfigBuilder();
        if (properties.containsKey("kubernetes.master")) {
            builder.withMasterUrl((String)properties.get("kubernetes.master"));
        }
        if (properties.containsKey("kubernetes.api.version")) {
            builder.withApiVersion((String)properties.get("kubernetes.api.version"));
        }
        if (properties.containsKey("kubernetes.namespace")) {
            builder.withNamespace((String)properties.get("kubernetes.namespace"));
        }
        if (properties.containsKey("kubernetes.certs.ca.file")) {
            builder.withCaCertFile((String)properties.get("kubernetes.certs.ca.file"));
        }
        if (properties.containsKey("kubernetes.certs.ca.data")) {
            builder.withCaCertData((String)properties.get("kubernetes.certs.ca.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.file")) {
            builder.withClientCertFile((String)properties.get("kubernetes.certs.client.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.data")) {
            builder.withClientCertData((String)properties.get("kubernetes.certs.client.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.file")) {
            builder.withClientKeyFile((String)properties.get("kubernetes.certs.client.key.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.data")) {
            builder.withClientKeyData((String)properties.get("kubernetes.certs.client.key.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.algo")) {
            builder.withClientKeyAlgo((String)properties.get("kubernetes.certs.client.key.algo"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.passphrase")) {
            builder.withClientKeyPassphrase((String)properties.get("kubernetes.certs.client.key.passphrase"));
        }
        if (properties.containsKey("kubernetes.auth.basic.username")) {
            builder.withUsername((String)properties.get("kubernetes.auth.basic.username"));
        }
        if (properties.containsKey("kubernetes.auth.basic.password")) {
            builder.withPassword((String)properties.get("kubernetes.auth.basic.password"));
        }
        if (properties.containsKey("kubernetes.auth.token")) {
            builder.withOauthToken((String)properties.get("kubernetes.auth.token"));
        }
        if (properties.containsKey("kubernetes.watch.reconnectInterval")) {
            builder.withWatchReconnectInterval(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectInterval")));
        }
        if (properties.containsKey("kubernetes.watch.reconnectLimit")) {
            builder.withWatchReconnectLimit(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectLimit")));
        }
        if (properties.containsKey("kubernetes.request.timeout")) {
            builder.withRequestTimeout(Integer.parseInt((String)properties.get("kubernetes.request.timeout")));
        }
        if (properties.containsKey("http.proxy")) {
            builder.withHttpProxy((String)properties.get("http.proxy"));
        }
        if (properties.containsKey("https.proxy")) {
            builder.withHttpsProxy((String)properties.get("https.proxy"));
        }
        if (properties.containsKey("no.proxy")) {
            String noProxyProperty = (String)properties.get("no.proxy");
            builder.withNoProxy(noProxyProperty.split(","));
        }
        if (properties.containsKey("openshift.url")) {
            builder.withOpenShiftUrl((String)properties.get("openshift.url"));
        } else {
            builder.withOpenShiftUrl(URLUtils.join(builder.getMasterUrl(), "oapi", builder.getOapiVersion()));
        }
        if (properties.containsKey("openshift.build.timeout")) {
            builder.withBuildTimeout(Integer.parseInt((String)properties.get("openshift.build.timeout")));
        } else {
            builder.withBuildTimeout(OpenShiftConfig.DEFAULT_BUILD_TIMEOUT);
        }
        if (properties.containsKey("kubernetes.websocket.timeout")) {
            builder.withWebsocketTimeout(Long.parseLong((String)properties.get("kubernetes.websocket.timeout")));
        }
        if (properties.containsKey("kubernetes.websocket.ping.interval")) {
            builder.withWebsocketPingInterval(Long.parseLong((String)properties.get("kubernetes.websocket.ping.interval")));
        }
        this.delegate = new DefaultOpenShiftClient(builder.build());
    }

    @Deactivate
    public void deactivate() {
        this.delegate.close();
    }

    @Override
    public URL getOpenshiftUrl() {
        return this.delegate.getOpenshiftUrl();
    }

    @Override
    public OpenShiftConfigAPIGroupDSL config() {
        return this.delegate.config();
    }

    @Override
    public OpenShiftConsoleAPIGroupDSL console() {
        return this.delegate.console();
    }

    @Override
    public OpenShiftClusterAutoscalingAPIGroupDSL clusterAutoscaling() {
        return this.delegate.clusterAutoscaling();
    }

    @Override
    public OpenShiftOperatorAPIGroupDSL operator() {
        return this.delegate.operator();
    }

    @Override
    public OpenShiftOperatorHubAPIGroupDSL operatorHub() {
        return this.delegate.operatorHub();
    }

    @Override
    public MixedOperation<Build, BuildList, BuildResource<Build, LogWatch>> builds() {
        return this.delegate.builds();
    }

    public MixedOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return this.delegate.componentstatuses();
    }

    @Override
    public MixedOperation<BuildConfig, BuildConfigList, BuildConfigResource<BuildConfig, Void, Build>> buildConfigs() {
        return this.delegate.buildConfigs();
    }

    @Override
    public MixedOperation<CredentialsRequest, CredentialsRequestList, Resource<CredentialsRequest>> credentialsRequests() {
        return this.delegate.credentialsRequests();
    }

    @Override
    public MixedOperation<DeploymentConfig, DeploymentConfigList, DeployableScalableResource<DeploymentConfig>> deploymentConfigs() {
        return this.delegate.deploymentConfigs();
    }

    @Override
    public NonNamespaceOperation<Group, GroupList, Resource<Group>> groups() {
        return this.delegate.groups();
    }

    @Override
    public NonNamespaceOperation<HelmChartRepository, HelmChartRepositoryList, Resource<HelmChartRepository>> helmChartRepositories() {
        return this.delegate.helmChartRepositories();
    }

    @Override
    public NonNamespaceOperation<Image, ImageList, Resource<Image>> images() {
        return this.delegate.images();
    }

    @Override
    public MixedOperation<ImageTag, ImageTagList, Resource<ImageTag>> imageTags() {
        return this.delegate.imageTags();
    }

    @Override
    public MixedOperation<ImageStream, ImageStreamList, Resource<ImageStream>> imageStreams() {
        return this.delegate.imageStreams();
    }

    @Override
    public MixedOperation<ImageStreamTag, ImageStreamTagList, Resource<ImageStreamTag>> imageStreamTags() {
        return this.delegate.imageStreamTags();
    }

    @Override
    public NamespacedInOutCreateable<ImageStreamImport, ImageStreamImport> imageStreamImports() {
        return this.delegate.imageStreamImports();
    }

    @Override
    public NamespacedInOutCreateable<ImageStreamMapping, ImageStreamMapping> imageStreamMappings() {
        return this.delegate.imageStreamMappings();
    }

    @Override
    public Namespaceable<Nameable<? extends Gettable<ImageStreamImage>>> imageStreamImages() {
        return this.delegate.imageStreamImages();
    }

    @Override
    public NameableCreateOrDeleteable imageSignatures() {
        return this.delegate.imageSignatures();
    }

    @Override
    public NonNamespaceOperation<Config, ConfigList, Resource<Config>> imageRegistryOperatorConfigs() {
        return this.delegate.imageRegistryOperatorConfigs();
    }

    @Override
    public MixedOperation<NetworkAttachmentDefinition, NetworkAttachmentDefinitionList, Resource<NetworkAttachmentDefinition>> networkAttachmentDefinitions() {
        return this.delegate.networkAttachmentDefinitions();
    }

    @Override
    public NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, Resource<OAuthAccessToken>> oAuthAccessTokens() {
        return this.delegate.oAuthAccessTokens();
    }

    @Override
    public NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, Resource<OAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return this.delegate.oAuthAuthorizeTokens();
    }

    @Override
    public NonNamespaceOperation<OAuthClient, OAuthClientList, Resource<OAuthClient>> oAuthClients() {
        return this.delegate.oAuthClients();
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicyReview, PodSecurityPolicyReview> podSecurityPolicyReviews() {
        return this.delegate.podSecurityPolicyReviews();
    }

    @Override
    public NonNamespaceOperation<OAuthClientAuthorization, OAuthClientAuthorizationList, Resource<OAuthClientAuthorization>> oAuthClientAuthorizations() {
        return this.delegate.oAuthClientAuthorizations();
    }

    @Override
    public MixedOperation<OperatorPKI, OperatorPKIList, Resource<OperatorPKI>> operatorPKIs() {
        return this.delegate.operatorPKIs();
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicySelfSubjectReview, PodSecurityPolicySelfSubjectReview> podSecurityPolicySelfSubjectReviews() {
        return this.delegate.podSecurityPolicySelfSubjectReviews();
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicySubjectReview, PodSecurityPolicySubjectReview> podSecurityPolicySubjectReviews() {
        return this.delegate.podSecurityPolicySubjectReviews();
    }

    @Override
    public OpenShiftQuotaAPIGroupDSL quotas() {
        return this.delegate.quotas();
    }

    @Override
    public ProjectOperation projects() {
        return this.delegate.projects();
    }

    @Override
    public ProjectRequestOperation projectrequests() {
        return this.delegate.projectrequests();
    }

    @Override
    public MixedOperation<Role, RoleList, Resource<Role>> roles() {
        return this.delegate.roles();
    }

    @Override
    public MixedOperation<RoleBinding, RoleBindingList, Resource<RoleBinding>> roleBindings() {
        return this.delegate.roleBindings();
    }

    @Override
    public MixedOperation<Route, RouteList, Resource<Route>> routes() {
        return this.delegate.routes();
    }

    @Override
    public ParameterMixedOperation<Template, TemplateList, TemplateResource<Template, KubernetesList>> templates() {
        return this.delegate.templates();
    }

    @Override
    public MixedOperation<TemplateInstance, TemplateInstanceList, Resource<TemplateInstance>> templateInstances() {
        return this.delegate.templateInstances();
    }

    @Override
    public OpenShiftTunedAPIGroupDSL tuned() {
        return this.delegate.tuned();
    }

    @Override
    public NonNamespaceOperation<BrokerTemplateInstance, BrokerTemplateInstanceList, Resource<BrokerTemplateInstance>> brokerTemplateInstances() {
        return this.delegate.brokerTemplateInstances();
    }

    @Override
    public NonNamespaceOperation<User, UserList, Resource<User>> users() {
        return this.delegate.users();
    }

    @Override
    public MixedOperation<ClusterRoleBinding, ClusterRoleBindingList, Resource<ClusterRoleBinding>> clusterRoleBindings() {
        return this.delegate.clusterRoleBindings();
    }

    @Override
    public MixedOperation<RoleBindingRestriction, RoleBindingRestrictionList, Resource<RoleBindingRestriction>> roleBindingRestrictions() {
        return null;
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> load(InputStream is) {
        return this.delegate.load(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(KubernetesResourceList is) {
        return this.delegate.resourceList(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(HasMetadata ... items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(Collection<HasMetadata> items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(String s) {
        return this.delegate.resourceList(s);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(HasMetadata item) {
        return this.delegate.resource(item);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, Resource<Endpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public MixedOperation<Binding, KubernetesResourceList<Binding>, Resource<Binding>> bindings() {
        return this.delegate.bindings();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, Resource<Namespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, Resource<Node>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, Resource<PersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Pod, PodList, PodResource<Pod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, Resource<ResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public MixedOperation<Secret, SecretList, Resource<Secret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public MixedOperation<io.fabric8.kubernetes.api.model.Service, ServiceList, ServiceResource<io.fabric8.kubernetes.api.model.Service>> services() {
        return this.delegate.services();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, Resource<ServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public NonNamespaceOperation<APIService, APIServiceList, Resource<APIService>> apiServices() {
        return this.delegate.apiServices();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public NonNamespaceOperation<RangeAllocation, RangeAllocationList, Resource<RangeAllocation>> rangeAllocations() {
        return this.delegate.rangeAllocations();
    }

    @Override
    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, Resource<SecurityContextConstraints>> securityContextConstraints() {
        return this.delegate.securityContextConstraints();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, Resource<LimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public <T extends CustomResource> MixedOperation<T, KubernetesResourceList<T>, Resource<T>> customResources(Class<T> resourceType) {
        return this.delegate.customResources(resourceType);
    }

    @Override
    public <T extends CustomResource, L extends KubernetesResourceList<T>> MixedOperation<T, L, Resource<T>> customResources(Class<T> resourceType, Class<L> listClass) {
        return this.delegate.customResources(resourceType, listClass);
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList<T>> MixedOperation<T, L, Resource<T>> customResources(ResourceDefinitionContext crdContext, Class<T> resourceType, Class<L> listClass) {
        return this.delegate.customResources(crdContext, (Class)resourceType, (Class)listClass);
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList<T>> MixedOperation<T, L, Resource<T>> resources(Class<T> resourceType, Class<L> listClass) {
        return this.delegate.resources((Class)resourceType, (Class)listClass);
    }

    @Override
    public DiscoveryAPIGroupDSL discovery() {
        return this.delegate.discovery();
    }

    @Override
    public EventingAPIGroupDSL events() {
        return this.delegate.events();
    }

    @Override
    public ApiextensionsAPIGroupDSL apiextensions() {
        return this.delegate.apiextensions();
    }

    @Override
    public NonNamespaceOperation<CertificateSigningRequest, CertificateSigningRequestList, Resource<CertificateSigningRequest>> certificateSigningRequests() {
        return this.delegate.certificateSigningRequests();
    }

    @Override
    public CertificatesAPIGroupDSL certificates() {
        return this.delegate.certificates();
    }

    @Override
    public AuthorizationAPIGroupDSL authorization() {
        return this.delegate.authorization();
    }

    @Override
    public InOutCreateable<TokenReview, TokenReview> tokenReviews() {
        return this.delegate.tokenReviews();
    }

    @Override
    public RawCustomResourceOperationsImpl customResource(CustomResourceDefinitionContext customResourceDefinition) {
        return this.delegate.customResource(customResourceDefinition);
    }

    @Override
    public <C> C adapt(Class<C> type) {
        return this.delegate.adapt(type);
    }

    @Override
    public URL getMasterUrl() {
        return this.delegate.getMasterUrl();
    }

    @Override
    public String getApiVersion() {
        return this.delegate.getApiVersion();
    }

    @Override
    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    @Override
    public RootPaths rootPaths() {
        return this.delegate.rootPaths();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public io.fabric8.kubernetes.client.Config getConfiguration() {
        return this.delegate.getConfiguration();
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.delegate.extensions();
    }

    @Override
    public FlowControlAPIGroupDSL flowControl() {
        return this.delegate.flowControl();
    }

    @Override
    public VersionInfo getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public VersionInfo getKubernetesVersion() {
        return this.delegate.getKubernetesVersion();
    }

    @Override
    public VersionInfo getOpenShiftV3Version() {
        return this.delegate.getOpenShiftV3Version();
    }

    @Override
    public String getOpenShiftV4Version() {
        return this.delegate.getOpenShiftV4Version();
    }

    @Override
    public V1APIGroupDSL v1() {
        return this.delegate.v1();
    }

    @Override
    public RunOperations run() {
        return this.delegate.run();
    }

    @Override
    public NonNamespaceOperation<RuntimeClass, RuntimeClassList, Resource<RuntimeClass>> runtimeClasses() {
        return this.delegate.runtimeClasses();
    }

    @Override
    public AdmissionRegistrationAPIGroupDSL admissionRegistration() {
        return this.delegate.admissionRegistration();
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.delegate.apps();
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.delegate.autoscaling();
    }

    @Override
    public MachineConfigurationAPIGroupDSL machineConfigurations() {
        return this.delegate.machineConfigurations();
    }

    @Override
    public OpenShiftMachineAPIGroupDSL machine() {
        return this.delegate.machine();
    }

    @Override
    public OpenShiftMonitoringAPIGroupDSL monitoring() {
        return this.delegate.monitoring();
    }

    @Override
    public NonNamespaceOperation<NetNamespace, NetNamespaceList, Resource<NetNamespace>> netNamespaces() {
        return this.delegate.netNamespaces();
    }

    @Override
    public NonNamespaceOperation<ClusterNetwork, ClusterNetworkList, Resource<ClusterNetwork>> clusterNetworks() {
        return this.delegate.clusterNetworks();
    }

    @Override
    public MixedOperation<EgressNetworkPolicy, EgressNetworkPolicyList, Resource<EgressNetworkPolicy>> egressNetworkPolicies() {
        return this.delegate.egressNetworkPolicies();
    }

    @Override
    public NonNamespaceOperation<HostSubnet, HostSubnetList, Resource<HostSubnet>> hostSubnets() {
        return this.delegate.hostSubnets();
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.delegate.network();
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.delegate.storage();
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.delegate.batch();
    }

    @Override
    public MetricAPIGroupDSL top() {
        return this.delegate.top();
    }

    @Override
    public PolicyAPIGroupDSL policy() {
        return this.delegate.policy();
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.delegate.rbac();
    }

    @Override
    public SchedulingAPIGroupDSL scheduling() {
        return this.delegate.scheduling();
    }

    @Override
    public MixedOperation<BareMetalHost, BareMetalHostList, Resource<BareMetalHost>> bareMetalHosts() {
        return this.delegate.bareMetalHosts();
    }

    @Override
    public InOutCreateable<SubjectAccessReview, SubjectAccessReviewResponse> subjectAccessReviews() {
        return this.delegate.subjectAccessReviews();
    }

    @Override
    public InOutCreateable<ResourceAccessReview, ResourceAccessReviewResponse> resourceAccessReviews() {
        return this.delegate.resourceAccessReviews();
    }

    @Override
    public NamespacedInOutCreateable<LocalSubjectAccessReview, SubjectAccessReviewResponse> localSubjectAccessReviews() {
        return this.delegate.localSubjectAccessReviews();
    }

    @Override
    public NamespacedInOutCreateable<LocalResourceAccessReview, ResourceAccessReviewResponse> localResourceAccessReviews() {
        return this.delegate.localResourceAccessReviews();
    }

    @Override
    public NamespacedInOutCreateable<SelfSubjectRulesReview, SelfSubjectRulesReview> selfSubjectRulesReviews() {
        return this.delegate.selfSubjectRulesReviews();
    }

    @Override
    public NamespacedInOutCreateable<SubjectRulesReview, SubjectRulesReview> subjectRulesReviews() {
        return this.delegate.subjectRulesReviews();
    }

    @Override
    public OpenShiftStorageVersionMigratorApiGroupDSL kubeStorageVersionMigrator() {
        return this.delegate.kubeStorageVersionMigrator();
    }

    @Override
    public NonNamespaceOperation<ClusterRole, ClusterRoleList, Resource<ClusterRole>> clusterRoles() {
        return this.delegate.clusterRoles();
    }

    @Override
    public SharedInformerFactory informers() {
        return this.delegate.informers();
    }

    @Override
    public SharedInformerFactory informers(ExecutorService executorService) {
        return this.delegate.informers(executorService);
    }

    public LeaderElectorBuilder<NamespacedOpenShiftClient> leaderElector() {
        return this.delegate.leaderElector();
    }

    @Override
    public MixedOperation<Lease, LeaseList, Resource<Lease>> leases() {
        return this.delegate.leases();
    }

    @Override
    public NamespacedOpenShiftClient inAnyNamespace() {
        return this.delegate.inAnyNamespace();
    }

    @Override
    public NamespacedOpenShiftClient inNamespace(String name) {
        return this.delegate.inNamespace(name);
    }

    @Override
    public FunctionCallable<NamespacedOpenShiftClient> withRequestConfig(RequestConfig requestConfig) {
        return this.delegate.withRequestConfig(requestConfig);
    }

    @Override
    public User currentUser() {
        return this.delegate.currentUser();
    }

    @Override
    public NonNamespaceOperation<Identity, IdentityList, Resource<Identity>> identities() {
        return this.delegate.identities();
    }

    @Override
    public InOutCreateable<UserIdentityMapping, UserIdentityMapping> userIdentityMappings() {
        return null;
    }

    @Override
    public NonNamespaceOperation<UserOAuthAccessToken, UserOAuthAccessTokenList, Resource<UserOAuthAccessToken>> userOAuthAccessTokens() {
        return this.delegate.userOAuthAccessTokens();
    }

    @Override
    public OpenShiftWhereaboutsAPIGroupDSL whereabouts() {
        return this.delegate.whereabouts();
    }

    @Override
    public boolean supportsOpenShiftAPIGroup(String apiGroup) {
        return this.delegate.supportsOpenShiftAPIGroup(apiGroup);
    }

    @Override
    public MixedOperation<GenericKubernetesResource, GenericKubernetesResourceList, Resource<GenericKubernetesResource>> genericKubernetesResources(String apiVersion, String kind) {
        return this.delegate.genericKubernetesResources(apiVersion, kind);
    }
}

