/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_10;

import io.fabric8.kubernetes.api.model.v5_10.APIGroupList;
import io.fabric8.kubernetes.clnt.v5_10.BaseClient;
import io.fabric8.kubernetes.clnt.v5_10.Client;
import io.fabric8.kubernetes.clnt.v5_10.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_10.utils.BackwardsCompatibilityInterceptor;
import io.fabric8.kubernetes.clnt.v5_10.utils.ImpersonatorInterceptor;
import io.fabric8.openshift.clnt.v5_10.DefaultOpenShiftClient;
import io.fabric8.openshift.clnt.v5_10.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_10.OpenShiftNotAvailableException;
import io.fabric8.openshift.clnt.v5_10.internal.OpenShiftOAuthInterceptor;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OpenshiftAdapterSupport {
    private static final Map<String, Boolean> API_GROUPS_ENABLED_PER_URL = new ConcurrentHashMap<String, Boolean>();

    public Boolean isAdaptable(Client client) {
        OpenShiftConfig config = OpenShiftConfig.wrap(client.getConfiguration());
        return OpenshiftAdapterSupport.hasCustomOpenShiftUrl(config) || OpenshiftAdapterSupport.isOpenShiftAPIGroups(client.adapt(OkHttpClient.class), config);
    }

    public DefaultOpenShiftClient adapt(Client client) {
        if (!this.isAdaptable(client).booleanValue()) {
            throw new OpenShiftNotAvailableException("OpenShift is not available. Root paths at: " + client.getMasterUrl() + " do not include oapi.");
        }
        return new DefaultOpenShiftClient(client.adapt(OkHttpClient.class), OpenShiftConfig.wrap(client.getConfiguration()));
    }

    public static boolean isOpenShiftAPIGroups(OkHttpClient client, OpenShiftConfig config) {
        if (config.isDisableApiGroupCheck()) {
            return true;
        }
        String url = config.getMasterUrl();
        return API_GROUPS_ENABLED_PER_URL.computeIfAbsent(url, k -> {
            APIGroupList apiGroups = new BaseClient(OpenshiftAdapterSupport.adaptOkHttpClient(client, config), config).getApiGroups();
            if (apiGroups == null) {
                return false;
            }
            return apiGroups.getGroups().stream().anyMatch(g -> g.getName().endsWith("openshift.io"));
        });
    }

    static boolean hasCustomOpenShiftUrl(OpenShiftConfig config) {
        try {
            URI masterUri = new URI(config.getMasterUrl()).resolve("/");
            URI openshfitUri = new URI(config.getOpenShiftUrl()).resolve("/");
            return !masterUri.equals(openshfitUri);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static OkHttpClient adaptOkHttpClient(OkHttpClient okHttpClient, OpenShiftConfig config) {
        OkHttpClient.Builder builder = okHttpClient != null ? okHttpClient.newBuilder().authenticator(Authenticator.NONE) : new OkHttpClient.Builder().authenticator(Authenticator.NONE);
        builder.interceptors().clear();
        return builder.addInterceptor((Interceptor)new OpenShiftOAuthInterceptor(okHttpClient, config)).addInterceptor((Interceptor)new ImpersonatorInterceptor(config)).addInterceptor((Interceptor)new BackwardsCompatibilityInterceptor()).build();
    }
}

