/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_10;

import io.fabric8.kubernetes.api.builder.v5_10.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_10.TLSProfileSpec;
import io.fabric8.openshift.api.model.v5_10.TLSProfileSpecFluent;
import io.fabric8.openshift.api.model.v5_10.TLSProfileSpecFluentImpl;
import java.util.Objects;

public class TLSProfileSpecBuilder
extends TLSProfileSpecFluentImpl<TLSProfileSpecBuilder>
implements VisitableBuilder<TLSProfileSpec, TLSProfileSpecBuilder> {
    TLSProfileSpecFluent<?> fluent;
    Boolean validationEnabled;

    public TLSProfileSpecBuilder() {
        this(false);
    }

    public TLSProfileSpecBuilder(Boolean validationEnabled) {
        this(new TLSProfileSpec(), validationEnabled);
    }

    public TLSProfileSpecBuilder(TLSProfileSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public TLSProfileSpecBuilder(TLSProfileSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TLSProfileSpec(), validationEnabled);
    }

    public TLSProfileSpecBuilder(TLSProfileSpecFluent<?> fluent, TLSProfileSpec instance) {
        this(fluent, instance, false);
    }

    public TLSProfileSpecBuilder(TLSProfileSpecFluent<?> fluent, TLSProfileSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCiphers(instance.getCiphers());
        fluent.withMinTLSVersion(instance.getMinTLSVersion());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public TLSProfileSpecBuilder(TLSProfileSpec instance) {
        this(instance, (Boolean)false);
    }

    public TLSProfileSpecBuilder(TLSProfileSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCiphers(instance.getCiphers());
        this.withMinTLSVersion(instance.getMinTLSVersion());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public TLSProfileSpec build() {
        TLSProfileSpec buildable = new TLSProfileSpec(this.fluent.getCiphers(), this.fluent.getMinTLSVersion());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TLSProfileSpecBuilder that = (TLSProfileSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

