/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_10;

import io.fabric8.kubernetes.api.builder.v5_10.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_10.Route;
import io.fabric8.openshift.api.model.v5_10.RouteFluent;
import io.fabric8.openshift.api.model.v5_10.RouteFluentImpl;
import java.util.Objects;

public class RouteBuilder
extends RouteFluentImpl<RouteBuilder>
implements VisitableBuilder<Route, RouteBuilder> {
    RouteFluent<?> fluent;
    Boolean validationEnabled;

    public RouteBuilder() {
        this(false);
    }

    public RouteBuilder(Boolean validationEnabled) {
        this(new Route(), validationEnabled);
    }

    public RouteBuilder(RouteFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public RouteBuilder(RouteFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Route(), validationEnabled);
    }

    public RouteBuilder(RouteFluent<?> fluent, Route instance) {
        this(fluent, instance, false);
    }

    public RouteBuilder(RouteFluent<?> fluent, Route instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public RouteBuilder(Route instance) {
        this(instance, (Boolean)false);
    }

    public RouteBuilder(Route instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Route build() {
        Route buildable = new Route(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteBuilder that = (RouteBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

