/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_10.server.mock;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.model.v5_10.KubernetesResource;
import io.fabric8.kubernetes.api.model.v5_10.WatchEvent;
import io.fabric8.kubernetes.clnt.v5_10.Watcher;
import io.fabric8.kubernetes.clnt.v5_10.utils.Serialization;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.crud.AttributeSet;
import io.fabric8.mockwebserver.internal.WebSocketMessage;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;

class WatchEventsListener
extends WebSocketListener {
    private final AtomicReference<WebSocket> webSocketRef = new AtomicReference();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private final AttributeSet attributeSet;
    private final Context context;
    private final Set<WatchEventsListener> watchEventListenerList;
    private final Logger logger;
    private final Consumer<WatchEventsListener> onOpenAction;

    public WatchEventsListener(Context context, AttributeSet attributeSet, Set<WatchEventsListener> watchEventListenerList, Logger logger, Consumer<WatchEventsListener> onOpenAction) {
        this.logger = logger;
        this.context = context;
        this.attributeSet = attributeSet;
        this.watchEventListenerList = watchEventListenerList;
        this.onOpenAction = onOpenAction;
    }

    public boolean attributeMatches(AttributeSet set) {
        return set.matches(this.attributeSet);
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.webSocketRef.set(webSocket);
        this.onOpenAction.accept(this);
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        this.webSocketRef.get().close(code, reason);
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        if (this.webSocketRef.get() != null) {
            this.webSocketRef.get().close(code, reason);
        }
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            this.logger.debug("Interrupted waiting for the executor service to shutdown: {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
        this.watchEventListenerList.remove((Object)this);
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        webSocket.close(1000, t.getMessage());
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            this.logger.debug("Interrupted waiting for the executor service to shutdown: {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
        this.watchEventListenerList.remove((Object)this);
    }

    public void sendWebSocketResponse(String object, Watcher.Action action) {
        WebSocketMessage message = WatchEventsListener.toWebSocketMessage(this.context, new WatchEvent(Serialization.unmarshal(object, KubernetesResource.class), action.name()));
        this.executor.schedule(() -> this.webSocketRef.get().send(message.getBody()), (long)message.getDelay(), TimeUnit.SECONDS);
    }

    private static WebSocketMessage toWebSocketMessage(Context context, Object content) {
        return WatchEventsListener.toWebSocketMessage(context, content, true);
    }

    private static WebSocketMessage toWebSocketMessage(Context context, Object content, Boolean toBeRemoved) {
        return WatchEventsListener.toWebSocketMessage(context, 0L, content, toBeRemoved);
    }

    private static WebSocketMessage toWebSocketMessage(Context context, Long delay, Object content, Boolean toBeRemoved) {
        if (content instanceof String) {
            return new WebSocketMessage(delay, (String)content, toBeRemoved.booleanValue());
        }
        if (content instanceof WebSocketMessage) {
            return (WebSocketMessage)content;
        }
        try {
            return WatchEventsListener.toWebSocketMessage(context, delay, context.getMapper().writeValueAsString(content), toBeRemoved);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

