/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_10.server.mock;

import io.fabric8.kubernetes.clnt.v5_10.KubernetesClient;
import io.fabric8.kubernetes.clnt.v5_10.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v5_10.server.mock.EnableKubernetesMockClient;
import io.fabric8.kubernetes.clnt.v5_10.server.mock.KubernetesMixedDispatcher;
import io.fabric8.kubernetes.clnt.v5_10.server.mock.KubernetesMockServer;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Optional;
import java.util.Queue;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class KubernetesMockServerExtension
implements AfterEachCallback,
AfterAllCallback,
BeforeEachCallback,
BeforeAllCallback {
    private KubernetesMockServer mock;
    private NamespacedKubernetesClient client;

    public void afterEach(ExtensionContext context) {
        Class testClass;
        Optional optClass = context.getTestClass();
        if (optClass.isPresent() && this.findField(testClass = (Class)optClass.get(), true) == null) {
            this.destroy();
        }
    }

    public void afterAll(ExtensionContext context) {
        this.destroy();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.setKubernetesClientAndMockServerFields(context, false);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.setKubernetesClientAndMockServerFields(context, true);
    }

    protected void setFieldIfKubernetesClientOrMockServer(ExtensionContext context, boolean isStatic, Field field) throws IllegalAccessException {
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getClientType(), (i, f) -> f.set(i, this.client));
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getKubernetesMockServerType(), (i, f) -> f.set(i, (Object)this.mock));
    }

    protected void setFieldIfEqualsToProvidedType(ExtensionContext context, boolean isStatic, Field field, Class<?> fieldType, SetTestClassField setTestClassField) throws IllegalAccessException {
        if (field.getType().equals(fieldType) && Modifier.isStatic(field.getModifiers()) == isStatic) {
            this.setKubernetesClientStaticOrMemberField(context, isStatic, field, setTestClassField);
        }
    }

    protected void initializeKubernetesClientAndMockServer(Class<?> testClass) {
        EnableKubernetesMockClient a = testClass.getAnnotation(EnableKubernetesMockClient.class);
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        this.mock = a.crud() ? new KubernetesMockServer(new Context(), new MockWebServer(), responses, new KubernetesMixedDispatcher(responses), a.https()) : new KubernetesMockServer(a.https());
        this.mock.init();
        this.client = this.mock.createClient();
    }

    protected void destroy() {
        this.mock.destroy();
        this.client.close();
    }

    protected Class<?> getClientType() {
        return KubernetesClient.class;
    }

    protected Class<?> getKubernetesMockServerType() {
        return KubernetesMockServer.class;
    }

    private Field findField(Class<?> testClass, boolean isStatic) {
        Field[] fields;
        for (Field f : fields = testClass.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) != isStatic || !f.getType().equals(this.getClientType()) && !f.getType().equals(this.getKubernetesMockServerType())) continue;
            return f;
        }
        return null;
    }

    private void setKubernetesClientAndMockServerFields(ExtensionContext context, boolean isStatic) throws IllegalAccessException {
        Optional optClass = context.getTestClass();
        if (optClass.isPresent()) {
            Class testClass = (Class)optClass.get();
            this.initializeKubernetesClientAndMockServer(testClass);
            this.processTestClassDeclaredFields(context, isStatic, testClass);
        }
    }

    private void processTestClassDeclaredFields(ExtensionContext context, boolean isStatic, Class<?> testClass) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = testClass.getDeclaredFields()) {
            this.setFieldIfKubernetesClientOrMockServer(context, isStatic, field);
        }
    }

    private void setKubernetesClientStaticOrMemberField(ExtensionContext context, boolean isStatic, Field f, SetTestClassField setTestClassField) throws IllegalAccessException {
        f.setAccessible(true);
        if (isStatic) {
            setTestClassField.apply(null, f);
        } else {
            Optional optTestInstance = context.getTestInstance();
            if (optTestInstance.isPresent()) {
                setTestClassField.apply(optTestInstance.get(), f);
            }
        }
    }

    public static interface SetTestClassField {
        public void apply(Object var1, Field var2) throws IllegalAccessException;
    }
}

