/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_10;

import io.fabric8.kubernetes.api.model.v5_10.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_10.Status;
import io.fabric8.kubernetes.clnt.v5_10.OperationInfo;
import io.fabric8.kubernetes.clnt.v5_10.utils.Utils;

public class KubernetesClientException
extends RuntimeException {
    private int code;
    private Status status;
    private String group;
    private String version;
    private String resourcePlural;
    private String namespace;

    public KubernetesClientException(String message) {
        super(message);
    }

    public KubernetesClientException(String message, Throwable t) {
        super(message, t);
    }

    public KubernetesClientException(Status status) {
        this(status.getMessage(), status.getCode(), status);
    }

    public KubernetesClientException(String message, int code, Status status) {
        this(message, code, status, null, null, null, null);
    }

    public KubernetesClientException(String message, int code, Status status, String group, String version, String resourcePlural, String namespace) {
        super(message);
        this.code = code;
        this.status = status;
        this.group = group;
        this.version = version;
        this.resourcePlural = resourcePlural;
        this.namespace = namespace;
    }

    public KubernetesClientException(String message, Throwable t, String group, String version, String resourcePlural, String namespace) {
        super(message, t);
        this.group = group;
        this.version = version;
        this.resourcePlural = resourcePlural;
        this.namespace = namespace;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getCode() {
        return this.code;
    }

    public String getGroup() {
        return this.group;
    }

    public String getVersion() {
        return this.version;
    }

    public String getResourcePlural() {
        return this.resourcePlural;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getFullResourceName() {
        if (this.resourcePlural != null && this.group != null) {
            return HasMetadata.getFullResourceName(this.resourcePlural, this.group);
        }
        return null;
    }

    public static RuntimeException launderThrowable(Throwable cause) {
        return KubernetesClientException.launderThrowable("An error has occurred.", cause);
    }

    public static RuntimeException launderThrowable(String message, Throwable cause) {
        RuntimeException processed = KubernetesClientException.processCause(cause);
        if (processed != null) {
            return processed;
        }
        throw new KubernetesClientException(message, cause);
    }

    private static RuntimeException processCause(Throwable cause) {
        if (cause instanceof RuntimeException) {
            return (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    public static RuntimeException launderThrowable(OperationInfo spec, Throwable cause) {
        Status status;
        RuntimeException processed = KubernetesClientException.processCause(cause);
        if (processed != null) {
            return processed;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(KubernetesClientException.describeOperation(spec)).append(" failed.");
        if (cause instanceof KubernetesClientException && (status = ((KubernetesClientException)cause).getStatus()) != null && Utils.isNotNullOrEmpty(status.getMessage())) {
            sb.append("Reason: ").append(status.getMessage());
        }
        throw new KubernetesClientException(sb.toString(), cause, spec.getGroup(), spec.getVersion(), spec.getPlural(), spec.getNamespace());
    }

    @Deprecated
    public static RuntimeException launderThrowable(OperationInfo spec, Status status, Throwable cause) {
        StringBuilder sb = new StringBuilder();
        sb.append(KubernetesClientException.describeOperation(spec) + " failed.");
        if (status != null && Utils.isNotNullOrEmpty(status.getMessage())) {
            sb.append("Reason: ").append(status.getMessage());
        }
        return KubernetesClientException.launderThrowable(sb.toString(), cause);
    }

    private static final String describeOperation(OperationInfo operation) {
        StringBuilder sb = new StringBuilder();
        sb.append("Operation");
        if (Utils.isNotNullOrEmpty(operation.getOperationType())) {
            sb.append(": [").append(operation.getOperationType() + "]");
        }
        sb.append(" ");
        sb.append(" for kind: [").append(operation.getKind()).append("] ");
        sb.append(" with name: [").append(operation.getName()).append("] ");
        sb.append(" in namespace: [").append(operation.getNamespace()).append("] ");
        return sb.toString();
    }
}

